/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.scope;

import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ObjectScopeProviderRegistry.class})
public class ObjectScopeProviderRegistryImpl
implements ObjectScopeProviderRegistry {
    private ServiceTrackerMap<String, ObjectScopeProvider> _serviceTrackerMap;

    public ObjectScopeProvider getObjectScopeProvider(String objectScopeProviderKey) {
        ObjectScopeProvider objectScopeProvider = (ObjectScopeProvider)this._serviceTrackerMap.getService((Object)objectScopeProviderKey);
        if (objectScopeProvider == null) {
            throw new IllegalArgumentException("No object scope provider found with key " + objectScopeProviderKey);
        }
        return objectScopeProvider;
    }

    public List<ObjectScopeProvider> getObjectScopeProviders() {
        List objectScopeProviders = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        if (objectScopeProviders == null) {
            return Collections.emptyList();
        }
        return objectScopeProviders;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectScopeProvider.class, (String)"object.scope.provider.key");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

