/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.engine;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionEngine.class})
public class ObjectActionEngineImpl
implements ObjectActionEngine {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionEngineImpl.class);
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) {
        try {
            this._executeObjectActions(className, companyId, objectActionTriggerKey, payloadJSONObject, userId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private void _executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) throws Exception {
        if (companyId == 0L || userId == 0L) {
            return;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null || companyId != user.getCompanyId()) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(user.getCompanyId(), className);
        if (objectDefinition == null) {
            return;
        }
        payloadJSONObject.put("companyId", companyId).put("userId", userId);
        List objectActions = this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), objectActionTriggerKey);
        for (ObjectAction objectAction : objectActions) {
            ObjectActionExecutor objectActionExecutor = this._objectActionExecutorRegistry.getObjectActionExecutor(objectAction.getObjectActionExecutorKey());
            objectActionExecutor.execute(companyId, objectAction.getParametersUnicodeProperties(), payloadJSONObject, userId);
        }
    }
}

