/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelResourcePermissionFactory.ModelResourcePermissionConfigurator.class})
public class ObjectDLFileEntryModelResourcePermissionConfigurator
implements ModelResourcePermissionFactory.ModelResourcePermissionConfigurator<DLFileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDLFileEntryModelResourcePermissionConfigurator.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public void configureModelResourcePermissionLogics(ModelResourcePermission<DLFileEntry> modelResourcePermission, Consumer<ModelResourcePermissionLogic<DLFileEntry>> consumer) {
        consumer.accept((ModelResourcePermissionLogic<DLFileEntry>)((ModelResourcePermissionLogic)(permissionChecker, name, dlFileEntry, actionId) -> {
            ObjectEntry objectEntry;
            if (!actionId.equals("DOWNLOAD") || !FeatureFlagManagerUtil.isEnabled((long)dlFileEntry.getCompanyId(), (String)"LPD-17564")) {
                return null;
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            HttpServletRequest httpServletRequest = serviceContext.getRequest();
            if (httpServletRequest == null) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
            if (!download) {
                return null;
            }
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"objectDefinitionExternalReferenceCode"), companyId);
            if (objectDefinition == null) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            long groupId = 0L;
            Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"groupExternalReferenceCode"), companyId);
            if (group != null) {
                groupId = group.getGroupId();
            }
            if ((objectEntry = this._objectEntryLocalService.fetchObjectEntry(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"objectEntryExternalReferenceCode"), groupId, objectDefinition.getObjectDefinitionId())) == null) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            String objectFieldExternalReferenceCode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"objectFieldExternalReferenceCode");
            if (Validator.isNull((String)objectFieldExternalReferenceCode)) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldExternalReferenceCode, objectDefinition.getObjectDefinitionId());
            if (objectField == null) {
                return this._validateObjectDefinitionClassName((DLFileEntry)dlFileEntry);
            }
            ModelResourcePermission objectEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
            if (objectEntryModelResourcePermission == null || objectEntryModelResourcePermission.contains(permissionChecker, objectEntry.getObjectEntryId(), "VIEW") && objectEntryModelResourcePermission.contains(permissionChecker, objectEntry.getObjectEntryId(), objectField.getAttachmentDownloadActionKey())) {
                return null;
            }
            return false;
        }));
    }

    private Boolean _validateObjectDefinitionClassName(DLFileEntry dlFileEntry) {
        String className = dlFileEntry.getClassName();
        if (!className.startsWith("com.liferay.object.model.ObjectDefinition#")) {
            return null;
        }
        _log.error((Object)("Unable to verify download permission for " + className));
        return false;
    }
}

