/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.feature.flag;

import com.liferay.object.definition.security.permission.resource.util.ObjectDefinitionResourcePermissionUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"feature.flag.key=LPD-17564"}, service={FeatureFlagListener.class})
public class AttachmentObjectFieldDownloadActionFeatureFlagListener
implements FeatureFlagListener {
    private static final Log _log = LogFactoryUtil.getLog(AttachmentObjectFieldDownloadActionFeatureFlagListener.class);
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    public void onValue(long companyId, String featureFlagKey, boolean enabled) {
        if (!Objects.equals(featureFlagKey, "LPD-17564")) {
            return;
        }
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(companyId, 0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            List objectFields = this._objectFieldLocalService.getObjectFieldsByBusinessType(objectDefinition.getObjectDefinitionId(), "Attachment");
            List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(objectDefinition.getCompanyId(), objectDefinition.getClassName(), 4);
            for (ObjectField objectField : objectFields) {
                String attachmentDownloadActionKey = objectField.getAttachmentDownloadActionKey();
                if (enabled) {
                    ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction(objectDefinition.getClassName(), attachmentDownloadActionKey);
                    if (resourceAction != null) continue;
                    try {
                        ObjectDefinitionResourcePermissionUtil.populateResourceActions(null, null, (ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService, Collections.singletonList(objectField), (PortletLocalService)this._portletLocalService, (ResourceActions)this._resourceActions);
                        this._objectFieldLocalService.addOrUpdateObjectFieldPLOEntries(objectField);
                        for (ResourcePermission resourcePermission : resourcePermissions) {
                            if (resourcePermission.hasActionId(attachmentDownloadActionKey) || !resourcePermission.isViewActionId()) continue;
                            resourcePermission.addResourceAction(attachmentDownloadActionKey);
                            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                        continue;
                    }
                }
                this._ploEntryLocalService.deletePLOEntries(objectField.getCompanyId(), "action." + attachmentDownloadActionKey);
                this._resourceActions.removeModelResource(objectDefinition.getClassName(), attachmentDownloadActionKey);
            }
        }
    }
}

