/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectEntryVersionLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectEntryVersion service. Represents a row in the &quot;ObjectEntryVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectEntryVersionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectEntryVersionImpl
 * @see ObjectEntryVersion
 * @generated
 */
public abstract class ObjectEntryVersionBaseImpl
	extends ObjectEntryVersionModelImpl implements ObjectEntryVersion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object entry version model instance should use the <code>ObjectEntryVersion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectEntryVersionLocalServiceUtil.addObjectEntryVersion(this);
		}
		else {
			ObjectEntryVersionLocalServiceUtil.updateObjectEntryVersion(this);
		}
	}

}