/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ObjectActionExecutorRegistry.class})
public class ObjectActionExecutorRegistryImpl
implements ObjectActionExecutorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionExecutorRegistryImpl.class);
    private ServiceTrackerMap<String, ObjectActionExecutor> _serviceTrackerMap;

    public ObjectActionExecutor getObjectActionExecutor(long companyId, String objectActionExecutorKey) {
        ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)this._serviceTrackerMap.getService((Object)objectActionExecutorKey);
        if (objectActionExecutor == null) {
            objectActionExecutor = (ObjectActionExecutor)this._serviceTrackerMap.getService((Object)this._getCompanyScopedKey(objectActionExecutorKey, companyId));
        }
        if (objectActionExecutor == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"No object action executor found with company ID ", companyId, " and key ", objectActionExecutorKey}));
        }
        return objectActionExecutor;
    }

    public List<ObjectActionExecutor> getObjectActionExecutors(long companyId, String objectDefinitionName) {
        Collection objectActionExecutors = this._serviceTrackerMap.values();
        if (objectActionExecutors == null) {
            return Collections.emptyList();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Object action executors " + String.valueOf(objectActionExecutors)));
        }
        List filteredObjectActionExecutors = ListUtil.filter((List)ListUtil.fromCollection((Collection)objectActionExecutors), objectActionExecutor -> {
            ObjectDefinitionScoped objectActionExecutorObjectDefinitionScoped;
            CompanyScoped objectActionExecutorCompanyScoped;
            if (objectActionExecutor instanceof CompanyScoped && !(objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor).isAllowedCompany(companyId)) {
                return false;
            }
            return !(objectActionExecutor instanceof ObjectDefinitionScoped) || (objectActionExecutorObjectDefinitionScoped = (ObjectDefinitionScoped)objectActionExecutor).isAllowedObjectDefinition(objectDefinitionName);
        });
        ListUtil.sort((List)filteredObjectActionExecutors, (objectActionExecutor1, objectActionExecutor2) -> {
            String key1 = objectActionExecutor1.getKey();
            String key2 = objectActionExecutor2.getKey();
            return key1.compareTo(key2);
        });
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Filtered object action executors for company ID ", companyId, " and object definition name ", objectDefinitionName, ": ", filteredObjectActionExecutors}));
        }
        return filteredObjectActionExecutors;
    }

    public boolean hasObjectActionExecutor(String objectActionExecutorKey) {
        return this._serviceTrackerMap.containsKey((Object)objectActionExecutorKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectActionExecutor.class, null, (serviceReference, emitter) -> {
            try {
                ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)bundleContext.getService(serviceReference);
                String key = objectActionExecutor.getKey();
                if (objectActionExecutor instanceof CompanyScoped) {
                    CompanyScoped objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor;
                    key = this._getCompanyScopedKey(key, objectActionExecutorCompanyScoped.getAllowedCompanyId());
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Registering object action executor with key ", key, " and class ", objectActionExecutor.getClass()}));
                }
                emitter.emit((Object)key);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to get object action executor service", (Throwable)exception);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getCompanyScopedKey(String key, long company) {
        return StringBundler.concat((Object[])new Object[]{key, "#", company});
    }
}

