/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.exportimport.kernel.empty.model.EmptyModelManager;
import com.liferay.object.entry.folder.subscription.util.ObjectEntryFolderSubscriptionUtil;
import com.liferay.object.entry.folder.util.ObjectEntryFolderThreadLocal;
import com.liferay.object.exception.DuplicateObjectEntryFolderExternalReferenceCodeException;
import com.liferay.object.exception.ObjectEntryFolderNameException;
import com.liferay.object.exception.ObjectEntryFolderParentObjectEntryFolderIdException;
import com.liferay.object.exception.ObjectEntryFolderScopeException;
import com.liferay.object.exception.RequiredObjectEntryFolderException;
import com.liferay.object.internal.entry.folder.util.ObjectEntryFolderUtil;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectEntryFolderTable;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.base.ObjectEntryFolderLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntryFolder"}, service={AopService.class})
public class ObjectEntryFolderLocalServiceImpl
extends ObjectEntryFolderLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private EmptyModelManager _emptyModelManager;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder addObjectEntryFolder(String externalReferenceCode, long groupId, long userId, long parentObjectEntryFolderId, String description, Map<Locale, String> labelMap, String name, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(externalReferenceCode, groupId, user.getCompanyId());
        this._validateParentObjectEntryFolderId(groupId, null, parentObjectEntryFolderId);
        this._validateName(groupId, user.getCompanyId(), 0L, parentObjectEntryFolderId, name);
        ObjectEntryFolder objectEntryFolder = this._addObjectEntryFolder(externalReferenceCode, groupId, parentObjectEntryFolderId, description, labelMap, name, serviceContext, 0, user);
        this._updateAsset(objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    @Override
    public ObjectEntryFolder deleteObjectEntryFolder(long objectEntryFolderId) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(objectEntryFolderId);
        return this.objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder);
    }

    @Override
    public ObjectEntryFolder deleteObjectEntryFolder(ObjectEntryFolder objectEntryFolder) throws PortalException {
        if (!ObjectEntryFolderThreadLocal.isForceDeleteSystemObjectEntryFolder() && StringUtil.startsWith((String)objectEntryFolder.getExternalReferenceCode(), (String)"L_")) {
            throw new RequiredObjectEntryFolderException("System object entry folder " + objectEntryFolder.getExternalReferenceCode() + " cannot be deleted");
        }
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)objectEntryFolder.getGroupId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)objectEntryFolder.getCompanyId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"objectEntryFolderId", (Object)objectEntryFolder.getObjectEntryFolderId()));
        });
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> this._objectEntryLocalService.deleteObjectEntry(objectEntry));
        actionableDynamicQuery.performActions();
        actionableDynamicQuery = this.objectEntryFolderLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)objectEntryFolder.getGroupId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)objectEntryFolder.getCompanyId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"parentObjectEntryFolderId", (Object)objectEntryFolder.getObjectEntryFolderId()));
        });
        actionableDynamicQuery.setPerformActionMethod(descendantObjectEntryFolder -> this.objectEntryFolderLocalService.deleteObjectEntryFolder(descendantObjectEntryFolder));
        actionableDynamicQuery.performActions();
        this._resourceLocalService.deleteResource(objectEntryFolder.getCompanyId(), ObjectEntryFolder.class.getName(), 4, objectEntryFolder.getObjectEntryFolderId());
        this._assetEntryLocalService.deleteEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            this._subscriptionLocalService.deleteSubscriptions(objectEntryFolder.getCompanyId(), ObjectEntryFolder.class.getName(), this._getClassPK(objectEntryFolder.getGroupId(), objectEntryFolder.getObjectEntryFolderId()));
        }
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564") && objectEntryFolder.getStatus() == 8) {
            this._trashEntryLocalService.deleteEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        }
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-42553")) {
            this._workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), -1L);
        }
        this._resourceLocalService.deleteResource(objectEntryFolder.getCompanyId(), ObjectEntryFolder.class.getName(), 4, objectEntryFolder.getObjectEntryFolderId());
        return super.deleteObjectEntryFolder(objectEntryFolder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder deleteObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
        return this.objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder);
    }

    public ObjectEntryFolder fetchObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) {
        return this.objectEntryFolderPersistence.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public ObjectEntryFolder getObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) throws PortalException {
        return this.objectEntryFolderPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public List<ObjectEntryFolder> getObjectEntryFolders(long groupId, long companyId, long parentObjectEntryFolderId, int start, int end) {
        return this.objectEntryFolderPersistence.findByG_C_P(groupId, companyId, parentObjectEntryFolderId, start, end);
    }

    public List<ObjectEntryFolder> getObjectEntryFoldersByExternalReferenceCode(String externalReferenceCode, List<Long> groupIds, long companyId) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ObjectEntryFolderTable.INSTANCE).from((Table)ObjectEntryFolderTable.INSTANCE).where(ObjectEntryFolderTable.INSTANCE.externalReferenceCode.eq((Object)externalReferenceCode).and((Expression)ObjectEntryFolderTable.INSTANCE.groupId.in((Object[])groupIds.toArray(new Long[0]))).and((Expression)ObjectEntryFolderTable.INSTANCE.companyId.eq((Object)companyId))));
    }

    public int getObjectEntryFoldersCount(long groupId, long companyId, long parentObjectEntryFolderId) {
        return this.objectEntryFolderPersistence.countByG_C_P(groupId, companyId, parentObjectEntryFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder getOrAddEmptyObjectEntryFolder(String externalReferenceCode, long groupId, long companyId, long userId, ServiceContext serviceContext) throws PortalException {
        return (ObjectEntryFolder)this._emptyModelManager.getOrAddEmptyModel(ObjectEntryFolder.class.getName(), Long.valueOf(companyId), () -> this._addObjectEntryFolder(externalReferenceCode, groupId, 0L, "", null, externalReferenceCode, serviceContext, 9, this._userLocalService.getUser(userId)), externalReferenceCode, (_externalReferenceCode, _groupId) -> this.fetchObjectEntryFolderByExternalReferenceCode((String)_externalReferenceCode, (long)_groupId, companyId), (_externalReferenceCode, _groupId) -> this.getObjectEntryFolderByExternalReferenceCode((String)_externalReferenceCode, (long)_groupId, companyId), groupId, ObjectEntryFolder.class.getName());
    }

    public void moveObjectEntryFoldersToTrash(long userId, ObjectEntryFolder parentObjectEntryFolder, ServiceContext serviceContext) throws PortalException {
        for (ObjectEntryFolder objectEntryFolder : this.objectEntryFolderPersistence.findByG_C_P(parentObjectEntryFolder.getGroupId(), parentObjectEntryFolder.getCompanyId(), parentObjectEntryFolder.getObjectEntryFolderId())) {
            if (objectEntryFolder.getStatus() == 8) continue;
            objectEntryFolder = this._moveObjectEntryFolderToTrash(objectEntryFolder, objectEntryFolder.getParentObjectEntryFolderId(), serviceContext, userId);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectEntryFolder.class);
            indexer.reindex((Object)objectEntryFolder);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder moveObjectEntryFolderToTrash(long userId, ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext) throws PortalException {
        if (objectEntryFolder.getStatus() == 8) {
            throw new TrashEntryException();
        }
        long parentObjectEntryFolderId = objectEntryFolder.getParentObjectEntryFolderId();
        objectEntryFolder.setParentObjectEntryFolderId(ObjectEntryFolderUtil.getRootObjectEntryFolderId(parentObjectEntryFolderId));
        return this._moveObjectEntryFolderToTrash(objectEntryFolder, parentObjectEntryFolderId, serviceContext, userId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder restoreObjectEntryFolderFromTrash(long userId, ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext) throws PortalException {
        if (objectEntryFolder.getStatus() != 8) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        objectEntryFolder.setParentObjectEntryFolderId(ObjectEntryFolderUtil.getObjectEntryFolderId(objectEntryFolder.getParentObjectEntryFolderId(), GetterUtil.getLong((String)trashEntry.getTypeSettingsProperty("parentObjectEntryFolderId"))));
        return this._restoreObjectEntryFolderFromTrash(objectEntryFolder, serviceContext, trashEntry, userId);
    }

    public void restoreObjectEntryFoldersFromTrash(long userId, ObjectEntryFolder parentObjectEntryFolder, ServiceContext serviceContext) throws PortalException {
        for (ObjectEntryFolder objectEntryFolder : this.objectEntryFolderPersistence.findByG_C_P(parentObjectEntryFolder.getGroupId(), parentObjectEntryFolder.getCompanyId(), parentObjectEntryFolder.getObjectEntryFolderId())) {
            if (objectEntryFolder.getStatus() != 8) continue;
            objectEntryFolder = this._restoreObjectEntryFolderFromTrash(objectEntryFolder, serviceContext, this._trashEntryLocalService.getEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId()), userId);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectEntryFolder.class);
            indexer.reindex((Object)objectEntryFolder);
        }
    }

    public void subscribeObjectEntryFolder(long userId, long groupId, long objectEntryFolderId) throws PortalException {
        User user = this._userLocalService.fetchUser(userId);
        if (ObjectEntryFolderSubscriptionUtil.isSubscribedToObjectEntryFolder((long)user.getCompanyId(), (long)groupId, (long)objectEntryFolderId, (long)userId)) {
            throw new UnsupportedOperationException();
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, ObjectEntryFolder.class.getName(), this._getClassPK(groupId, objectEntryFolderId));
    }

    public void unsubscribeObjectEntryFolder(long userId, long groupId, long objectEntryFolderId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, ObjectEntryFolder.class.getName(), this._getClassPK(groupId, objectEntryFolderId));
    }

    public ObjectEntryFolder updateObjectEntryFolder(long userId, long objectEntryFolderId, long parentObjectEntryFolderId, String description, Map<Locale, String> labelMap, String name, ServiceContext serviceContext) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(objectEntryFolderId);
        this._validateParentObjectEntryFolderId(objectEntryFolder.getGroupId(), objectEntryFolder, parentObjectEntryFolderId);
        this._validateName(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectEntryFolderId, parentObjectEntryFolderId, name);
        objectEntryFolder.setParentObjectEntryFolderId(parentObjectEntryFolderId);
        objectEntryFolder.setDescription(description);
        objectEntryFolder.setLabelMap(this._getLabelMap(labelMap, name));
        objectEntryFolder.setName(name);
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        if (objectEntryFolder.getStatus() == 9) {
            objectEntryFolder.setStatus(0);
        }
        this._updateWorkflowDefinitionLinks(objectEntryFolderId, serviceContext);
        objectEntryFolder = (ObjectEntryFolder)this.objectEntryFolderPersistence.update((BaseModel)objectEntryFolder);
        this._updateAsset(objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    public ObjectEntryFolder updateStatus(ObjectEntryFolder objectEntryFolder, int status) throws PortalException {
        if (objectEntryFolder.getStatus() == status) {
            return objectEntryFolder;
        }
        objectEntryFolder.setStatus(status);
        return (ObjectEntryFolder)this.objectEntryFolderPersistence.update((BaseModel)objectEntryFolder);
    }

    private ObjectEntryFolder _addObjectEntryFolder(String externalReferenceCode, long groupId, long parentObjectEntryFolderId, String description, Map<Locale, String> labelMap, String name, ServiceContext serviceContext, int status, User user) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.create(this.counterLocalService.increment());
        objectEntryFolder.setUuid(serviceContext.getUuid());
        objectEntryFolder.setExternalReferenceCode(externalReferenceCode);
        objectEntryFolder.setGroupId(groupId);
        objectEntryFolder.setCompanyId(user.getCompanyId());
        objectEntryFolder.setUserId(user.getUserId());
        objectEntryFolder.setUserName(user.getFullName());
        objectEntryFolder.setParentObjectEntryFolderId(parentObjectEntryFolderId);
        objectEntryFolder.setDescription(description);
        objectEntryFolder.setLabelMap(this._getLabelMap(labelMap, name));
        objectEntryFolder.setName(name);
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        objectEntryFolder.setStatus(status);
        objectEntryFolder = (ObjectEntryFolder)this.objectEntryFolderPersistence.update((BaseModel)objectEntryFolder);
        this._addResourcePermission(objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    private void _addResourcePermission(ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext) throws PortalException {
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this._resourceLocalService.addResources(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), objectEntryFolder.getUserId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), false, serviceContext);
        } else {
            if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
                ModelPermissions modelPermissions = serviceContext.getModelPermissions();
                if (modelPermissions == null) {
                    modelPermissions = ModelPermissionsFactory.create((String)ObjectEntryFolder.class.getName());
                    serviceContext.setModelPermissions(modelPermissions);
                }
                modelPermissions.addRolePermissions("Asset Library Administrator", new String[]{"ADD_ENTRY", "VIEW"});
                modelPermissions.addRolePermissions("Asset Library Content Reviewer", new String[]{"ADD_ENTRY", "VIEW"});
            }
            this._resourceLocalService.addModelResources(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), objectEntryFolder.getUserId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), serviceContext.getModelPermissions());
        }
    }

    private long _getClassPK(long groupId, long objectEntryFolderId) {
        if (objectEntryFolderId == 0L) {
            return groupId;
        }
        return objectEntryFolderId;
    }

    private Map<Locale, String> _getLabelMap(Map<Locale, String> labelMap, String name) {
        if (MapUtil.isEmpty(labelMap) || !labelMap.containsKey(LocaleUtil.getSiteDefault())) {
            return HashMapBuilder.putAll(labelMap).put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        }
        return labelMap;
    }

    private ObjectEntryFolder _moveObjectEntryFolderToTrash(ObjectEntryFolder objectEntryFolder, long parentObjectEntryFolderId, ServiceContext serviceContext, long userId) throws PortalException {
        int oldStatus = objectEntryFolder.getStatus();
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        objectEntryFolder = this.updateStatus(objectEntryFolder, 8);
        this._trashEntryLocalService.addTrashEntry(userId, objectEntryFolder.getGroupId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), objectEntryFolder.getUuid(), null, oldStatus, null, UnicodePropertiesBuilder.put((String)"parentObjectEntryFolderId", (long)parentObjectEntryFolderId).put("title", objectEntryFolder.getObjectEntryFolderId()).build());
        this._objectEntryLocalService.moveObjectEntriesToTrash(userId, objectEntryFolder, serviceContext);
        this.moveObjectEntryFoldersToTrash(userId, objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    private ObjectEntryFolder _restoreObjectEntryFolderFromTrash(ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext, TrashEntry trashEntry, long userId) throws PortalException {
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        objectEntryFolder = this.updateStatus(objectEntryFolder, trashEntry.getStatus());
        this._trashEntryLocalService.deleteEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        this._objectEntryLocalService.restoreObjectEntriesFromTrash(userId, objectEntryFolder, serviceContext);
        this.restoreObjectEntryFoldersFromTrash(userId, objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    private void _updateAsset(ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext) throws PortalException {
        this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), objectEntryFolder.getGroupId(), objectEntryFolder.getCreateDate(), objectEntryFolder.getModifiedDate(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), objectEntryFolder.getUuid(), 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, objectEntryFolder.getCreateDate(), null, null, objectEntryFolder.getName(), null, null, null, null, 0, 0, null);
    }

    private void _updateWorkflowDefinitionLinks(long objectEntryFolderId, ServiceContext serviceContext) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-42553") || !GetterUtil.getBoolean((Object)serviceContext.getAttribute("updateWorkflowDefinitionLinks"), (boolean)true)) {
            return;
        }
        this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), ObjectEntryFolder.class.getName(), objectEntryFolderId, Collections.singletonList(new ObjectValuePair((Object)-1L, (Object)ParamUtil.getString((ServiceContext)serviceContext, (String)"workflowDefinition-1"))));
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
        if (objectEntryFolder != null) {
            throw new DuplicateObjectEntryFolderExternalReferenceCodeException(StringBundler.concat((String[])new String[]{"Duplicate object entry folder with external reference ", "code ", externalReferenceCode}));
        }
    }

    private void _validateName(long groupId, long companyId, long objectEntryFolderId, long parentObjectEntryFolderId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ObjectEntryFolderNameException.MustNotBeNull();
        }
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.fetchByG_C_P_N(groupId, companyId, parentObjectEntryFolderId, name);
        if (objectEntryFolder != null && objectEntryFolder.getObjectEntryFolderId() != objectEntryFolderId) {
            throw new ObjectEntryFolderNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateParentObjectEntryFolderId(long groupId, ObjectEntryFolder objectEntryFolder, long parentObjectEntryFolderId) throws PortalException {
        if (parentObjectEntryFolderId == 0L) {
            return;
        }
        ObjectEntryFolder parentObjectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(parentObjectEntryFolderId);
        if (parentObjectEntryFolder.getGroupId() != groupId) {
            throw new ObjectEntryFolderScopeException(StringBundler.concat((Object[])new Object[]{"Group ID ", groupId, " does not match parent object entry folder group ID ", parentObjectEntryFolder.getGroupId()}));
        }
        if (objectEntryFolder != null && StringUtil.startsWith((String)parentObjectEntryFolder.getTreePath(), (String)objectEntryFolder.getTreePath())) {
            throw new ObjectEntryFolderParentObjectEntryFolderIdException(StringBundler.concat((Object[])new Object[]{"Object entry folder ", objectEntryFolder.getObjectEntryFolderId(), " cannot have one of its children or itself as a parent"}));
        }
    }
}

