/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.object.internal.entry.util.ObjectEntrySearchUtil;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.model.ObjectValidationRuleSetting;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectValidationRuleEngine.class})
public class UniqueCompositeKeyObjectValidationRuleEngineImpl
implements ObjectValidationRuleEngine {
    private static final Log _log = LogFactoryUtil.getLog(UniqueCompositeKeyObjectValidationRuleEngineImpl.class);
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public Map<String, Object> execute(Map<String, Object> inputObjects, String script) {
        HashMap results = HashMapBuilder.put((Object)"validationCriteriaMet", (Object)true).build();
        ObjectValidationRule objectValidationRule = (ObjectValidationRule)inputObjects.get("objectValidationRule");
        Map baseModel = (Map)inputObjects.get("baseModel");
        Map entryDTO = (Map)inputObjects.get("entryDTO");
        long objectEntriesCount = 0L;
        try {
            objectEntriesCount = this._objectEntryLocalService.getObjectEntriesCount(GetterUtil.getLong(baseModel.get("groupId")), this._objectDefinitionLocalService.fetchObjectDefinition(objectValidationRule.getObjectDefinitionId()), this._getPredicate(GetterUtil.getLong(entryDTO.get("id")), (Map)entryDTO.get("properties"), objectValidationRule));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            results.put("validationCriteriaMet", false);
        }
        if (objectEntriesCount > 0L) {
            results.put("validationCriteriaMet", false);
        }
        return results;
    }

    public String getKey() {
        return "compositeKey";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, this.getKey());
    }

    private Predicate _getPredicate(long objectEntryId, Map<String, Object> entryValues, ObjectValidationRule objectValidationRule) {
        Predicate predicate = ObjectEntryTable.INSTANCE.objectEntryId.neq((Object)objectEntryId);
        for (ObjectValidationRuleSetting objectValidationRuleSetting : objectValidationRule.getObjectValidationRuleSettings()) {
            Predicate uniqueCompositeKeyObjectFieldPredicate;
            if (!objectValidationRuleSetting.compareName("compositeKeyObjectFieldId")) continue;
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(GetterUtil.getLong((String)objectValidationRuleSetting.getValue()));
            Table table = null;
            try {
                table = this._objectFieldLocalService.getTable(objectValidationRule.getObjectDefinitionId(), objectField.getName());
            }
            catch (PortalException portalException) {
                throw new RuntimeException(portalException);
            }
            Column column = table.getColumn(objectField.getDBColumnName());
            if (column == null) continue;
            Object value = entryValues.get(objectField.getName());
            if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Picklist")) {
                Map objectFieldProperties = (Map)entryValues.get(objectField.getName());
                value = objectFieldProperties != null ? objectFieldProperties.get("key") : null;
            }
            if ((uniqueCompositeKeyObjectFieldPredicate = ObjectEntrySearchUtil.getUniqueCompositeKeyObjectFieldPredicate(column, objectField.getDBType(), value)) == null) continue;
            predicate = predicate.and((Expression)uniqueCompositeKeyObjectFieldPredicate);
        }
        return predicate;
    }
}

