/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.site.provider;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.site.configuration.manager.SitemapConfigurationManager;
import com.liferay.site.manager.SitemapManager;
import com.liferay.site.provider.SitemapURLProvider;
import com.liferay.site.provider.helper.SitemapURLProviderHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SitemapURLProvider.class})
public class ObjectEntrySitemapURLProvider
implements SitemapURLProvider {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SitemapConfigurationManager _sitemapConfigurationManager;
    @Reference
    private SitemapManager _sitemapManager;
    @Reference
    private SitemapURLProviderHelper _sitemapURLProviderHelper;

    public String getClassName() {
        return ObjectEntry.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        if (layout == null || !layout.isTypeAssetDisplay() || this._sitemapURLProviderHelper.isExcludeLayoutFromSitemap(layout)) {
            return;
        }
        ObjectDefinition objectDefinition = this._getObjectDefinitionFromLayoutPageTemplateEntry(themeDisplay.getCompanyId(), layout);
        if (objectDefinition == null || !this._sitemapConfigurationManager.isObjectDefinitionCompanyIncluded(themeDisplay.getCompanyId(), String.valueOf(objectDefinition.getObjectDefinitionId()))) {
            return;
        }
        this._visitObjectEntries(element, layout, layoutSet, objectDefinition, themeDisplay);
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Long[] objectDefinitionIds;
        Long[] longArray = objectDefinitionIds = this._sitemapConfigurationManager.getCompanySitemapObjectDefinitionIds(themeDisplay.getCompanyId());
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            Layout layout;
            long objectDefinitionId = longArray[i];
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectDefinitionId);
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchDefaultLayoutPageTemplateEntry(layoutSet.getGroupId(), this._classNameLocalService.getClassNameId(objectDefinition.getClassName()), 0L);
            if (layoutPageTemplateEntry == null || !layoutPageTemplateEntry.isDefaultTemplate() || (layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid())) == null || !layout.isTypeAssetDisplay() || this._sitemapURLProviderHelper.isExcludeLayoutFromSitemap(layout)) continue;
            this._visitObjectEntries(element, layout, layoutSet, objectDefinition, themeDisplay);
        }
    }

    private List<ObjectEntry> _getApprovedObjectEntries(long groupId, ObjectDefinition objectDefinition) {
        if (Objects.equals(objectDefinition.getScope(), "company")) {
            return this._objectEntryLocalService.getObjectEntries(0L, objectDefinition.getObjectDefinitionId(), 0, -1, -1);
        }
        return this._objectEntryLocalService.getObjectEntries(groupId, objectDefinition.getObjectDefinitionId(), 0, -1, -1);
    }

    private Set<Locale> _getAvailableLocales(ObjectDefinition objectDefinition, Set<Locale> siteAvailableLocales) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        if (SetUtil.isEmpty(siteAvailableLocales)) {
            return availableLocales;
        }
        for (String availableLanguageId : objectDefinition.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)availableLanguageId);
            if (!siteAvailableLocales.contains(locale)) continue;
            availableLocales.add(locale);
        }
        return availableLocales;
    }

    private String _getFriendlyURL(String languageId, ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        String urlTitle = objectEntry.getURLTitle(LocaleUtil.fromLanguageId((String)languageId));
        if (Validator.isNotNull((String)urlTitle)) {
            return urlTitle;
        }
        if (!objectDefinition.isDefaultStorageType()) {
            return objectEntry.getExternalReferenceCode();
        }
        return String.valueOf(objectEntry.getObjectEntryId());
    }

    private ObjectDefinition _getObjectDefinitionFromLayoutPageTemplateEntry(long companyId, Layout layout) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry == null || !layoutPageTemplateEntry.isDefaultTemplate()) {
            return null;
        }
        return this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(companyId, this._portal.getClassName(layoutPageTemplateEntry.getClassNameId()));
    }

    private void _visitObjectEntries(Element element, Layout layout, LayoutSet layoutSet, ObjectDefinition objectDefinition, ThemeDisplay themeDisplay) throws PortalException {
        List<ObjectEntry> objectEntries = this._getApprovedObjectEntries(layoutSet.getGroupId(), objectDefinition);
        if (objectEntries.isEmpty()) {
            return;
        }
        Set<Locale> objectDefinitionAvailableLocales = this._getAvailableLocales(objectDefinition, this._language.getAvailableLocales(themeDisplay.getScopeGroupId()));
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        String urlSeparator = StringUtil.quote((String)objectDefinition.getFriendlyURLSeparator(), (char)'/');
        for (ObjectEntry objectEntry : objectEntries) {
            String friendlyURL = this._getFriendlyURL(themeDisplay.getLanguageId(), objectDefinition, objectEntry);
            String canonicalURL = this._portal.getCanonicalURL(urlSeparator + friendlyURL, themeDisplay, layout);
            Map alternateURLs = this._portal.getAlternateURLs(canonicalURL, themeDisplay, layout, objectDefinitionAvailableLocales);
            for (String alternateURL : alternateURLs.values()) {
                this._sitemapManager.addURLElement(element, alternateURL, typeSettingsUnicodeProperties, objectEntry.getModifiedDate(), canonicalURL, alternateURLs);
            }
        }
    }
}

