/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.internal.entry.util.ObjectEntryUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldTable;
import com.liferay.object.model.ObjectRelationshipTable;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.model.ObjectViewFilterColumnTable;
import com.liferay.object.model.listener.RelevantObjectEntryModelListener;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectViewFilterColumnLocalService;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelListener.class);
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectViewFilterColumnLocalService _objectViewFilterColumnLocalService;
    private ServiceTrackerList<RelevantObjectEntryModelListener> _relevantObjectEntryModelListeners;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._route("ADD", null, objectEntry);
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onAfterCreate((Object)objectEntry)));
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._route("DELETE", null, objectEntry);
        try {
            this._updateObjectViewFilterColumn("", objectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            User user = this._userLocalService.getUser(userId);
            if (objectEntry.getStatus() != 8) {
                this._executeObjectActions("onAfterDelete", objectEntry, objectEntry, user);
            }
            if (!FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-34594")) {
                return;
            }
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            if (!objectDefinition.isRootDescendantNode() || !objectDefinition.isRootNode()) {
                return;
            }
            ObjectEntry rootObjectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntry.getRootObjectEntryId());
            if (rootObjectEntry == null) {
                return;
            }
            this._executeObjectActions("onAfterRootUpdate", null, rootObjectEntry, user);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onAfterRemove((Object)objectEntry)));
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._route("UPDATE", originalObjectEntry, objectEntry);
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onAfterUpdate((Object)originalObjectEntry, (Object)objectEntry)));
        if (StringUtil.equals((String)originalObjectEntry.getExternalReferenceCode(), (String)objectEntry.getExternalReferenceCode())) {
            return;
        }
        try {
            this._updateObjectViewFilterColumn(objectEntry.getExternalReferenceCode(), originalObjectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(null, objectEntry);
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onBeforeCreate((Object)objectEntry)));
    }

    public void onBeforeRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onBeforeRemove((Object)objectEntry)));
    }

    public void onBeforeUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(originalObjectEntry, objectEntry);
        this._runRelevantObjectEntryModelListeners(objectEntry, (UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException>)((UnsafeConsumer)relevantObjectEntryModelListener -> relevantObjectEntryModelListener.onBeforeUpdate((Object)originalObjectEntry, (Object)objectEntry)));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._relevantObjectEntryModelListeners = ServiceTrackerListFactory.open((BundleContext)bundleContext, RelevantObjectEntryModelListener.class);
    }

    private void _executeObjectActions(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry, User user) throws PortalException {
        this._objectActionEngine.executeObjectActions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectActionTriggerKey, () -> ObjectEntryUtil.getPayloadJSONObject(this._dtoConverterRegistry, this._jsonFactory, objectActionTriggerKey, this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId()), objectEntry, originalObjectEntry, null, user), user.getUserId());
    }

    private AuditMessage _getAuditMessage(String eventType, ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (ClassedModel)objectEntry, null);
        JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            Map values = objectEntry.getValues();
            additionalInfoJSONObject.put(objectField.getName(), this._getAuditValue(objectField, values.get(objectField.getName())));
        }
        return auditMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object _getAuditValue(ObjectField objectField, Object value) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            long dlFileEntryId = GetterUtil.getLong((Object)value);
            try {
                DLFileEntry dlFileEntry = this._dlFileEntryLocalService.getDLFileEntry(dlFileEntryId);
                return JSONUtil.put((String)"dlFileEntryId", (Object)dlFileEntryId).put("title", dlFileEntry.getTitle());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
                return value;
            }
        } else if (Objects.equals(objectField.getBusinessType(), "Picklist")) {
            String key = GetterUtil.getString((Object)value);
            try {
                ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(objectField.getListTypeDefinitionId(), key);
                return JSONUtil.put((String)"key", (Object)key).put("name", listTypeEntry.getNameCurrentValue());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
                return value;
            }
        } else {
            if (!Objects.equals(objectField.getBusinessType(), "Relationship")) return value;
            long objectEntryId = GetterUtil.getLong((Object)value);
            try {
                ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntryId);
                return JSONUtil.put((String)"objectEntryId", (Object)objectEntryId).put("titleValue", objectEntry.getTitleValue());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
            }
        }
        return value;
    }

    private List<Attribute> _getModifiedAttributes(ObjectDefinition objectDefinition, Map<String, Serializable> originalValues, Map<String, Serializable> values) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            Serializable value;
            Serializable originalValue = originalValues.get(objectField.getName());
            if (Objects.equals(originalValue, value = values.get(objectField.getName()))) continue;
            attributes.add(new Attribute(objectField.getName(), this._getAuditValue(objectField, value), this._getAuditValue(objectField, originalValue)));
        }
        return attributes;
    }

    private void _route(String eventType, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            if (!objectDefinition.isEnableObjectEntryHistory()) {
                return;
            }
            if (StringUtil.equals((String)"UPDATE", (String)eventType)) {
                this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (ClassedModel)objectEntry, this._getModifiedAttributes(objectDefinition, originalObjectEntry.getValues(), objectEntry.getValues())));
            } else {
                this._auditRouter.route(this._getAuditMessage(eventType, objectDefinition, objectEntry));
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _runRelevantObjectEntryModelListeners(ObjectEntry objectEntry, UnsafeConsumer<RelevantObjectEntryModelListener, ModelListenerException> unsafeConsumer) {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
        for (RelevantObjectEntryModelListener relevantObjectEntryModelListener : this._relevantObjectEntryModelListeners) {
            if (!Objects.equals(objectDefinition.getExternalReferenceCode(), relevantObjectEntryModelListener.getObjectDefinitionExternalReferenceCode())) continue;
            unsafeConsumer.accept((Object)relevantObjectEntryModelListener);
        }
    }

    private void _updateObjectViewFilterColumn(String externalReferenceCode, ObjectEntry objectEntry) throws PortalException {
        List objectViewFilterColumns = (List)this._objectViewFilterColumnLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ObjectViewFilterColumnTable.INSTANCE).from((Table)ObjectViewFilterColumnTable.INSTANCE).innerJoinON((Table)ObjectFieldTable.INSTANCE, ObjectFieldTable.INSTANCE.name.eq((Expression)ObjectViewFilterColumnTable.INSTANCE.objectFieldName)).innerJoinON((Table)ObjectRelationshipTable.INSTANCE, ObjectRelationshipTable.INSTANCE.objectFieldId2.eq((Expression)ObjectFieldTable.INSTANCE.objectFieldId)).where(ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectEntry.getObjectDefinitionId())));
        for (ObjectViewFilterColumn objectViewFilterColumn : objectViewFilterColumns) {
            JSONArray valueJSONArray = objectViewFilterColumn.getJSONArray();
            JSONArrayImpl newValueJSONArray = new JSONArrayImpl();
            if (valueJSONArray != null) {
                for (int i = 0; i < valueJSONArray.length(); ++i) {
                    if (StringUtil.equals((String)((String)valueJSONArray.get(i)), (String)objectEntry.getExternalReferenceCode())) {
                        if (StringUtil.equals((String)externalReferenceCode, (String)"")) continue;
                        newValueJSONArray.put(externalReferenceCode);
                        continue;
                    }
                    newValueJSONArray.put((String)valueJSONArray.get(i));
                }
            }
            if (newValueJSONArray.length() == 0) {
                this._objectViewFilterColumnLocalService.deleteObjectViewFilterColumn(objectViewFilterColumn);
                continue;
            }
            objectViewFilterColumn.setJSON(StringBundler.concat((Object[])new Object[]{"{\"", objectViewFilterColumn.getFilterType(), "\":", newValueJSONArray, "}"}));
            this._objectViewFilterColumnLocalService.updateObjectViewFilterColumn(objectViewFilterColumn);
        }
    }

    private void _validateObjectEntry(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        if (ObjectEntryThreadLocal.isSkipObjectValidationRules()) {
            return;
        }
        try {
            int count;
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            if ((count = this._objectValidationRuleLocalService.getObjectValidationRulesCount(objectEntry.getObjectDefinitionId(), true)) > 0) {
                this._objectValidationRuleLocalService.validate((BaseModel)objectEntry, objectEntry.getObjectDefinitionId(), ObjectEntryUtil.getPayloadJSONObject(this._dtoConverterRegistry, this._jsonFactory, null, this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId()), objectEntry, originalObjectEntry, null, this._userLocalService.getUser(userId)), userId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

