/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.service.ObjectViewFilterColumnLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectViewFilterColumn service. Represents a row in the &quot;ObjectViewFilterColumn&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectViewFilterColumnImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectViewFilterColumnImpl
 * @see ObjectViewFilterColumn
 * @generated
 */
public abstract class ObjectViewFilterColumnBaseImpl
	extends ObjectViewFilterColumnModelImpl implements ObjectViewFilterColumn {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object view filter column model instance should use the <code>ObjectViewFilterColumn</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectViewFilterColumnLocalServiceUtil.addObjectViewFilterColumn(
				this);
		}
		else {
			ObjectViewFilterColumnLocalServiceUtil.updateObjectViewFilterColumn(
				this);
		}
	}

}