/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.constants.ObjectActionConstants;
import com.liferay.object.definition.security.permission.resource.util.ObjectDefinitionResourcePermissionUtil;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.exception.DuplicateObjectActionExternalReferenceCodeException;
import com.liferay.object.exception.LockedObjectActionException;
import com.liferay.object.exception.ObjectActionActiveException;
import com.liferay.object.exception.ObjectActionConditionExpressionException;
import com.liferay.object.exception.ObjectActionErrorMessageException;
import com.liferay.object.exception.ObjectActionExecutorKeyException;
import com.liferay.object.exception.ObjectActionNameException;
import com.liferay.object.exception.ObjectActionParametersException;
import com.liferay.object.exception.ObjectActionSystemException;
import com.liferay.object.exception.ObjectActionTriggerKeyException;
import com.liferay.object.internal.action.trigger.util.ObjectActionTriggerUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.base.ObjectActionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.security.script.management.configuration.helper.ScriptManagementConfigurationHelper;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectAction"}, service={AopService.class})
public class ObjectActionLocalServiceImpl
extends ObjectActionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionLocalServiceImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private NotificationTemplateLocalService _notificationTemplateLocalService;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFolderLocalService _objectFolderLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ScriptManagementConfigurationHelper _scriptManagementConfigurationHelper;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addObjectAction(String externalReferenceCode, long userId, long objectDefinitionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties, boolean system) throws PortalException {
        this._validateInvokerBundle("Only allowed bundles can add system object actions", system);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateExternalReferenceCode(externalReferenceCode, 0L, objectDefinition.getCompanyId(), objectDefinitionId);
        this._validateErrorMessage(errorMessageMap, objectActionTriggerKey);
        this._validateName(0L, objectDefinitionId, name);
        this._validateObjectActionExecutorKey(objectActionExecutorKey, objectDefinition);
        this._validateObjectActionTriggerKey(conditionExpression, objectActionTriggerKey, objectDefinition);
        User user = this._userLocalService.getUser(userId);
        this._validateParametersUnicodeProperties(user.getCompanyId(), userId, conditionExpression, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        ObjectAction objectAction = this.objectActionPersistence.create(this.counterLocalService.increment());
        if (Validator.isNull((String)externalReferenceCode)) {
            externalReferenceCode = objectAction.getUuid();
        }
        objectAction.setExternalReferenceCode(externalReferenceCode);
        objectAction.setCompanyId(user.getCompanyId());
        objectAction.setUserId(user.getUserId());
        objectAction.setUserName(user.getFullName());
        objectAction.setObjectDefinitionId(objectDefinitionId);
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setErrorMessageMap(errorMessageMap, LocaleUtil.getSiteDefault());
        objectAction.setLabelMap(this._populateLabelMap(labelMap, name, objectDefinition.getDefaultLocale()), objectDefinition.getDefaultLocale());
        objectAction.setName(name);
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setSystem(system);
        objectAction.setStatus(0);
        objectAction = (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
        if (objectDefinition.isApproved() && Objects.equals(objectAction.getObjectActionTriggerKey(), "standalone")) {
            try {
                if (objectDefinition.isRootDescendantNode()) {
                    objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinition.getRootObjectDefinitionId());
                }
                ObjectDefinitionResourcePermissionUtil.populateResourceActions((ObjectActionLocalService)this.objectActionLocalService, (ObjectDefinition)objectDefinition, null, (ObjectDefinitionPersistence)this._objectDefinitionPersistence, (ObjectDefinitionTreeFactory)new ObjectDefinitionTreeFactory(this._objectDefinitionPersistence, this._objectRelationshipLocalService), (PortletLocalService)this._portletLocalService, (ResourceActions)this._resourceActions, null);
            }
            catch (Exception exception) {
                ReflectionUtil.throwException((Throwable)exception);
            }
        }
        return objectAction;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addOrUpdateObjectAction(String externalReferenceCode, long objectActionId, long userId, long objectDefinitionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties, boolean system) throws PortalException {
        ObjectAction existingObjectAction = null;
        if (objectActionId > 0L) {
            existingObjectAction = this.objectActionPersistence.fetchByPrimaryKey(objectActionId);
        }
        if (existingObjectAction == null && Validator.isNotNull((String)externalReferenceCode)) {
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
            existingObjectAction = this.objectActionPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
        }
        if (existingObjectAction != null) {
            return this.updateObjectAction(externalReferenceCode, existingObjectAction.getObjectActionId(), active, conditionExpression, description, errorMessageMap, labelMap, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        }
        return this.addObjectAction(externalReferenceCode, userId, objectDefinitionId, active, conditionExpression, description, errorMessageMap, labelMap, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties, system);
    }

    public void addOrUpdateSubscriptionObjectActions(ObjectDefinition objectDefinition) throws PortalException {
        Map subscriptionObjectActions = ObjectActionConstants.getSubscriptionObjectActions();
        for (Map.Entry entry : subscriptionObjectActions.entrySet()) {
            ObjectAction objectAction = this.objectActionPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), (String)entry.getKey());
            if (objectAction != null) {
                if (!objectDefinition.isEnableObjectEntrySubscription()) {
                    this.objectActionLocalService.updateActive(objectAction, false);
                    continue;
                }
                this.objectActionLocalService.updateActive(objectAction, true);
                continue;
            }
            if (!objectDefinition.isEnableObjectEntrySubscription()) continue;
            String notificationTemplateExternalReferenceCode = MapUtil.getString((Map)((Map)entry.getValue()), (Object)"notificationTemplateExternalReferenceCode");
            NotificationTemplate notificationTemplate = this._notificationTemplateLocalService.fetchNotificationTemplateByExternalReferenceCode(notificationTemplateExternalReferenceCode, objectDefinition.getCompanyId());
            if (notificationTemplate == null) {
                this._notificationTemplateLocalService.addSubscriptionNotificationTemplate(notificationTemplateExternalReferenceCode, objectDefinition.getUserId());
            }
            this.objectActionLocalService.addObjectAction(null, objectDefinition.getUserId(), objectDefinition.getObjectDefinitionId(), true, MapUtil.getString((Map)((Map)entry.getValue()), (Object)"conditionExpression"), "", null, LocalizedMapUtil.getLocalizedMap((String)MapUtil.getString((Map)((Map)entry.getValue()), (Object)"label")), (String)entry.getKey(), "notification", MapUtil.getString((Map)((Map)entry.getValue()), (Object)"objectActionTriggerKey"), UnicodePropertiesBuilder.create((boolean)true).put("notificationTemplateExternalReferenceCode", notificationTemplateExternalReferenceCode).build(), false);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        return this.deleteObjectAction(objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectAction deleteObjectAction(ObjectAction objectAction) throws PortalException {
        this._validateInvokerBundle("Only allowed bundles can delete system object actions", objectAction.isSystem());
        objectAction = (ObjectAction)this.objectActionPersistence.remove((BaseModel)objectAction);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectAction.getObjectDefinitionId());
        if (objectDefinition.isApproved() && Objects.equals(objectAction.getObjectActionTriggerKey(), "standalone")) {
            this._resourceActions.removeModelResource(objectDefinition.getClassName(), objectAction.getName());
        }
        return objectAction;
    }

    public void deleteObjectActions(long objectDefinitionId) throws PortalException {
        for (ObjectAction objectAction : this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            this.objectActionLocalService.deleteObjectAction(objectAction);
        }
    }

    public ObjectAction fetchObjectAction(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectActionPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public ObjectAction getObjectAction(long objectDefinitionId, String name, String objectActionTriggerKey) throws PortalException {
        return this.objectActionPersistence.findByODI_A_N_OATK(objectDefinitionId, true, name, objectActionTriggerKey);
    }

    public List<ObjectAction> getObjectActions(boolean active, String objectActionExecutorKey) {
        return this.objectActionPersistence.findByA_OAEK(active, objectActionExecutorKey);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId) {
        return this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId, String objectActionTriggerKey) {
        return this.objectActionPersistence.findByO_A_OATK(objectDefinitionId, true, objectActionTriggerKey);
    }

    public Map<Long, List<ObjectAction>> getObjectActionsMap(long companyId, boolean active, String objectActionTriggerKey) {
        HashMap<Long, List<ObjectAction>> objectActionsMap = new HashMap<Long, List<ObjectAction>>();
        for (ObjectAction objectAction : this.objectActionPersistence.findByC_A_OATK(companyId, active, objectActionTriggerKey)) {
            List objectActions = objectActionsMap.computeIfAbsent(objectAction.getObjectDefinitionId(), objectDefinitionId -> new ArrayList());
            objectActions.add(objectAction);
        }
        return objectActionsMap;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateActive(ObjectAction objectAction, boolean active) throws PortalException {
        if (objectAction.isActive() == active) {
            return objectAction;
        }
        objectAction.setActive(active);
        return this.objectActionLocalService.updateObjectAction(objectAction);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateObjectAction(String externalReferenceCode, long objectActionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectAction.getObjectDefinitionId());
        if (objectAction.isSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            objectAction.setLabelMap(this._populateLabelMap(labelMap, objectAction.getName(), objectDefinition.getDefaultLocale()), objectDefinition.getDefaultLocale());
            return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
        }
        this._validateExternalReferenceCode(externalReferenceCode, objectAction.getObjectActionId(), objectAction.getCompanyId(), objectAction.getObjectDefinitionId());
        this._validateActive(active, objectAction, objectDefinition);
        this._validateErrorMessage(errorMessageMap, objectActionTriggerKey);
        this._validateObjectActionExecutorKey(objectActionExecutorKey, objectDefinition);
        this._validateParametersUnicodeProperties(objectAction.getCompanyId(), objectAction.getUserId(), conditionExpression, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        if (Validator.isNotNull((String)externalReferenceCode)) {
            objectAction.setExternalReferenceCode(externalReferenceCode);
        }
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setErrorMessageMap(errorMessageMap, LocaleUtil.getSiteDefault());
        if (objectDefinition.isApproved()) {
            objectAction.setLabelMap(this._populateLabelMap(labelMap, objectAction.getName(), objectDefinition.getDefaultLocale()), objectDefinition.getDefaultLocale());
        }
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setStatus(0);
        if (objectDefinition.isApproved()) {
            return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
        }
        this._validateName(objectActionId, objectDefinition.getObjectDefinitionId(), name);
        this._validateObjectActionTriggerKey(conditionExpression, objectActionTriggerKey, objectDefinition);
        objectAction.setLabelMap(this._populateLabelMap(labelMap, name, objectDefinition.getDefaultLocale()), objectDefinition.getDefaultLocale());
        objectAction.setName(name);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Indexable(type=IndexableType.REINDEX)
    public synchronized ObjectAction updateStatus(long objectActionId, int status) throws PortalException {
        boolean locked = LockManagerUtil.isLocked((String)ObjectAction.class.getName(), (long)objectActionId);
        if (locked) {
            throw new LockedObjectActionException(String.format("Unable to update the status of object action %d because it is being updated by another thread", objectActionId));
        }
        try {
            LockManagerUtil.lock((String)ObjectAction.class.getName(), (String)String.valueOf(objectActionId), (String)PortalUUIDUtil.generate());
            ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
            objectAction.setStatus(status);
            ObjectAction objectAction2 = (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
            return objectAction2;
        }
        finally {
            LockManagerUtil.unlock((String)ObjectAction.class.getName(), (long)objectActionId);
        }
    }

    private boolean _isUsePreferredLanguageForGuestsSupported(String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        if (!Objects.equals(objectActionExecutorKey, "notification")) {
            return false;
        }
        NotificationTemplate notificationTemplate = this._notificationTemplateLocalService.getNotificationTemplate(GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"notificationTemplateId"))));
        return Objects.equals(notificationTemplate.getType(), "email") && (Objects.equals(objectActionTriggerKey, "onAfterAdd") || Objects.equals(objectActionTriggerKey, "onAfterUpdate"));
    }

    private Map<Locale, String> _populateLabelMap(Map<Locale, String> labelMap, String name, Locale locale) {
        if (labelMap == null || labelMap.isEmpty()) {
            return HashMapBuilder.put((Object)locale, (Object)name).build();
        }
        if (Validator.isNotNull((String)labelMap.get(locale))) {
            return labelMap;
        }
        if (labelMap.size() == 1) {
            for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
                labelMap.put(locale, entry.getValue());
            }
            return labelMap;
        }
        labelMap.put(locale, name);
        return labelMap;
    }

    private void _validateActive(boolean active, ObjectAction objectAction, ObjectDefinition objectDefinition) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-34594") || objectDefinition.isRootNode()) {
            return;
        }
        if (active && StringUtil.equals((String)objectAction.getObjectActionTriggerKey(), (String)"onAfterRootUpdate")) {
            throw new ObjectActionActiveException("Object action trigger is onAfterRootUpdate but object definition is not a root node");
        }
    }

    private void _validateErrorMessage(Map<Locale, String> errorMessageMap, String objectActionTriggerKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (Objects.equals(objectActionTriggerKey, "standalone") && (errorMessageMap == null || Validator.isNull((String)errorMessageMap.get(locale)))) {
            throw new ObjectActionErrorMessageException("Error message is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long objectActionId, long companyId, long objectDefinitionId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ObjectAction objectAction = this.objectActionPersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectAction != null && objectAction.getObjectActionId() != objectActionId) {
            throw new DuplicateObjectActionExternalReferenceCodeException();
        }
    }

    private void _validateInvokerBundle(String message, boolean system) throws PortalException {
        if (!system || ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            return;
        }
        throw new ObjectActionSystemException(message);
    }

    private void _validateName(long objectActionId, long objectDefinitionId, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectActionNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectActionNameException.MustOnlyContainLettersAndDigits();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectActionNameException.MustBeLessThan41Characters();
        }
        ObjectAction objectAction = this.objectActionPersistence.fetchByODI_N(objectDefinitionId, name);
        if (objectAction != null && objectAction.getObjectActionId() != objectActionId) {
            throw new ObjectActionNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectActionExecutorKey(String objectActionExecutorKey, ObjectDefinition objectDefinition) throws PortalException {
        ObjectDefinitionScoped objectActionExecutorObjectDefinitionScoped;
        CompanyScoped objectActionExecutorCompanyScoped;
        if (!this._objectActionExecutorRegistry.hasObjectActionExecutor(objectActionExecutorKey)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No object action executor is registered with " + objectActionExecutorKey));
            }
            return;
        }
        if (Objects.equals("groovy", objectActionExecutorKey) && !this._scriptManagementConfigurationHelper.isAllowScriptContentToBeExecutedOrIncluded()) {
            throw new ObjectActionExecutorKeyException("Groovy script based object actions are not allowed");
        }
        ObjectActionExecutor objectActionExecutor = this._objectActionExecutorRegistry.getObjectActionExecutor(objectDefinition.getCompanyId(), objectActionExecutorKey);
        if (objectActionExecutor instanceof CompanyScoped && !(objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor).isAllowedCompany(objectDefinition.getCompanyId())) {
            throw new ObjectActionExecutorKeyException(StringBundler.concat((Object[])new Object[]{"The object action executor key ", objectActionExecutor.getKey(), " is not allowed for company ", objectDefinition.getCompanyId()}));
        }
        if (objectActionExecutor instanceof ObjectDefinitionScoped && !(objectActionExecutorObjectDefinitionScoped = (ObjectDefinitionScoped)objectActionExecutor).isAllowedObjectDefinition(objectDefinition.getName())) {
            throw new ObjectActionExecutorKeyException(StringBundler.concat((String[])new String[]{"The object action executor key ", objectActionExecutor.getKey(), " is not allowed for object definition ", objectDefinition.getName()}));
        }
    }

    private void _validateObjectActionTriggerKey(String conditionExpression, String objectActionTriggerKey, ObjectDefinition objectDefinition) throws PortalException {
        if (FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-34594") && StringUtil.equals((String)objectActionTriggerKey, (String)"onAfterRootUpdate") && !objectDefinition.isRootNode()) {
            throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action trigger key ", "onAfterRootUpdate", " can only be used by a root object definition"}));
        }
        if (StringUtil.equals((String)objectActionTriggerKey, (String)"standalone")) {
            if (objectDefinition.isUnmodifiableSystemObject()) {
                throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action trigger key ", "standalone", " cannot be used by a system object definition"}));
            }
            if (Validator.isNotNull((String)conditionExpression)) {
                throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action trigger key ", "standalone", " cannot have a condition expression"}));
            }
        }
        if (!ListUtil.exists(ObjectActionTriggerUtil.getDefaultObjectActionTriggers(), objectActionTrigger -> StringUtil.equals((String)objectActionTrigger.getKey(), (String)objectActionTriggerKey))) {
            if (this._messageBus.getDestination(objectActionTriggerKey) == null) {
                throw new ObjectActionTriggerKeyException();
            }
            if (StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_order_status") || StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_payment_status") || StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_shipment_status")) {
                return;
            }
            if (Validator.isNotNull((String)conditionExpression)) {
                throw new ObjectActionConditionExpressionException();
            }
        }
    }

    private void _validateParametersUnicodeProperties(long companyId, long userId, String conditionExpression, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        HashMap<String, Object> errorMessageKeys = new HashMap<String, Object>();
        if (Validator.isNotNull((String)conditionExpression)) {
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).build());
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                errorMessageKeys.put("conditionExpression", "syntax-error");
            }
        }
        if (Objects.equals(objectActionExecutorKey, "update-object-entry") && Objects.equals(objectActionTriggerKey, "onAfterDelete")) {
            throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action executor key ", "update-object-entry", " cannot be associated with the object action trigger key", "onAfterDelete"}));
        }
        if (Objects.equals(objectActionExecutorKey, "add-object-entry") || Objects.equals(objectActionExecutorKey, "update-object-entry")) {
            ObjectDefinition objectDefinition = null;
            String objectDefinitionExternalReferenceCode = GetterUtil.getString((String)parametersUnicodeProperties.remove((Object)"objectDefinitionExternalReferenceCode"));
            if (Validator.isNotNull((String)objectDefinitionExternalReferenceCode)) {
                objectDefinition = this._objectDefinitionPersistence.fetchByERC_C(objectDefinitionExternalReferenceCode, companyId);
                if (objectDefinition == null) {
                    ObjectFolder defaultObjectFolder = this._objectFolderLocalService.getOrAddDefaultObjectFolder(companyId);
                    objectDefinition = ObjectDefinitionLocalServiceUtil.addObjectDefinition((String)objectDefinitionExternalReferenceCode, (long)userId, (long)defaultObjectFolder.getObjectFolderId(), (boolean)true, (String)"company", (boolean)false);
                }
                parametersUnicodeProperties.put("objectDefinitionId", String.valueOf(objectDefinition.getObjectDefinitionId()));
            } else {
                objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"objectDefinitionId"))));
            }
            if (objectDefinition == null) {
                errorMessageKeys.put("objectDefinitionId", "invalid");
            } else {
                this._validatePredefinedValues(errorMessageKeys, objectActionExecutorKey, objectDefinition.getObjectDefinitionId(), this._jsonFactory.createJSONArray((String)parametersUnicodeProperties.get((Object)"predefinedValues")));
            }
        } else if (Objects.equals(objectActionExecutorKey, "groovy")) {
            String script = (String)parametersUnicodeProperties.get((Object)"script");
            if (Validator.isNotNull((String)script)) {
                try {
                    this._objectScriptingValidator.validate("groovy", script);
                }
                catch (ObjectScriptingException objectScriptingException) {
                    errorMessageKeys.put("script", objectScriptingException.getMessageKey());
                }
            }
        } else if (Objects.equals(objectActionExecutorKey, "notification")) {
            String notificationTemplateExternalReferenceCode = GetterUtil.getString((String)parametersUnicodeProperties.remove((Object)"notificationTemplateExternalReferenceCode"));
            if (Validator.isNotNull((String)notificationTemplateExternalReferenceCode)) {
                NotificationTemplate existingNotificationTemplate = this._notificationTemplateLocalService.fetchNotificationTemplateByExternalReferenceCode(notificationTemplateExternalReferenceCode, companyId);
                String type = GetterUtil.getString((String)parametersUnicodeProperties.remove((Object)"type"));
                if (existingNotificationTemplate == null && type != null) {
                    existingNotificationTemplate = this._notificationTemplateLocalService.addNotificationTemplate(notificationTemplateExternalReferenceCode, userId, type);
                }
                if (existingNotificationTemplate != null) {
                    parametersUnicodeProperties.put("notificationTemplateId", String.valueOf(existingNotificationTemplate.getNotificationTemplateId()));
                }
            }
            if (Objects.isNull(parametersUnicodeProperties.get((Object)"usePreferredLanguageForGuests")) && this._isUsePreferredLanguageForGuestsSupported(objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties)) {
                parametersUnicodeProperties.put("usePreferredLanguageForGuests", "true");
            }
        } else if (Objects.equals(objectActionExecutorKey, "webhook") && Validator.isNull((String)((String)parametersUnicodeProperties.get((Object)"url")))) {
            errorMessageKeys.put("url", "required");
        }
        if (Objects.nonNull(parametersUnicodeProperties.get((Object)"usePreferredLanguageForGuests")) && !this._isUsePreferredLanguageForGuestsSupported(objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties)) {
            throw new ObjectActionParametersException("The parameter \"usePreferredLanguageForGuests\" is invalid for this object action");
        }
        if (MapUtil.isNotEmpty(errorMessageKeys)) {
            throw new ObjectActionParametersException(errorMessageKeys);
        }
    }

    private void _validatePredefinedValues(Map<String, Object> errorMessageKeys, String objectActionExecutorKey, long objectDefinitionId, JSONArray predefinedValuesJSONArray) {
        HashMap<String, String> predefinedValuesErrorMessageKeys = new HashMap<String, String>();
        HashMap<String, String> predefinedValuesMap = new HashMap<String, String>();
        for (int i = 0; i < predefinedValuesJSONArray.length(); ++i) {
            JSONObject predefinedValueJSONObject = predefinedValuesJSONArray.getJSONObject(i);
            String name = predefinedValueJSONObject.getString("name");
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, name);
            if (objectField == null) continue;
            if (objectField.compareBusinessType("AutoIncrement")) {
                predefinedValuesErrorMessageKeys.put(name, "invalid");
                continue;
            }
            if (objectField.isLocalized()) {
                predefinedValuesErrorMessageKeys.put(objectField.getName(), "localized-object-fields-must-not-be-used-in-object-actions");
            }
            String value = predefinedValueJSONObject.getString("value");
            predefinedValuesMap.put(name, value);
            if (Objects.equals(objectActionExecutorKey, "update-object-entry") && objectField.isRequired() && Validator.isNull((String)value)) {
                predefinedValuesErrorMessageKeys.put(objectField.getName(), "required");
            }
            if (Validator.isNull((String)value) || predefinedValueJSONObject.getBoolean("inputAsValue")) continue;
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)value).build());
                continue;
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                predefinedValuesErrorMessageKeys.put(name, "syntax-error");
            }
        }
        if (Objects.equals(objectActionExecutorKey, "update-object-entry")) {
            return;
        }
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinitionId)) {
            if (!objectField.isRequired() || Validator.isNotNull((String)((String)predefinedValuesMap.get(objectField.getName()))) || StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) continue;
            predefinedValuesErrorMessageKeys.put(objectField.getName(), "required");
        }
        if (MapUtil.isNotEmpty(predefinedValuesErrorMessageKeys)) {
            errorMessageKeys.put("predefinedValues", predefinedValuesErrorMessageKeys);
        }
    }
}

