/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.notification.term.contributor;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.definition.notification.term.util.ObjectDefinitionNotificationTermUtil;
import com.liferay.object.internal.notification.term.evaluator.util.ObjectDefinitionNotificationTermEvaluatorUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.UnsafeTriFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectDefinitionNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final List<EvaluatorFunction> _evaluatorFunctions = Arrays.asList(this::_evaluateAuthor, this::_evaluateCurrentDate, this::_evaluateCurrentUser, this::_evaluateObjectDefinition, this::_evaluateObjectEntry, this::_evaluateObjectFields, this::_evaluateParentObjectDefinitionAuthor, this::_evaluateParentObjectDefinitionObjectFields);
    private final ListTypeLocalService _listTypeLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final UserLocalService _userLocalService;

    public ObjectDefinitionNotificationTermEvaluator(ListTypeLocalService listTypeLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, UserLocalService userLocalService) {
        this._listTypeLocalService = listTypeLocalService;
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, NotificationContext notificationContext, String termName) throws PortalException {
        Map termValues = notificationContext.getTermValues();
        Locale locale = notificationContext.getUserLocale();
        if (locale != null) {
            if (this._isObjectFieldTermName("createDate", termName)) {
                return this._format((Date)termValues.get("createDate"), locale);
            }
            if (this._isObjectFieldTermName("modifiedDate", termName)) {
                return this._format((Date)termValues.get("modifiedDate"), locale);
            }
        }
        return this.evaluate(context, termValues, termName);
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map)) {
            return termName;
        }
        Map termValues = (Map)object;
        for (EvaluatorFunction evaluatorFunction : this._evaluatorFunctions) {
            String termValue = (String)evaluatorFunction.apply(context, termName, termValues);
            if (termValue == null) continue;
            return termValue;
        }
        return termName;
    }

    private String _evaluateAuthor(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        String prefix = StringUtil.toUpperCase((String)this._objectDefinition.getShortName());
        if (!this._isAuthorTermName(prefix, termName)) {
            return null;
        }
        User user = this._userLocalService.getUser(GetterUtil.getLong((Object)termValues.get("creator")));
        if (termName.equals("[%" + prefix + "_CREATOR%]")) {
            if (context.equals((Object)NotificationTermEvaluator.Context.RECIPIENT)) {
                return String.valueOf(termValues.get("creator"));
            }
            return user.getFullName(true, true);
        }
        return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)("[%" + prefix + "_AUTHOR_")), user);
    }

    private String _evaluateCurrentDate(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        if (!termName.equals("[%CURRENT_DATE%]")) {
            return null;
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
        return dateFormat.format(new Date());
    }

    private String _evaluateCurrentUser(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        if (!(termName.equals("[%CURRENT_USER_EMAIL_ADDRESS%]") || termName.equals("[%CURRENT_USER_FIRST_NAME%]") || termName.equals("[%CURRENT_USER_ID%]") || termName.equals("[%CURRENT_USER_LAST_NAME%]") || termName.equals("[%CURRENT_USER_MIDDLE_NAME%]") || termName.equals("[%CURRENT_USER_PREFIX%]") || termName.equals("[%CURRENT_USER_SUFFIX%]"))) {
            return null;
        }
        return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)"[%CURRENT_USER_"), this._userLocalService.getUser(GetterUtil.getLong((Object)termValues.get("currentUserId"))));
    }

    private String _evaluateObjectDefinition(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) {
        if (!FeatureFlagManagerUtil.isEnabled((long)this._objectDefinition.getCompanyId(), (String)"LPD-42577") || !termName.equals("[%OBJECT_DEFINITION_NAME%]")) {
            return null;
        }
        return this._objectDefinition.getName();
    }

    private String _evaluateObjectEntry(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) {
        if (!FeatureFlagManagerUtil.isEnabled((long)this._objectDefinition.getCompanyId(), (String)"LPD-42577")) {
            return null;
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong((Object)termValues.get("id")));
        if (objectEntry == null) {
            return null;
        }
        if (termName.equals("[%OBJECT_ENTRY_FOLDER_NAME%]")) {
            if (objectEntry.getObjectEntryFolderId() == 0L) {
                return LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)"home");
            }
            ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(objectEntry.getObjectEntryFolderId());
            if (objectEntryFolder == null) {
                return null;
            }
            return objectEntryFolder.getName();
        }
        if (termName.equals("[%OBJECT_ENTRY_TITLE_FIELD%]")) {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(this._objectDefinition.getTitleObjectFieldId());
            return this._getObjectFieldValue(objectField, termValues);
        }
        if (termName.equals("[%OBJECT_ENTRY_VERSION%]")) {
            return String.valueOf(objectEntry.getVersion());
        }
        return null;
    }

    private String _evaluateObjectFields(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) {
        if (termName.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            return termName;
        }
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
            if (!this._isObjectFieldTermName(objectField.getName(), termName)) continue;
            return this._getObjectFieldValue(objectField, termValues);
        }
        return null;
    }

    private String _evaluateParentObjectDefinitionAuthor(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationshipsByObjectDefinitionId2(this._objectDefinition.getObjectDefinitionId())) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
            String prefix = ObjectRelationshipUtil.getNotificationTermNamePrefix((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
            if (!this._isAuthorTermName(prefix, termName)) continue;
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            long primaryKey = GetterUtil.getLong((Object)termValues.get(objectField.getName()));
            if (primaryKey == 0L) {
                return "";
            }
            User user = null;
            if (objectDefinition.isSystem()) {
                user = this._userLocalService.getUser(MapUtil.getLong((Map)this._objectEntryLocalService.getSystemModelAttributes(objectDefinition, primaryKey), (String)"creator"));
            } else {
                ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(primaryKey);
                user = this._userLocalService.getUser(objectEntry.getUserId());
            }
            return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)("[%" + prefix + "_AUTHOR_")), user);
        }
        return null;
    }

    private String _evaluateParentObjectDefinitionObjectFields(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        ObjectDefinition parentObjectDefinition = null;
        ObjectField parentObjectField = null;
        ObjectField relationshipObjectField = null;
        block0: for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationshipsByObjectDefinitionId2(this._objectDefinition.getObjectDefinitionId())) {
            parentObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
            String prefix = ObjectRelationshipUtil.getNotificationTermNamePrefix((ObjectDefinition)parentObjectDefinition, (ObjectRelationship)objectRelationship);
            for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(parentObjectDefinition.getObjectDefinitionId())) {
                if (!Objects.equals(termName, ObjectDefinitionNotificationTermUtil.getObjectFieldTermName((String)prefix, (String)objectField.getName()))) continue;
                relationshipObjectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
                if (Validator.isNull((Long)GetterUtil.getLong((Object)termValues.get(relationshipObjectField.getName())))) {
                    return null;
                }
                parentObjectField = objectField;
                break block0;
            }
        }
        if (parentObjectField == null) {
            return null;
        }
        long primaryKey = GetterUtil.getLong((Object)termValues.get(relationshipObjectField.getName()));
        if (primaryKey == 0L) {
            return "";
        }
        if (parentObjectDefinition.isSystem()) {
            return MapUtil.getString((Map)this._objectEntryLocalService.getSystemModelAttributes(parentObjectDefinition, primaryKey), (Object)parentObjectField.getName());
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(primaryKey);
        HashMap values = HashMapBuilder.putAll((Map)objectEntry.getValues()).put((Object)"createDate", (Object)objectEntry.getCreateDate()).put((Object)"externalReferenceCode", (Object)objectEntry.getExternalReferenceCode()).put((Object)"id", (Object)objectEntry.getObjectEntryId()).put((Object)"modifiedDate", (Object)objectEntry.getModifiedDate()).put((Object)"status", (Object)objectEntry.getStatus()).build();
        return String.valueOf(ObjectDefinitionNotificationTermEvaluatorUtil.getTermValue(parentObjectField, values.get(parentObjectField.getName())));
    }

    private String _format(Date date, Locale locale) {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE MMM dd HH:mm:ss zzz yyyy", (Locale)locale);
        return dateFormat.format(date);
    }

    private String _getObjectFieldValue(ObjectField objectField, Map<String, Object> termValues) {
        Object termValue = termValues.get(objectField.getName());
        if (Validator.isNotNull((Object)termValue)) {
            return String.valueOf(termValue);
        }
        return Objects.toString(termValues.get(objectField.getDBColumnName()), "");
    }

    private String _getTermValue(String partialTermName, User user) throws PortalException {
        if (partialTermName.equals("EMAIL_ADDRESS%]")) {
            return user.getEmailAddress();
        }
        if (partialTermName.equals("FIRST_NAME%]")) {
            return user.getFirstName();
        }
        if (partialTermName.equals("ID%]")) {
            return String.valueOf(user.getUserId());
        }
        if (partialTermName.equals("LAST_NAME%]")) {
            return user.getLastName();
        }
        if (partialTermName.equals("MIDDLE_NAME%]")) {
            return user.getMiddleName();
        }
        if (partialTermName.equals("PREFIX%]") || partialTermName.equals("SUFFIX%]")) {
            Contact contact = user.fetchContact();
            if (contact == null) {
                return "";
            }
            long listTypeId = contact.getPrefixListTypeId();
            if (partialTermName.equals("SUFFIX%]")) {
                listTypeId = contact.getSuffixListTypeId();
            }
            if (listTypeId == 0L) {
                return "";
            }
            ListType listType = this._listTypeLocalService.getListType(listTypeId);
            return listType.getName();
        }
        return null;
    }

    private boolean _isAuthorTermName(String prefix, String termName) {
        return termName.equals("[%" + prefix + "_AUTHOR_EMAIL_ADDRESS%]") || termName.equals("[%" + prefix + "_AUTHOR_FIRST_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_ID%]") || termName.equals("[%" + prefix + "_AUTHOR_LAST_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_MIDDLE_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_PREFIX%]") || termName.equals("[%" + prefix + "_AUTHOR_SUFFIX%]") || termName.equals("[%" + prefix + "_CREATOR%]");
    }

    private boolean _isObjectFieldTermName(String objectFieldName, String termName) {
        return StringUtil.equals((String)ObjectDefinitionNotificationTermUtil.getObjectFieldTermName((String)this._objectDefinition.getShortName(), (String)objectFieldName), (String)termName);
    }

    @FunctionalInterface
    public static interface EvaluatorFunction
    extends UnsafeTriFunction<NotificationTermEvaluator.Context, String, Map<String, Object>, String, PortalException> {
    }
}

