/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=DateTime"}, service={ObjectFieldBusinessType.class})
public class DateTimeObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return Collections.singleton("timeStorage");
    }

    public String getDBType() {
        return "DateTime";
    }

    public String getDDMFormFieldTypeName() {
        return "date_time";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-date-and-time-values");
    }

    public Object getDisplayContextValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        User user = this._userLocalService.getUser(userId);
        if (objectField.isLocalized()) {
            Map localizedValues = super.getLocalizedValues(objectField, Long.valueOf(userId), values);
            if (localizedValues == null) {
                return null;
            }
            for (Map.Entry entry : localizedValues.entrySet()) {
                localizedValues.put((String)entry.getKey(), dateTimeFormatter.format(this._getLocalDateTime("UTC", ObjectFieldSettingUtil.getTimeZoneId((List)objectField.getObjectFieldSettings(), (User)user), GetterUtil.getString(entry.getValue()))));
            }
            return localizedValues;
        }
        String value = MapUtil.getString(values, (Object)objectField.getName());
        if (Validator.isNull((String)value)) {
            return "";
        }
        return dateTimeFormatter.format(this._getLocalDateTime("UTC", ObjectFieldSettingUtil.getTimeZoneId((List)objectField.getObjectFieldSettings(), (User)user), value));
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "date-and-time");
    }

    public Map<String, Object> getLocalizedValues(ObjectField objectField, Long userId, Map<String, Object> values) throws PortalException {
        Map localizedValues = super.getLocalizedValues(objectField, userId, values);
        if (localizedValues == null) {
            return null;
        }
        User user = this._userLocalService.getUser(userId.longValue());
        for (Map.Entry entry : localizedValues.entrySet()) {
            localizedValues.put((String)entry.getKey(), this._getTimestamp(objectField.getObjectFieldSettings(), user, GetterUtil.getString(entry.getValue())));
        }
        return localizedValues;
    }

    public String getName() {
        return "DateTime";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.DATE_TIME;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return Collections.singleton("timeStorage");
    }

    public Set<String> getUnmodifiableObjectFieldSettingsNames() {
        return Collections.singleton("timeStorage");
    }

    public Timestamp getValue(Long groupId, ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        Object value = super.getValue(groupId, objectField, userId, values);
        if (Validator.isNull((Object)value)) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        return this._getTimestamp(objectField.getObjectFieldSettings(), this._userLocalService.getUser(userId), String.valueOf(value));
    }

    private boolean _containsTimeZoneId(String pattern) {
        return pattern.contains("X") || pattern.contains("Z") || pattern.contains("z");
    }

    private LocalDateTime _getLocalDateTime(String sourceTimeZoneId, String targetTimeZoneId, String value) {
        String pattern = StringUtil.replace((String)ObjectFieldUtil.getDateTimePattern((String)value), (String)"'Z'", (String)"X");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateTime.parse(value, dateTimeFormatter);
        if (Validator.isNull((String)sourceTimeZoneId) || Validator.isNull((String)targetTimeZoneId)) {
            return localDateTime;
        }
        ZonedDateTime zonedDateTime = null;
        zonedDateTime = this._containsTimeZoneId(pattern) ? ZonedDateTime.parse(value, dateTimeFormatter) : ZonedDateTime.of(localDateTime, ZoneId.of(sourceTimeZoneId));
        return LocalDateTime.ofInstant(zonedDateTime.toInstant(), ZoneId.of(targetTimeZoneId));
    }

    private Timestamp _getTimestamp(List<ObjectFieldSetting> objectFieldSettings, User user, String value) {
        if (Validator.isNull((String)value)) {
            return null;
        }
        return Timestamp.valueOf(this._getLocalDateTime(ObjectFieldSettingUtil.getTimeZoneId(objectFieldSettings, (User)user), "UTC", value));
    }
}

