/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.exception.DuplicateObjectFieldExternalReferenceCodeException;
import com.liferay.object.exception.ObjectDefinitionEnableLocalizationException;
import com.liferay.object.exception.ObjectFieldBusinessTypeException;
import com.liferay.object.exception.ObjectFieldDBTypeException;
import com.liferay.object.exception.ObjectFieldLabelException;
import com.liferay.object.exception.ObjectFieldListTypeDefinitionIdException;
import com.liferay.object.exception.ObjectFieldLocalizedException;
import com.liferay.object.exception.ObjectFieldNameException;
import com.liferay.object.exception.ObjectFieldReadOnlyConditionExpressionException;
import com.liferay.object.exception.ObjectFieldReadOnlyException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.ObjectFieldRequiredException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.exception.ObjectFieldStateException;
import com.liferay.object.exception.ObjectFieldSystemException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.internal.field.setting.contributor.DefaultObjectFieldSettingContributor;
import com.liferay.object.internal.field.setting.contributor.FiltersObjectFieldSettingsContributor;
import com.liferay.object.internal.field.setting.contributor.ObjectFieldSettingContributor;
import com.liferay.object.internal.field.setting.contributor.StateFlowObjectFieldSettingContributor;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTableFactory;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectFilterLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateTransitionLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectValidationRuleSettingLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectFieldLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldSettingPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectField"}, service={AopService.class})
public class ObjectFieldLocalServiceImpl
extends ObjectFieldLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldLocalServiceImpl.class);
    private static final Snapshot<ObjectRelationshipLocalService> _objectRelationshipLocalServiceSnapshot = new Snapshot(ObjectFieldLocalServiceImpl.class, ObjectRelationshipLocalService.class, null, true);
    private final Map<String, String> _businessTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"PrecisionDecimal").put((Object)"Blob", (Object)"LargeFile").put((Object)"Boolean", (Object)"Boolean").put((Object)"Clob", (Object)"LongText").put((Object)"Date", (Object)"Date").put((Object)"DateTime", (Object)"DateTime").put((Object)"Double", (Object)"Decimal").put((Object)"Integer", (Object)"Integer").put((Object)"Long", (Object)"LongInteger").put((Object)"String", (Object)"Text").build();
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    private ObjectFieldSettingContributor _defaultObjectFieldSettingContributor;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    private final Map<String, ObjectFieldSettingContributor> _objectFieldSettingContributors = new HashMap<String, ObjectFieldSettingContributor>();
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFieldSettingPersistence _objectFieldSettingPersistence;
    @Reference
    private ObjectFilterLocalService _objectFilterLocalService;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectStateTransitionLocalService _objectStateTransitionLocalService;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectValidationRuleSettingLocalService _objectValidationRuleSettingLocalService;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    private final Set<String> _readOnlyObjectFieldNames = SetUtil.fromArray((Object[])new String[]{"createDate", "creator", "id", "modifiedDate", "status"});
    private final Set<String> _reservedNames = SetUtil.fromArray((Object[])new String[]{"actions", "companyid", "createdate", "creator", "currentdate", "datecreated", "datemodified", "displaydate", "expirationdate", "externalreferencecode", "groupid", "id", "lastpublishdate", "modifieddate", "reviewdate", "status", "statusbyuserid", "statusbyusername", "statusdate", "userid", "username"});
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addCustomObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        name = StringUtil.trim((String)name);
        return this._addObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, this._getDBColumnName(objectDefinitionId, name, false), null, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, false, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addOrUpdateCustomObjectField(String externalReferenceCode, long objectFieldId, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField existingObjectField = null;
        if (objectFieldId > 0L) {
            existingObjectField = this.objectFieldPersistence.fetchByPrimaryKey(objectFieldId);
        }
        if (existingObjectField == null && Validator.isNotNull((String)externalReferenceCode)) {
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
            existingObjectField = this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
        }
        if (existingObjectField == null) {
            return this.objectFieldLocalService.addCustomObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
        }
        return this._updateObjectField(externalReferenceCode, existingObjectField.getObjectFieldId(), listTypeDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addOrUpdateSystemObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField existingObjectField = this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
        if (existingObjectField == null) {
            return this.addSystemObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
        }
        if (ObjectDefinitionUtil.isInvokerBundleAllowed() && !ObjectFieldUtil.isMetadata((String)name)) {
            return this._updateObjectField(externalReferenceCode, existingObjectField.getObjectFieldId(), listTypeDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
        }
        this._validateLabel(labelMap, existingObjectField);
        existingObjectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)existingObjectField);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addSystemObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isModifiableAndSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            throw new ObjectFieldSystemException("Only allowed bundles can add system object fields");
        }
        name = StringUtil.trim((String)name);
        if (Validator.isNull((String)dbColumnName)) {
            dbColumnName = this._getDBColumnName(objectDefinition.getObjectDefinitionId(), name, true);
        }
        if (!objectDefinition.isSystem() || objectDefinition.isUnmodifiableSystemObject()) {
            readOnly = "false";
            readOnlyConditionExpression = null;
        }
        return this._addObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, true, objectFieldSettings);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        return this.deleteObjectField(objectField);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectField deleteObjectField(ObjectField objectField) throws PortalException {
        return this._deleteObjectField(objectField, false);
    }

    public void deleteObjectFieldByObjectDefinitionId(Long objectDefinitionId) throws PortalException {
        for (ObjectField objectField : this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            if (Validator.isNotNull((String)objectField.getRelationshipType())) continue;
            this.objectFieldPersistence.remove((BaseModel)objectField);
            if (objectField.compareBusinessType("AutoIncrement")) {
                this.counterLocalService.reset(ObjectFieldUtil.getCounterName((ObjectField)objectField));
            }
            this._objectFieldSettingLocalService.deleteObjectFieldObjectFieldSetting(objectField);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteRelationshipTypeObjectField(long objectFieldId) throws PortalException {
        return this._deleteObjectField(this.objectFieldPersistence.findByPrimaryKey(objectFieldId), true);
    }

    public ObjectField fetchObjectField(long objectDefinitionId, String name) {
        return this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
    }

    public ObjectField fetchObjectField(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public List<ObjectField> getActiveObjectFields(List<ObjectField> objectFields) throws PortalException {
        return TransformUtil.transform(objectFields, objectField -> {
            long objectFieldId = objectField.getObjectFieldId();
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectFieldId));
            if (Validator.isNull((String)objectField.getRelationshipType())) {
                return objectField;
            }
            ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId);
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            if (objectDefinition.isActive()) {
                return objectField;
            }
            return null;
        });
    }

    public Column<?, ?> getColumn(long objectDefinitionId, String name) {
        try {
            if (StringUtil.equals((String)name, (String)ObjectEntryTable.INSTANCE.userId.getName())) {
                return ObjectEntryTable.INSTANCE.userId;
            }
            ObjectField objectField = this.fetchObjectField(objectDefinitionId, name);
            if (objectField == null && (objectField = this._getObjectRelationshipField(objectDefinitionId, name)) == null) {
                throw new UnsupportedOperationException("Unsupported method getColumn with field name " + name);
            }
            if (Objects.equals(objectField.getBusinessType(), "RichText")) {
                throw new UnsupportedOperationException("Unsupported operation with " + objectField.getBusinessType() + " field");
            }
            Table table = this.getTable(objectDefinitionId, objectField.getName());
            return table.getColumn(objectField.getDBColumnName());
        }
        catch (PortalException portalException) {
            return (Column)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public List<ObjectField> getCustomObjectFields(long objectDefinitionId) {
        return this.getObjectFields(objectDefinitionId, false);
    }

    public List<ObjectField> getListTypeDefinitionObjectFields(long listTypeDefinitionId, boolean state) {
        return this.objectFieldPersistence.findByLTDI_S(listTypeDefinitionId, state);
    }

    public List<ObjectField> getLocalizedObjectFields(long objectDefinitionId) {
        return this.objectFieldPersistence.findByODI_L(objectDefinitionId, true);
    }

    public ObjectField getObjectField(long objectDefinitionId, String name) throws PortalException {
        return this.objectFieldPersistence.findByODI_N(objectDefinitionId, name);
    }

    public ObjectField getObjectField(String externalReferenceCode, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.objectFieldPersistence.findByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId) {
        return this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, boolean system) {
        return this.objectFieldPersistence.findByODI_S(objectDefinitionId, system);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, int start, int end, OrderByComparator<ObjectField> orderByComparator) {
        return this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId, start, end, orderByComparator);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, String dbTableName) {
        return this.objectFieldPersistence.findByODI_DTN(objectDefinitionId, dbTableName);
    }

    public List<ObjectField> getObjectFieldsByBusinessType(long objectDefinitionId, String businessType) {
        return this.objectFieldPersistence.findByODI_BT(objectDefinitionId, businessType);
    }

    public int getObjectFieldsCount(long objectDefinitionId) {
        return this.objectFieldPersistence.countByObjectDefinitionId(objectDefinitionId);
    }

    public int getObjectFieldsCount(long objectDefinitionId, boolean system) {
        return this.objectFieldPersistence.countByODI_S(objectDefinitionId, system);
    }

    public int getObjectFieldsCountByListTypeDefinitionId(long listTypeDefinitionId) {
        return this.objectFieldPersistence.countByListTypeDefinitionId(listTypeDefinitionId);
    }

    public Map<Long, List<ObjectField>> getObjectFieldsMap(long companyId) {
        HashMap<Long, List<ObjectField>> objectFieldsMap = new HashMap<Long, List<ObjectField>>();
        for (ObjectField objectField : this.objectFieldPersistence.findByCompanyId(companyId)) {
            List objectFields = objectFieldsMap.computeIfAbsent(objectField.getObjectDefinitionId(), objectDefinitionId -> new ArrayList());
            objectFields.add(objectField);
        }
        return objectFieldsMap;
    }

    public Table getTable(long objectDefinitionId, String name) throws PortalException {
        ObjectField objectField = this.getObjectField(objectDefinitionId, name);
        if (Objects.equals(objectField.getDBTableName(), ObjectEntryTable.INSTANCE.getTableName())) {
            return ObjectEntryTable.INSTANCE;
        }
        SystemObjectDefinitionManager systemObjectDefinitionManager = null;
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
        }
        if (objectField.isLocalized()) {
            if (objectDefinition.isUnmodifiableSystemObject()) {
                return systemObjectDefinitionManager.getLocalizationTable();
            }
            return DynamicObjectDefinitionLocalizationTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this);
        }
        if (Objects.equals(objectField.getDBTableName(), objectDefinition.getDBTableName())) {
            if (objectDefinition.isUnmodifiableSystemObject()) {
                return systemObjectDefinitionManager.getTable();
            }
            return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
        }
        return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    public ObjectField updateObjectField(String externalReferenceCode, long objectFieldId, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, boolean system, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        if (system) {
            return this.objectFieldLocalService.addOrUpdateSystemObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
        }
        return this.objectFieldLocalService.addOrUpdateCustomObjectField(externalReferenceCode, objectFieldId, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, readOnly, readOnlyConditionExpression, required, state, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateRequired(long objectFieldId, boolean required) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) {
            this._validateObjectRelationshipDeletionType(objectFieldId, required);
        }
        objectField.setRequired(required);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    public void updateUserId(long companyId, long oldUserId, long newUserId) throws PortalException {
        for (ObjectField objectField : this.objectFieldPersistence.findByC_U(companyId, oldUserId)) {
            objectField.setUserId(newUserId);
            this.objectFieldPersistence.update((BaseModel)objectField);
        }
    }

    public void validateExternalReferenceCode(String externalReferenceCode, long objectFieldId, long companyId, long objectDefinitionId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new DuplicateObjectFieldExternalReferenceCodeException();
        }
    }

    public void validateReadOnlyAndReadOnlyConditionExpression(String businessType, String readOnly, String readOnlyConditionExpression, boolean required) throws PortalException {
        if (Objects.equals(businessType, "Aggregation") || Objects.equals(businessType, "Formula") || Validator.isNull((String)readOnly)) {
            return;
        }
        if (Objects.equals(businessType, "AutoIncrement") && !Objects.equals(readOnly, "false")) {
            throw new ObjectFieldReadOnlyException();
        }
        if (!(Objects.equals(readOnly, "conditional") || Objects.equals(readOnly, "false") || Objects.equals(readOnly, "true"))) {
            throw new ObjectFieldReadOnlyException("Unknown read only: " + readOnly);
        }
        if (Objects.equals(readOnly, "conditional")) {
            if (Validator.isNull((String)readOnlyConditionExpression)) {
                throw new ObjectFieldReadOnlyConditionExpressionException("Read only condition expression is required");
            }
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)readOnlyConditionExpression).build());
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                throw new ObjectFieldReadOnlyConditionExpressionException("Syntax error in: " + readOnlyConditionExpression);
            }
        }
        if (required && !Objects.equals(readOnly, "false")) {
            throw new ObjectFieldReadOnlyException("Required object field cannot be read only");
        }
    }

    public void validateRequired(String businessType, boolean objectDefinitionApproved, ObjectField oldObjectField, boolean required) throws PortalException {
        if (Objects.equals(businessType, "AutoIncrement") && required) {
            throw new ObjectFieldRequiredException();
        }
        if (oldObjectField == null) {
            return;
        }
        if (StringUtil.equals((String)businessType, (String)"Relationship")) {
            ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(oldObjectField.getObjectFieldId());
            if (objectRelationship != null && objectRelationship.isEdge() && !required) {
                throw new ObjectFieldRequiredException();
            }
            this._validateObjectRelationshipDeletionType(oldObjectField.getObjectFieldId(), required);
        } else if (objectDefinitionApproved && !oldObjectField.isRequired() && required) {
            throw new ObjectFieldRequiredException();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._defaultObjectFieldSettingContributor = new DefaultObjectFieldSettingContributor(this._objectFieldSettingLocalService);
        this._objectFieldSettingContributors.put("filters", new FiltersObjectFieldSettingsContributor(this._objectFilterLocalService));
        this._objectFieldSettingContributors.put("stateFlow", new StateFlowObjectFieldSettingContributor(this._objectStateTransitionLocalService));
    }

    private ObjectField _addObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, boolean system, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (Validator.isNull((String)dbTableName)) {
            dbTableName = objectDefinition.getDBTableName();
            if (objectDefinition.isApproved()) {
                dbTableName = objectDefinition.getExtensionDBTableName();
            }
        }
        this.validateExternalReferenceCode(externalReferenceCode, 0L, objectDefinition.getCompanyId(), objectDefinitionId);
        this._validateListTypeDefinitionId(listTypeDefinitionId, businessType);
        this._validateBusinessType(objectDefinition, businessType);
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap, null);
        this._validateName(0L, objectDefinition, name, system);
        this.validateReadOnlyAndReadOnlyConditionExpression(businessType, readOnly, readOnlyConditionExpression, required);
        this.validateRequired(businessType, objectDefinition.isApproved(), null, required);
        this._validateState(required, state);
        ObjectField objectField = this.objectFieldPersistence.create(this.counterLocalService.increment());
        objectField.setExternalReferenceCode(externalReferenceCode);
        this._setBusinessTypeAndDBType(businessType, dbType, objectField, system);
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectField.getBusinessType());
        this._validateLocalized(localized, objectDefinition, objectField, objectFieldBusinessType, required);
        User user = this._userLocalService.getUser(userId);
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setObjectDefinitionId(objectDefinitionId);
        objectField.setDBColumnName(dbColumnName);
        objectField.setDBTableName(dbTableName);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(this._getIndexedLanguageId(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId));
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setLocalized(localized);
        objectField.setName(name);
        objectField.setReadOnly(this._getReadOnly(businessType, objectDefinition.isDefaultStorageType(), name, readOnly, system));
        objectField.setReadOnlyConditionExpression(this._getReadOnlyConditionExpression(objectField.getReadOnly(), readOnlyConditionExpression));
        objectField.setRelationshipType(null);
        objectField.setRequired(required);
        objectField.setState(state);
        objectField.setSystem(system);
        objectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
        this._addOrUpdateObjectFieldSettings(objectField, objectDefinition, objectFieldBusinessType, objectFieldSettings, null);
        if (!objectDefinition.isApproved() || ObjectFieldUtil.isMetadata((String)name) || system && objectDefinition.isUnmodifiableSystemObject()) {
            return objectField;
        }
        if (!objectField.compareBusinessType("Aggregation") && !objectField.compareBusinessType("Formula")) {
            if (localized) {
                DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this);
                dbTableName = dynamicObjectDefinitionLocalizationTable.getTableName();
                List objectFields = dynamicObjectDefinitionLocalizationTable.getObjectFields();
                if (objectFields.size() == 1) {
                    this.runSQL("DROP_TABLE_IF_EXISTS(" + dbTableName + ")");
                    this.runSQL(dynamicObjectDefinitionLocalizationTable.getCreateTableSQL());
                    return objectField;
                }
            }
            this._addObjectFieldColumn(dbTableName, objectField);
        }
        return objectField;
    }

    private void _addObjectFieldColumn(String dbTableName, ObjectField objectField) {
        this.runSQL(DynamicObjectDefinitionTableUtil.getAlterTableAddColumnSQL((String)dbTableName, (String)objectField.getBusinessType(), (String)objectField.getDBColumnName(), (String)objectField.getDBType()));
        if (objectField.compareBusinessType("AutoIncrement")) {
            this.runSQL(DynamicObjectDefinitionTableUtil.getAlterTableAddColumnSQL((String)dbTableName, (String)objectField.getBusinessType(), (String)objectField.getSortableDBColumnName(), (String)"Long"));
        }
    }

    private void _addOrUpdateObjectFieldSettings(ObjectField newObjectField, ObjectDefinition objectDefinition, ObjectFieldBusinessType objectFieldBusinessType, List<ObjectFieldSetting> objectFieldSettings, ObjectField oldObjectField) throws PortalException {
        if (ListUtil.isEmpty(objectFieldSettings) && (ObjectFieldUtil.isMetadata((String)newObjectField.getName()) || newObjectField.isSystem() && objectDefinition.isUnmodifiableSystemObject())) {
            return;
        }
        objectFieldBusinessType.validateObjectFieldSettings(newObjectField, objectFieldSettings);
        Set unmodifiableObjectFieldSettingsNames = objectFieldBusinessType.getUnmodifiableObjectFieldSettingsNames();
        for (ObjectFieldSetting oldObjectFieldSetting : this._objectFieldSettingPersistence.findByObjectFieldId(newObjectField.getObjectFieldId())) {
            ObjectFieldSetting objectFieldSetting = null;
            for (ObjectFieldSetting newObjectFieldSetting : objectFieldSettings) {
                if (!Objects.equals(oldObjectFieldSetting.getName(), newObjectFieldSetting.getName())) continue;
                objectFieldSetting = newObjectFieldSetting;
                break;
            }
            if (objectFieldSetting != null) continue;
            if (objectDefinition.isApproved() && unmodifiableObjectFieldSettingsNames.contains(oldObjectFieldSetting.getName())) {
                throw new ObjectFieldSettingValueException.UnmodifiableValue(oldObjectFieldSetting.getName());
            }
            this._objectFieldSettingLocalService.deleteObjectFieldSetting(oldObjectFieldSetting.getObjectFieldSettingId());
        }
        objectFieldBusinessType.predefineObjectFieldSettings(newObjectField, oldObjectField, objectFieldSettings);
        for (ObjectFieldSetting newObjectFieldSetting : objectFieldSettings) {
            ObjectFieldSetting oldObjectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(newObjectField.getObjectFieldId(), newObjectFieldSetting.getName());
            if (objectDefinition.isApproved() && oldObjectField != null && unmodifiableObjectFieldSettingsNames.contains(newObjectFieldSetting.getName()) && (oldObjectFieldSetting == null || !StringUtil.equalsIgnoreCase((String)oldObjectFieldSetting.getValue(), (String)newObjectFieldSetting.getValue()))) {
                throw new ObjectFieldSettingValueException.UnmodifiableValue(newObjectFieldSetting.getName());
            }
            ObjectFieldSettingContributor objectFieldSettingContributor = this._getObjectFieldSettingContributor(newObjectFieldSetting.getName());
            if (oldObjectFieldSetting == null) {
                objectFieldSettingContributor.addObjectFieldSetting(newObjectField.getUserId(), newObjectField.getObjectFieldId(), newObjectFieldSetting);
                continue;
            }
            objectFieldSettingContributor.updateObjectFieldSetting(oldObjectFieldSetting.getObjectFieldSettingId(), newObjectFieldSetting);
        }
        newObjectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(newObjectField.getObjectFieldId()));
    }

    private void _alterTableDropColumn(String tableName, String columnName) {
        try {
            Connection connection = this._currentConnection.getConnection(this.objectFieldPersistence.getDataSource());
            DB db = this.objectFieldPersistence.getDB();
            db.alterTableDropColumn(connection, tableName, columnName);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private ObjectField _deleteObjectField(ObjectField objectField, boolean deleteRelationshipObjectField) throws PortalException {
        ObjectFieldSetting objectFieldSetting;
        ObjectDefinition objectDefinition;
        if (Validator.isNull((String)objectField.getRelationshipType())) {
            if (deleteRelationshipObjectField) {
                throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it does not have a relationship type");
            }
            if (!objectField.isDeletionAllowed()) {
                throw new RequiredObjectFieldException.MustNotDeleteObjectField(objectField.getName());
            }
        } else if (!deleteRelationshipObjectField) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it has a relationship type");
        }
        if ((objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId())).isSystem() && objectField.isSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            throw new ObjectFieldSystemException("Only allowed bundles can delete system object fields");
        }
        int count = this._objectValidationRuleSettingLocalService.getObjectValidationRuleSettingsCount("compositeKeyObjectFieldId", String.valueOf(objectField.getObjectFieldId()));
        if (count > 0) {
            throw new RequiredObjectFieldException.MustNotDeleteObjectFieldCompositeKey(objectField.getName());
        }
        List objectFields = ListUtil.filter((List)this.objectFieldLocalService.getObjectFields(objectField.getObjectDefinitionId()), objectField1 -> !objectField1.isMetadata());
        if (objectDefinition.isApproved() && objectFields.size() == 1) {
            if (!deleteRelationshipObjectField) {
                throw new RequiredObjectFieldException.MustNotDeleteObjectFieldPublishedObjectDefinition(objectField.getName());
            }
            throw new RequiredObjectFieldException.MustNotDeleteObjectFieldRelationship(objectDefinition.getShortName(), objectField.getName());
        }
        if (Objects.equals(objectField.getBusinessType(), "Attachment") && Objects.equals((objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "fileSource")).getValue(), "userComputer")) {
            List objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectField.getObjectDefinitionId());
            for (ObjectEntry objectEntry : objectEntries) {
                Map values = objectEntry.getValues();
                try {
                    this._dlFileEntryLocalService.deleteFileEntry(GetterUtil.getLong(values.get(objectField.getName())));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        objectField = (ObjectField)this.objectFieldPersistence.remove((BaseModel)objectField);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() == objectField.getObjectFieldId()) {
            objectDefinition.setAccountEntryRestrictedObjectFieldId(0L);
            objectDefinition.setAccountEntryRestricted(false);
            objectDefinition = (ObjectDefinition)this._objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        if (objectDefinition.getTitleObjectFieldId() == objectField.getObjectFieldId()) {
            ObjectField externalReferenceCodeObjectField = this.objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), "externalReferenceCode");
            if (externalReferenceCodeObjectField != null) {
                objectDefinition.setTitleObjectFieldId(externalReferenceCodeObjectField.getObjectFieldId());
            } else {
                objectDefinition.setTitleObjectFieldId(0L);
            }
            objectDefinition = (ObjectDefinition)this._objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        this._objectFieldSettingLocalService.deleteObjectFieldObjectFieldSetting(objectField);
        this._objectLayoutColumnPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        if (objectField.isState()) {
            this._objectStateFlowLocalService.deleteObjectFieldObjectStateFlow(objectField.getObjectFieldId());
        }
        this._objectValidationRuleLocalService.unassociateObjectField(objectField);
        this._objectViewLocalService.unassociateObjectField(objectField);
        if (!objectDefinition.isApproved()) {
            return objectField;
        }
        if (objectDefinition.isEnableLocalization() && objectField.isLocalized()) {
            this._alterTableDropColumn(objectDefinition.getLocalizationDBTableName(), objectField.getDBColumnName());
            return objectField;
        }
        if (!objectField.hasInsertValues() || Objects.equals(objectField.getDBTableName(), ObjectEntryTable.INSTANCE.getTableName())) {
            return objectField;
        }
        this._alterTableDropColumn(objectField.getDBTableName(), objectField.getDBColumnName());
        if (objectField.compareBusinessType("AutoIncrement")) {
            this._alterTableDropColumn(objectField.getDBTableName(), objectField.getSortableDBColumnName());
            this.counterLocalService.reset(ObjectFieldUtil.getCounterName((ObjectField)objectField));
        }
        return objectField;
    }

    private String _getDBColumnName(long objectDefinitionId, String name, boolean system) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject() && system) {
            return name;
        }
        return name + "_";
    }

    private String _getIndexedLanguageId(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId) {
        if (indexed && !indexedAsKeyword && (Objects.equals(businessType, "Attachment") || Objects.equals(dbType, "Clob") || Objects.equals(dbType, "String")) && Validator.isBlank((String)indexedLanguageId)) {
            return this._language.getLanguageId(LocaleUtil.getDefault());
        }
        return indexedLanguageId;
    }

    private ObjectFieldSettingContributor _getObjectFieldSettingContributor(String key) {
        ObjectFieldSettingContributor objectFieldSettingContributor = this._objectFieldSettingContributors.get(key);
        if (objectFieldSettingContributor != null) {
            return objectFieldSettingContributor;
        }
        return this._defaultObjectFieldSettingContributor;
    }

    private ObjectField _getObjectRelationshipField(long objectDefinitionId, String relationshipIdName) {
        for (ObjectField objectField : this.getObjectFields(objectDefinitionId)) {
            if (!StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship") || !StringUtil.endsWith((String)objectField.getName(), (String)("_" + relationshipIdName))) continue;
            return objectField;
        }
        return null;
    }

    private String _getReadOnly(String businessType, boolean defaultStorageType, String name, String readOnly, boolean system) {
        if (this._readOnlyObjectFieldNames.contains(name) || Objects.equals(businessType, "Aggregation") || Objects.equals(businessType, "Formula")) {
            return "true";
        }
        if (!defaultStorageType && !system || Validator.isNull((String)readOnly)) {
            return "false";
        }
        return readOnly;
    }

    private String _getReadOnlyConditionExpression(String readOnly, String readOnlyConditionExpression) {
        if (Objects.equals(readOnly, "true") || Objects.equals(readOnly, "false")) {
            return "";
        }
        return readOnlyConditionExpression;
    }

    private void _setBusinessTypeAndDBType(String businessType, String dbType, ObjectField objectField, boolean system) throws PortalException {
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(GetterUtil.getString((String)businessType));
        Set objectFieldDBTypes = this._objectFieldBusinessTypeRegistry.getObjectFieldDBTypes();
        if (objectFieldBusinessType != null) {
            objectField.setBusinessType(businessType);
            if (system) {
                objectField.setDBType(dbType);
            } else {
                objectField.setDBType(objectFieldBusinessType.getDBType());
            }
        } else if (objectFieldDBTypes.contains(dbType) && this._businessTypes.containsKey(dbType)) {
            objectField.setBusinessType(this._businessTypes.get(dbType));
            objectField.setDBType(dbType);
        } else {
            if (!businessType.isEmpty()) {
                throw new ObjectFieldBusinessTypeException("Invalid business type " + businessType);
            }
            throw new ObjectFieldDBTypeException("Invalid DB type " + dbType);
        }
    }

    private ObjectField _updateObjectField(String externalReferenceCode, long objectFieldId, long listTypeDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, String readOnly, String readOnlyConditionExpression, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField oldObjectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        ObjectField newObjectField = (ObjectField)oldObjectField.clone();
        this.validateExternalReferenceCode(externalReferenceCode, newObjectField.getObjectFieldId(), newObjectField.getCompanyId(), newObjectField.getObjectDefinitionId());
        this._validateListTypeDefinitionId(listTypeDefinitionId, businessType);
        this._validateBusinessTypeEncrypted(newObjectField.getObjectDefinitionId(), businessType);
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap, newObjectField);
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(businessType);
        this._validateLocalized(localized, oldObjectField.getObjectDefinition(), newObjectField, objectFieldBusinessType, required);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(newObjectField.getObjectDefinitionId());
        this.validateRequired(businessType, objectDefinition.isApproved(), oldObjectField, required);
        if (Objects.equals(businessType, "Relationship") && objectDefinition.isRootDescendantNode() && !Objects.equals(oldObjectField.getReadOnly(), readOnly)) {
            throw new ObjectFieldReadOnlyException("An object field's read only setting is defined by the root object definition and cannot be changed");
        }
        if (Validator.isNotNull((String)newObjectField.getRelationshipType())) {
            if (!Objects.equals(newObjectField.getDBType(), dbType) || !Objects.equals(newObjectField.getName(), name)) {
                throw new ObjectFieldRelationshipTypeException("Object field relationship name and DB type cannot be changed");
            }
        } else {
            this._validateName(objectFieldId, objectDefinition, name, false);
        }
        this.validateReadOnlyAndReadOnlyConditionExpression(businessType, readOnly, readOnlyConditionExpression, required);
        this._validateState(required, state);
        newObjectField.setExternalReferenceCode(externalReferenceCode);
        newObjectField.setIndexed(indexed);
        newObjectField.setIndexedAsKeyword(indexedAsKeyword);
        newObjectField.setIndexedLanguageId(this._getIndexedLanguageId(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId));
        newObjectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        newObjectField.setReadOnly(this._getReadOnly(businessType, objectDefinition.isDefaultStorageType(), name, readOnly, false));
        newObjectField.setReadOnlyConditionExpression(this._getReadOnlyConditionExpression(newObjectField.getReadOnly(), readOnlyConditionExpression));
        newObjectField.setRequired(required);
        if (objectDefinition.isApproved()) {
            newObjectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)newObjectField);
            this._addOrUpdateObjectFieldSettings(newObjectField, objectDefinition, objectFieldBusinessType, objectFieldSettings, oldObjectField);
            return newObjectField;
        }
        this._setBusinessTypeAndDBType(businessType, dbType, newObjectField, newObjectField.isSystem());
        newObjectField.setListTypeDefinitionId(listTypeDefinitionId);
        if (!businessType.equals("Relationship")) {
            newObjectField.setDBColumnName(this._getDBColumnName(objectDefinition.getObjectDefinitionId(), name, newObjectField.isSystem()));
        }
        newObjectField.setLocalized(localized);
        newObjectField.setName(name);
        newObjectField.setState(state);
        newObjectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)newObjectField);
        this._addOrUpdateObjectFieldSettings(newObjectField, objectDefinition, objectFieldBusinessType, objectFieldSettings, oldObjectField);
        return newObjectField;
    }

    private void _validateBusinessType(ObjectDefinition objectDefinition, String businessType) throws PortalException {
        if (Objects.equals(objectDefinition.getStorageType(), "salesforce") && (businessType.equals("Aggregation") || businessType.equals("Attachment"))) {
            throw new ObjectFieldBusinessTypeException("Salesforce storage type does not support aggregation and attachment business types");
        }
        this._validateBusinessTypeEncrypted(objectDefinition.getObjectDefinitionId(), businessType);
    }

    private void _validateBusinessTypeEncrypted(long objectDefinitionId, String businessType) throws PortalException {
        if (!Objects.equals(businessType, "Encrypted")) {
            return;
        }
        if (!PropsValues.OBJECT_ENCRYPTION_ENABLED) {
            throw new ObjectFieldBusinessTypeException("Business type encrypted is disabled");
        }
        if (Validator.isNull((String)PropsValues.OBJECT_ENCRYPTION_ALGORITHM)) {
            throw new ObjectFieldBusinessTypeException("Encryption algorithm is required for business type encrypted");
        }
        if (Validator.isNull((String)PropsValues.OBJECT_ENCRYPTION_KEY)) {
            throw new ObjectFieldBusinessTypeException("Encryption key is required for business type encrypted");
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (!objectDefinition.isDefaultStorageType()) {
            throw new ObjectFieldBusinessTypeException("Business type encrypted can only be used in object definitions with a default storage type");
        }
        try {
            new SecretKeySpec(Base64.decode((String)PropsValues.OBJECT_ENCRYPTION_KEY), PropsValues.OBJECT_ENCRYPTION_ALGORITHM);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _validateIndexed(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId) throws PortalException {
        if (indexed && Objects.equals(dbType, "Blob")) {
            throw new ObjectFieldDBTypeException("Blob type is not indexable");
        }
        if (!((Objects.equals(businessType, "Attachment") || Objects.equals(dbType, "Clob") || Objects.equals(dbType, "String")) && !indexedAsKeyword || Validator.isBlank((String)indexedLanguageId))) {
            throw new ObjectFieldDBTypeException("Indexed language ID can only be applied with type \"Clob\" or \"String\" that is not indexed as a keyword");
        }
        if ((Objects.equals(businessType, "Aggregation") || Objects.equals(businessType, "Encrypted") || Objects.equals(businessType, "Formula")) && indexed) {
            throw new ObjectFieldBusinessTypeException(businessType + " business type is not indexable");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap, ObjectField objectField) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (objectField == null) {
            this._validateLabelLocale(labelMap, locale);
        } else {
            Locale objectFieldDefaultLocale = LocaleUtil.fromLanguageId((String)objectField.getDefaultLanguageId());
            this._validateLabelLocale(labelMap, objectFieldDefaultLocale);
            if (Validator.isNull((String)labelMap.get(locale))) {
                labelMap.put(locale, labelMap.get(objectFieldDefaultLocale));
            }
        }
    }

    private void _validateLabelLocale(Map<Locale, String> labelMap, Locale locale) throws PortalException {
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectFieldLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateListTypeDefinitionId(long listTypeDefinitionId, String businessType) throws PortalException {
        if (listTypeDefinitionId == 0L && (StringUtil.equals((String)businessType, (String)"MultiselectPicklist") || StringUtil.equals((String)businessType, (String)"Picklist"))) {
            throw new ObjectFieldListTypeDefinitionIdException("List type definition ID is 0");
        }
    }

    private void _validateLocalized(boolean localized, ObjectDefinition objectDefinition, ObjectField objectField, ObjectFieldBusinessType objectFieldBusinessType, boolean required) throws PortalException {
        if (!localized) {
            return;
        }
        String objectFieldBusinessTypeName = objectFieldBusinessType.getName();
        if (!FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-32050") && !objectFieldBusinessTypeName.equals("LongText") && !objectFieldBusinessTypeName.equals("RichText") && !objectFieldBusinessTypeName.equals("Text") || FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-32050") && !objectFieldBusinessType.isLocalizationSupported(objectField)) {
            if (FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-32050")) {
                throw new ObjectFieldLocalizedException(StringBundler.concat((String[])new String[]{"Only ", "Attachment", ",", "Boolean", ",", "Date", ",", "DateTime", ",", "Decimal", ",", "Integer", ",", "LongInteger", ",", "LongText", ",", "MultiselectPicklist", ",", "Picklist", ",", "PrecisionDecimal", ",", "RichText", " and ", "Text", " business types support localization"}));
            }
            throw new ObjectFieldLocalizedException(StringBundler.concat((String[])new String[]{"Only ", "LongText", ",", "RichText", " and ", "Text", " business types support localization"}));
        }
        if (!objectDefinition.isEnableLocalization() && objectDefinition.isApproved()) {
            throw new ObjectDefinitionEnableLocalizationException();
        }
        if (!FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-32050") && !objectDefinition.isUnmodifiableSystemObject() && required) {
            throw new ObjectFieldLocalizedException("Localized object fields must not be required");
        }
    }

    private void _validateName(long objectFieldId, ObjectDefinition objectDefinition, String name, boolean system) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectFieldNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectFieldNameException.MustOnlyContainLettersAndDigits();
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectFieldNameException.MustBeginWithLowerCaseLetter();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectFieldNameException.MustBeLessThan41Characters();
        }
        if (!system && this._reservedNames.contains(StringUtil.toLowerCase((String)name)) || StringUtil.equalsIgnoreCase((String)objectDefinition.getPKObjectFieldName(), (String)name)) {
            throw new ObjectFieldNameException.MustNotBeReserved(name);
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), name);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new ObjectFieldNameException.MustNotBeDuplicate(name);
        }
        ObjectRelationshipLocalService objectRelationshipLocalService = (ObjectRelationshipLocalService)_objectRelationshipLocalServiceSnapshot.get();
        ObjectRelationship objectRelationship = objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), name);
        if (objectRelationship == null) {
            return;
        }
        if (objectRelationship.getObjectDefinitionId1() == objectDefinition.getObjectDefinitionId()) {
            throw new ObjectFieldNameException.MustNotBeEqualToObjectRelationshipName(objectDefinition.getShortName());
        }
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        throw new ObjectFieldNameException.MustNotBeEqualToObjectRelationshipName(objectDefinition1.getShortName());
    }

    private void _validateObjectRelationshipDeletionType(long objectFieldId, boolean required) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId);
        if (StringUtil.equals((String)objectRelationship.getDeletionType(), (String)"disassociate") && required) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be required because the relationship deletion type is disassociate");
        }
    }

    private void _validateState(boolean required, boolean state) throws PortalException {
        if (state && !required) {
            throw new ObjectFieldStateException("Object field must be required when the state is true");
        }
    }
}

