/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinitionSetting;
import com.liferay.object.service.base.ObjectDefinitionSettingLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectDefinitionSetting"}, service={AopService.class})
public class ObjectDefinitionSettingLocalServiceImpl
extends ObjectDefinitionSettingLocalServiceBaseImpl {
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectDefinitionSetting addObjectDefinitionSetting(long userId, long objectDefinitionId, String name, String value) throws PortalException {
        this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectDefinitionSetting objectDefinitionSetting = this.objectDefinitionSettingPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectDefinitionSetting.setCompanyId(user.getCompanyId());
        objectDefinitionSetting.setUserId(user.getUserId());
        objectDefinitionSetting.setUserName(user.getFullName());
        objectDefinitionSetting.setObjectDefinitionId(objectDefinitionId);
        objectDefinitionSetting.setName(name);
        objectDefinitionSetting.setValue(value);
        return (ObjectDefinitionSetting)this.objectDefinitionSettingPersistence.update((BaseModel)objectDefinitionSetting);
    }

    public ObjectDefinitionSetting fetchObjectDefinitionSetting(long objectDefinitionId, String name) {
        return this.objectDefinitionSettingPersistence.fetchByODI_N(objectDefinitionId, name);
    }

    public ObjectDefinitionSetting getObjectDefinitionSetting(long objectDefinitionId, String name) throws PortalException {
        return this.objectDefinitionSettingPersistence.findByODI_N(objectDefinitionId, name);
    }

    public List<ObjectDefinitionSetting> getObjectDefinitionSettings(long objectDefinitionId) {
        return this.objectDefinitionSettingPersistence.findByObjectDefinitionId(objectDefinitionId);
    }
}

