/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectEntryFolderModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectEntryFolder service. Represents a row in the &quot;ObjectEntryFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectEntryFolderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectEntryFolderImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectEntryFolderImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectEntryFolderModelImpl
	extends BaseModelImpl<ObjectEntryFolder> implements ObjectEntryFolderModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object entry folder model instance should use the <code>ObjectEntryFolder</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectEntryFolder";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"objectEntryFolderId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"parentObjectEntryFolderId", Types.BIGINT},
		{"description", Types.VARCHAR}, {"label", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"treePath", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectEntryFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("parentObjectEntryFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectEntryFolder (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,objectEntryFolderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,parentObjectEntryFolderId LONG,description STRING null,label STRING null,name VARCHAR(75) null,treePath STRING null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectEntryFolder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectEntryFolder.objectEntryFolderId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectEntryFolder.objectEntryFolderId ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY objectEntryFolder.objectEntryFolderId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTOBJECTENTRYFOLDERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TREEPATH_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTENTRYFOLDERID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectEntryFolderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectEntryFolderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectEntryFolderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectEntryFolderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectEntryFolder.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectEntryFolder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectEntryFolder, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectEntryFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectEntryFolder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectEntryFolder)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectEntryFolder, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectEntryFolder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectEntryFolder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectEntryFolder, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectEntryFolder, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectEntryFolder, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectEntryFolder, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectEntryFolder, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectEntryFolder::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectEntryFolder::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				ObjectEntryFolder::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"objectEntryFolderId",
				ObjectEntryFolder::getObjectEntryFolderId);
			attributeGetterFunctions.put(
				"groupId", ObjectEntryFolder::getGroupId);
			attributeGetterFunctions.put(
				"companyId", ObjectEntryFolder::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectEntryFolder::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectEntryFolder::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectEntryFolder::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectEntryFolder::getModifiedDate);
			attributeGetterFunctions.put(
				"parentObjectEntryFolderId",
				ObjectEntryFolder::getParentObjectEntryFolderId);
			attributeGetterFunctions.put(
				"description", ObjectEntryFolder::getDescription);
			attributeGetterFunctions.put("label", ObjectEntryFolder::getLabel);
			attributeGetterFunctions.put("name", ObjectEntryFolder::getName);
			attributeGetterFunctions.put(
				"treePath", ObjectEntryFolder::getTreePath);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectEntryFolder, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectEntryFolder, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectEntryFolder, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"objectEntryFolderId",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setObjectEntryFolderId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectEntryFolder, Date>)
					ObjectEntryFolder::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectEntryFolder, Date>)
					ObjectEntryFolder::setModifiedDate);
			attributeSetterBiConsumers.put(
				"parentObjectEntryFolderId",
				(BiConsumer<ObjectEntryFolder, Long>)
					ObjectEntryFolder::setParentObjectEntryFolderId);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setDescription);
			attributeSetterBiConsumers.put(
				"label",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setLabel);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setName);
			attributeSetterBiConsumers.put(
				"treePath",
				(BiConsumer<ObjectEntryFolder, String>)
					ObjectEntryFolder::setTreePath);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getObjectEntryFolderId() {
		return _objectEntryFolderId;
	}

	@Override
	public void setObjectEntryFolderId(long objectEntryFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectEntryFolderId = objectEntryFolderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getParentObjectEntryFolderId() {
		return _parentObjectEntryFolderId;
	}

	@Override
	public void setParentObjectEntryFolderId(long parentObjectEntryFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentObjectEntryFolderId = parentObjectEntryFolderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentObjectEntryFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentObjectEntryFolderId"));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTreePath() {
		return getColumnOriginalValue("treePath");
	}

	@Override
	public long getContainerModelId() {
		return getObjectEntryFolderId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_objectEntryFolderId = containerModelId;
	}

	@Override
	public long getParentContainerModelId() {
		return getParentObjectEntryFolderId();
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
		_parentObjectEntryFolderId = parentContainerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getName());
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectEntryFolder.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectEntryFolder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectEntryFolder.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectEntryFolder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectEntryFolder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectEntryFolderImpl objectEntryFolderImpl =
			new ObjectEntryFolderImpl();

		objectEntryFolderImpl.setMvccVersion(getMvccVersion());
		objectEntryFolderImpl.setUuid(getUuid());
		objectEntryFolderImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		objectEntryFolderImpl.setObjectEntryFolderId(getObjectEntryFolderId());
		objectEntryFolderImpl.setGroupId(getGroupId());
		objectEntryFolderImpl.setCompanyId(getCompanyId());
		objectEntryFolderImpl.setUserId(getUserId());
		objectEntryFolderImpl.setUserName(getUserName());
		objectEntryFolderImpl.setCreateDate(getCreateDate());
		objectEntryFolderImpl.setModifiedDate(getModifiedDate());
		objectEntryFolderImpl.setParentObjectEntryFolderId(
			getParentObjectEntryFolderId());
		objectEntryFolderImpl.setDescription(getDescription());
		objectEntryFolderImpl.setLabel(getLabel());
		objectEntryFolderImpl.setName(getName());
		objectEntryFolderImpl.setTreePath(getTreePath());

		objectEntryFolderImpl.resetOriginalValues();

		return objectEntryFolderImpl;
	}

	@Override
	public ObjectEntryFolder cloneWithOriginalValues() {
		ObjectEntryFolderImpl objectEntryFolderImpl =
			new ObjectEntryFolderImpl();

		objectEntryFolderImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectEntryFolderImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectEntryFolderImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		objectEntryFolderImpl.setObjectEntryFolderId(
			this.<Long>getColumnOriginalValue("objectEntryFolderId"));
		objectEntryFolderImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		objectEntryFolderImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectEntryFolderImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectEntryFolderImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectEntryFolderImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectEntryFolderImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectEntryFolderImpl.setParentObjectEntryFolderId(
			this.<Long>getColumnOriginalValue("parentObjectEntryFolderId"));
		objectEntryFolderImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		objectEntryFolderImpl.setLabel(
			this.<String>getColumnOriginalValue("label"));
		objectEntryFolderImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectEntryFolderImpl.setTreePath(
			this.<String>getColumnOriginalValue("treePath"));

		return objectEntryFolderImpl;
	}

	@Override
	public int compareTo(ObjectEntryFolder objectEntryFolder) {
		long primaryKey = objectEntryFolder.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectEntryFolder)) {
			return false;
		}

		ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;

		long primaryKey = objectEntryFolder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectEntryFolder> toCacheModel() {
		ObjectEntryFolderCacheModel objectEntryFolderCacheModel =
			new ObjectEntryFolderCacheModel();

		objectEntryFolderCacheModel.mvccVersion = getMvccVersion();

		objectEntryFolderCacheModel.uuid = getUuid();

		String uuid = objectEntryFolderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectEntryFolderCacheModel.uuid = null;
		}

		objectEntryFolderCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			objectEntryFolderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			objectEntryFolderCacheModel.externalReferenceCode = null;
		}

		objectEntryFolderCacheModel.objectEntryFolderId =
			getObjectEntryFolderId();

		objectEntryFolderCacheModel.groupId = getGroupId();

		objectEntryFolderCacheModel.companyId = getCompanyId();

		objectEntryFolderCacheModel.userId = getUserId();

		objectEntryFolderCacheModel.userName = getUserName();

		String userName = objectEntryFolderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectEntryFolderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectEntryFolderCacheModel.createDate = createDate.getTime();
		}
		else {
			objectEntryFolderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectEntryFolderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectEntryFolderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectEntryFolderCacheModel.parentObjectEntryFolderId =
			getParentObjectEntryFolderId();

		objectEntryFolderCacheModel.description = getDescription();

		String description = objectEntryFolderCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			objectEntryFolderCacheModel.description = null;
		}

		objectEntryFolderCacheModel.label = getLabel();

		String label = objectEntryFolderCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectEntryFolderCacheModel.label = null;
		}

		objectEntryFolderCacheModel.name = getName();

		String name = objectEntryFolderCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectEntryFolderCacheModel.name = null;
		}

		objectEntryFolderCacheModel.treePath = getTreePath();

		String treePath = objectEntryFolderCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			objectEntryFolderCacheModel.treePath = null;
		}

		return objectEntryFolderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectEntryFolder, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectEntryFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectEntryFolder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectEntryFolder)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectEntryFolder>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectEntryFolder.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _objectEntryFolderId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _parentObjectEntryFolderId;
	private String _description;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _name;
	private String _treePath;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectEntryFolder, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectEntryFolder)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("objectEntryFolderId", _objectEntryFolderId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"parentObjectEntryFolderId", _parentObjectEntryFolderId);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("treePath", _treePath);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("objectEntryFolderId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("parentObjectEntryFolderId", 1024L);

		columnBitmasks.put("description", 2048L);

		columnBitmasks.put("label", 4096L);

		columnBitmasks.put("name", 8192L);

		columnBitmasks.put("treePath", 16384L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectEntryFolder _escapedModel;

}