/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.exception.RequiredObjectEntryVersionException;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.base.ObjectEntryVersionLocalServiceBaseImpl;
import com.liferay.object.util.comparator.ObjectEntryVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntryVersion"}, service={AopService.class})
public class ObjectEntryVersionLocalServiceImpl
extends ObjectEntryVersionLocalServiceBaseImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectEntryVersion addObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        return this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.create(this.counterLocalService.increment()), objectEntry.getVersion() + 1);
    }

    public ObjectEntryVersion deleteObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        if (this.getObjectEntryVersionsCount(objectEntryId) == 1) {
            throw new RequiredObjectEntryVersionException.MustHaveOneVersion("At least one version must remain", "at-least-one-version-must-remain");
        }
        ObjectEntryVersion objectEntryVersion = this.objectEntryVersionPersistence.fetchByObjectEntryId_First(objectEntryId, (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false));
        if (version == objectEntryVersion.getVersion()) {
            throw new RequiredObjectEntryVersionException.MustNotDeleteLatestVersion("The latest version cannot be deleted", "the-last-version-cannot-be-deleted");
        }
        objectEntryVersion = this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
        return this.deleteObjectEntryVersion(objectEntryVersion);
    }

    public void deleteObjectEntryVersionByObjectDefinitionId(Long objectDefinitionId) {
        this.objectEntryVersionPersistence.removeByObjectDefinitionId(objectDefinitionId.longValue());
    }

    public void deleteObjectEntryVersions(long objectEntryId) {
        this.objectEntryVersionPersistence.removeByObjectEntryId(objectEntryId);
    }

    public ObjectEntryVersion expireObjectEntryVersion(long userId, long objectEntryId, int version) throws PortalException {
        ObjectEntryVersion objectEntryVersion = this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
        if (objectEntryVersion.isDraft() || objectEntryVersion.isExpired() || objectEntryVersion.isPending()) {
            return objectEntryVersion;
        }
        Date date = new Date();
        objectEntryVersion.setExpirationDate(date);
        objectEntryVersion.setStatus(3);
        User user = this._userLocalService.getUser(userId);
        objectEntryVersion.setStatusByUserId(user.getUserId());
        objectEntryVersion.setStatusByUserName(user.getFullName());
        objectEntryVersion.setStatusDate(date);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        return this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId, start, end);
    }

    public int getObjectEntryVersionsCount(long objectEntryId) {
        return this.objectEntryVersionPersistence.countByObjectEntryId(objectEntryId);
    }

    public ObjectEntryVersion updateLatestObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        return this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.fetchByObjectEntryId_First(objectEntry.getObjectEntryId(), (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false)), objectEntry.getVersion());
    }

    private ObjectEntryVersion _updateObjectEntryVersion(ObjectEntry objectEntry, ObjectEntryVersion objectEntryVersion, int version) throws PortalException {
        User user = this._userLocalService.getUser(objectEntry.getUserId());
        objectEntryVersion.setUserId(user.getUserId());
        objectEntryVersion.setUserName(user.getFullName());
        objectEntryVersion.setCreateDate(objectEntry.getCreateDate());
        objectEntryVersion.setModifiedDate(objectEntry.getModifiedDate());
        objectEntryVersion.setObjectDefinitionId(objectEntry.getObjectDefinitionId());
        objectEntryVersion.setObjectEntryId(objectEntry.getObjectEntryId());
        try {
            objectEntryVersion.setContent(ObjectEntryDTOConverterUtil.toDTO((DTOConverterRegistry)this._dtoConverterRegistry, (JSONFactory)this._jsonFactory, (ObjectEntry)objectEntry, (User)user));
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        Date date = new Date();
        Date expirationDate = objectEntryVersion.getExpirationDate();
        int status = objectEntry.getStatus();
        if (status == 0 && expirationDate != null && expirationDate.before(date)) {
            objectEntryVersion.setExpirationDate(null);
        }
        if (status == 3 && expirationDate == null) {
            objectEntryVersion.setExpirationDate(date);
        }
        objectEntryVersion.setVersion(version);
        objectEntryVersion.setStatus(status);
        objectEntryVersion.setStatusByUserId(user.getUserId());
        objectEntryVersion.setStatusByUserName(user.getFullName());
        objectEntryVersion.setStatusDate(date);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }
}

