/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.object.entry.folder.util.ObjectEntryFolderThreadLocal;
import com.liferay.object.exception.DuplicateObjectEntryFolderExternalReferenceCodeException;
import com.liferay.object.exception.ObjectEntryFolderNameException;
import com.liferay.object.exception.ObjectEntryFolderParentObjectEntryFolderIdException;
import com.liferay.object.exception.ObjectEntryFolderScopeException;
import com.liferay.object.exception.RequiredObjectEntryFolderException;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.base.ObjectEntryFolderLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntryFolder"}, service={AopService.class})
public class ObjectEntryFolderLocalServiceImpl
extends ObjectEntryFolderLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder addObjectEntryFolder(String externalReferenceCode, long userId, long groupId, long parentObjectEntryFolderId, String description, Map<Locale, String> labelMap, String name, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(externalReferenceCode, groupId, user.getCompanyId());
        this._validateParentObjectEntryFolderId(groupId, null, parentObjectEntryFolderId);
        this._validateName(groupId, user.getCompanyId(), 0L, parentObjectEntryFolderId, name);
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.create(this.counterLocalService.increment());
        objectEntryFolder.setUuid(serviceContext.getUuid());
        objectEntryFolder.setExternalReferenceCode(externalReferenceCode);
        objectEntryFolder.setGroupId(groupId);
        objectEntryFolder.setCompanyId(user.getCompanyId());
        objectEntryFolder.setUserId(user.getUserId());
        objectEntryFolder.setUserName(user.getFullName());
        objectEntryFolder.setParentObjectEntryFolderId(parentObjectEntryFolderId);
        objectEntryFolder.setDescription(description);
        objectEntryFolder.setLabelMap(this._getLabelMap(labelMap, name));
        objectEntryFolder.setName(name);
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        objectEntryFolder = (ObjectEntryFolder)this.objectEntryFolderPersistence.update((BaseModel)objectEntryFolder);
        this._updateAsset(objectEntryFolder, serviceContext);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this._resourceLocalService.addResources(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), objectEntryFolder.getUserId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), false, serviceContext);
        } else {
            this._resourceLocalService.addModelResources(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), objectEntryFolder.getUserId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), serviceContext.getModelPermissions());
        }
        return objectEntryFolder;
    }

    @Override
    public ObjectEntryFolder deleteObjectEntryFolder(long objectEntryFolderId) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(objectEntryFolderId);
        return this.objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder);
    }

    @Override
    public ObjectEntryFolder deleteObjectEntryFolder(ObjectEntryFolder objectEntryFolder) throws PortalException {
        if (!ObjectEntryFolderThreadLocal.isForceDeleteSystemObjectEntryFolder() && StringUtil.startsWith((String)objectEntryFolder.getExternalReferenceCode(), (String)"L_")) {
            throw new RequiredObjectEntryFolderException("System object entry folder " + objectEntryFolder.getExternalReferenceCode() + " cannot be deleted");
        }
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)objectEntryFolder.getGroupId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)objectEntryFolder.getCompanyId()));
            dynamicQuery.add(RestrictionsFactoryUtil.like((String)"treePath", (Object)(objectEntryFolder.getTreePath() + "%")));
        });
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> this._objectEntryLocalService.deleteObjectEntry(objectEntry));
        actionableDynamicQuery.performActions();
        actionableDynamicQuery = this.objectEntryFolderLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)objectEntryFolder.getGroupId()));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)objectEntryFolder.getCompanyId()));
            dynamicQuery.add(RestrictionsFactoryUtil.like((String)"treePath", (Object)(objectEntryFolder.getTreePath() + "%")));
        });
        actionableDynamicQuery.setPerformActionMethod(descendantObjectEntryFolder -> this._resourceLocalService.deleteResource(descendantObjectEntryFolder.getCompanyId(), ObjectEntryFolder.class.getName(), 4, descendantObjectEntryFolder.getObjectEntryFolderId()));
        actionableDynamicQuery.performActions();
        this._assetEntryLocalService.deleteEntry(ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        this.objectEntryFolderPersistence.removeByG_C_LikeT(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectEntryFolder.getTreePath() + "%");
        this._workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(objectEntryFolder.getCompanyId(), objectEntryFolder.getGroupId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), -1L);
        return objectEntryFolder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectEntryFolder deleteObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
        return this.objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder);
    }

    public ObjectEntryFolder fetchObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) {
        return this.objectEntryFolderPersistence.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public ObjectEntryFolder getObjectEntryFolderByExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) throws PortalException {
        return this.objectEntryFolderPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public List<ObjectEntryFolder> getObjectEntryFolders(long groupId, long companyId, long parentObjectEntryFolderId, int start, int end) {
        return this.objectEntryFolderPersistence.findByG_C_P(groupId, companyId, parentObjectEntryFolderId, start, end);
    }

    public int getObjectEntryFoldersCount(long groupId, long companyId, long parentObjectEntryFolderId) {
        return this.objectEntryFolderPersistence.countByG_C_P(groupId, companyId, parentObjectEntryFolderId);
    }

    public ObjectEntryFolder updateObjectEntryFolder(long userId, long objectEntryFolderId, long parentObjectEntryFolderId, String description, Map<Locale, String> labelMap, String name, ServiceContext serviceContext) throws PortalException {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(objectEntryFolderId);
        this._validateParentObjectEntryFolderId(objectEntryFolder.getGroupId(), objectEntryFolder, parentObjectEntryFolderId);
        this._validateName(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectEntryFolderId, parentObjectEntryFolderId, name);
        objectEntryFolder.setParentObjectEntryFolderId(parentObjectEntryFolderId);
        objectEntryFolder.setDescription(description);
        objectEntryFolder.setLabelMap(this._getLabelMap(labelMap, name));
        objectEntryFolder.setName(name);
        objectEntryFolder.setTreePath(objectEntryFolder.buildTreePath());
        this._updateWorkflowDefinitionLinks(objectEntryFolderId, serviceContext);
        objectEntryFolder = (ObjectEntryFolder)this.objectEntryFolderPersistence.update((BaseModel)objectEntryFolder);
        this._updateAsset(objectEntryFolder, serviceContext);
        return objectEntryFolder;
    }

    private Map<Locale, String> _getLabelMap(Map<Locale, String> labelMap, String name) {
        if (MapUtil.isEmpty(labelMap) || !labelMap.containsKey(LocaleUtil.getSiteDefault())) {
            return HashMapBuilder.putAll(labelMap).put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        }
        return labelMap;
    }

    private void _updateAsset(ObjectEntryFolder objectEntryFolder, ServiceContext serviceContext) throws PortalException {
        this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), objectEntryFolder.getGroupId(), objectEntryFolder.getCreateDate(), objectEntryFolder.getModifiedDate(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId(), objectEntryFolder.getUuid(), 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, objectEntryFolder.getCreateDate(), null, null, objectEntryFolder.getName(), null, null, null, null, 0, 0, null);
    }

    private void _updateWorkflowDefinitionLinks(long objectEntryFolderId, ServiceContext serviceContext) throws PortalException {
        if (!GetterUtil.getBoolean((Object)serviceContext.getAttribute("updateWorkflowDefinitionLinks"), (boolean)true)) {
            return;
        }
        this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), ObjectEntryFolder.class.getName(), objectEntryFolderId, Collections.singletonList(new ObjectValuePair((Object)-1L, (Object)ParamUtil.getString((ServiceContext)serviceContext, (String)"workflowDefinition-1"))));
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId, long companyId) {
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.fetchByERC_G_C(externalReferenceCode, groupId, companyId);
        if (objectEntryFolder != null) {
            throw new DuplicateObjectEntryFolderExternalReferenceCodeException(StringBundler.concat((String[])new String[]{"Duplicate object entry folder with external reference ", "code ", externalReferenceCode}));
        }
    }

    private void _validateName(long groupId, long companyId, long objectEntryFolderId, long parentObjectEntryFolderId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ObjectEntryFolderNameException.MustNotBeNull();
        }
        ObjectEntryFolder objectEntryFolder = this.objectEntryFolderPersistence.fetchByG_C_P_N(groupId, companyId, parentObjectEntryFolderId, name);
        if (objectEntryFolder != null && objectEntryFolder.getObjectEntryFolderId() != objectEntryFolderId) {
            throw new ObjectEntryFolderNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateParentObjectEntryFolderId(long groupId, ObjectEntryFolder objectEntryFolder, long parentObjectEntryFolderId) throws PortalException {
        if (parentObjectEntryFolderId == 0L) {
            return;
        }
        ObjectEntryFolder parentObjectEntryFolder = this.objectEntryFolderPersistence.findByPrimaryKey(parentObjectEntryFolderId);
        if (parentObjectEntryFolder.getGroupId() != groupId) {
            throw new ObjectEntryFolderScopeException(StringBundler.concat((Object[])new Object[]{"Group ID ", groupId, " does not match parent object entry folder group ID ", parentObjectEntryFolder.getGroupId()}));
        }
        if (objectEntryFolder != null && StringUtil.startsWith((String)parentObjectEntryFolder.getTreePath(), (String)objectEntryFolder.getTreePath())) {
            throw new ObjectEntryFolderParentObjectEntryFolderIdException(StringBundler.concat((Object[])new Object[]{"Object entry folder ", objectEntryFolder.getObjectEntryFolderId(), " cannot have one of its children or itself as a parent"}));
        }
    }
}

