/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.layout.tab.screen.navigation.category;

import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationCategory;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectLayoutLocalServiceUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;

public class ObjectLayoutTabScreenNavigationCategory
implements ScreenNavigationCategory,
ScreenNavigationEntry<ObjectLayoutTab> {
    private final ObjectDefinition _objectDefinition;
    private final ObjectLayoutTab _objectLayoutTab;
    private final ObjectRelationship _objectRelationship;

    public ObjectLayoutTabScreenNavigationCategory(ObjectDefinition objectDefinition, ObjectLayoutTab objectLayoutTab, ObjectRelationship objectRelationship) {
        this._objectDefinition = objectDefinition;
        this._objectLayoutTab = objectLayoutTab;
        this._objectRelationship = objectRelationship;
    }

    public String getCategoryKey() {
        return this._getKey();
    }

    public String getEntryKey() {
        return this._getKey();
    }

    public String getLabel(Locale locale) {
        if (this._objectLayoutTab != null) {
            return this._objectLayoutTab.getName(locale);
        }
        if (this._objectRelationship == null) {
            return LanguageUtil.get((Locale)locale, (String)"basic-details");
        }
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)this._objectRelationship.getObjectDefinitionId2());
        if (objectDefinition == null) {
            return "";
        }
        return objectDefinition.getLabel(locale);
    }

    public String getScreenNavigationKey() {
        return this._objectDefinition.getClassName();
    }

    public boolean isVisible(User user, ObjectLayoutTab objectLayoutTab) {
        ObjectLayout objectLayout = ObjectLayoutLocalServiceUtil.fetchDefaultObjectLayout((long)this._objectDefinition.getObjectDefinitionId());
        if (objectLayout != null && this._objectLayoutTab == null) {
            return false;
        }
        if (this._objectRelationship == null) {
            return true;
        }
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)this._objectRelationship.getObjectDefinitionId2());
        return objectDefinition != null && objectDefinition.isActive();
    }

    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletRequest.setAttribute("REGULAR_OBJECT_LAYOUT_TAB", (Object)Boolean.TRUE);
    }

    private String _getKey() {
        if (this._objectLayoutTab != null) {
            return String.valueOf(this._objectLayoutTab.getObjectLayoutTabId());
        }
        if (this._objectRelationship != null) {
            return String.valueOf(this._objectRelationship.getObjectRelationshipId());
        }
        return String.valueOf(this._objectDefinition.getObjectDefinitionId());
    }
}

