/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectDefinitionSetting;
import com.liferay.object.service.ObjectDefinitionSettingLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectDefinitionSetting service. Represents a row in the &quot;ObjectDefinitionSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectDefinitionSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectDefinitionSettingImpl
 * @see ObjectDefinitionSetting
 * @generated
 */
public abstract class ObjectDefinitionSettingBaseImpl
	extends ObjectDefinitionSettingModelImpl
	implements ObjectDefinitionSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object definition setting model instance should use the <code>ObjectDefinitionSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectDefinitionSettingLocalServiceUtil.addObjectDefinitionSetting(
				this);
		}
		else {
			ObjectDefinitionSettingLocalServiceUtil.
				updateObjectDefinitionSetting(this);
		}
	}

}