/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.uad.exporter;

import com.liferay.object.internal.uad.constants.ObjectUADConstants;
import com.liferay.object.internal.uad.util.ObjectEntryUADUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.user.associated.data.exporter.DynamicQueryUADExporter;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryUADExporter
extends DynamicQueryUADExporter<ObjectEntry> {
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;

    public ObjectEntryUADExporter(ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService) {
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
    }

    public Class<ObjectEntry> getTypeClass() {
        return ObjectEntry.class;
    }

    public String getTypeKey() {
        return this._objectDefinition.getClassName();
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return ObjectEntryUADUtil.addActionableDynamicQueryCriteria(this._objectEntryLocalService.getActionableDynamicQuery(), this._objectDefinition.getObjectDefinitionId());
    }

    protected String[] doGetUserIdFieldNames() {
        return ObjectUADConstants.USER_ID_FIELD_NAMES_OBJECT_ENTRY;
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(long userId) {
        return ObjectEntryUADUtil.addActionableDynamicQueryCriteria(this.doGetActionableDynamicQuery(), this.doGetUserIdFieldNames(), userId);
    }

    protected String toXmlString(ObjectEntry objectEntry) {
        StringBundler sb = new StringBundler();
        sb.append(StringBundler.concat((String[])new String[]{"<model><model-name>", this._objectDefinition.getClassName(), "</model-name>"}));
        sb.append(this._getColumn("objectEntryId", String.valueOf(objectEntry.getObjectEntryId())));
        sb.append(this._getColumn("statusByUserId", String.valueOf(objectEntry.getStatusByUserId())));
        sb.append(this._getColumn("statusByUserName", objectEntry.getStatusByUserName()));
        sb.append(this._getColumn("userId", String.valueOf(objectEntry.getUserId())));
        sb.append(this._getColumn("userName", objectEntry.getUserName()));
        Map values = objectEntry.getValues();
        for (Map.Entry entry : values.entrySet()) {
            if (Objects.equals(entry.getKey(), this._objectDefinition.getPKObjectFieldName())) continue;
            sb.append(this._getColumn((String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        sb.append("</model>");
        return sb.toString();
    }

    private String _getColumn(String columnName, String columnValue) {
        return StringBundler.concat((String[])new String[]{"<column><column-name>", columnName, "</column-name><column-value><![CDATA[", columnValue, "]]></column-value></column>"});
    }
}

