/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectField service. Represents a row in the &quot;ObjectField&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFieldImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFieldImpl
 * @see ObjectField
 * @generated
 */
public abstract class ObjectFieldBaseImpl
	extends ObjectFieldModelImpl implements ObjectField {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object field model instance should use the <code>ObjectField</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectFieldLocalServiceUtil.addObjectField(this);
		}
		else {
			ObjectFieldLocalServiceUtil.updateObjectField(this);
		}
	}

}