/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectDefinitionSetting;
import com.liferay.object.model.ObjectDefinitionSettingModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectDefinitionSetting service. Represents a row in the &quot;ObjectDefinitionSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectDefinitionSettingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectDefinitionSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectDefinitionSettingImpl
 * @generated
 */
public class ObjectDefinitionSettingModelImpl
	extends BaseModelImpl<ObjectDefinitionSetting>
	implements ObjectDefinitionSettingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object definition setting model instance should use the <code>ObjectDefinitionSetting</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectDefinitionSetting";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectDefinitionSettingId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"objectDefinitionId", Types.BIGINT},
		{"name", Types.VARCHAR}, {"value", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectDefinitionSettingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("value", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectDefinitionSetting (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectDefinitionSettingId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId LONG,name VARCHAR(75) null,value VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table ObjectDefinitionSetting";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectDefinitionSetting.objectDefinitionSettingId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectDefinitionSetting.objectDefinitionSettingId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONSETTINGID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectDefinitionSettingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectDefinitionSettingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectDefinitionSettingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectDefinitionSettingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectDefinitionSetting.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectDefinitionSetting.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectDefinitionSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectDefinitionSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectDefinitionSetting, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectDefinitionSetting)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectDefinitionSetting, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectDefinitionSetting, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectDefinitionSetting)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectDefinitionSetting, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectDefinitionSetting, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<ObjectDefinitionSetting, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectDefinitionSetting, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectDefinitionSetting, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectDefinitionSetting::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", ObjectDefinitionSetting::getUuid);
			attributeGetterFunctions.put(
				"objectDefinitionSettingId",
				ObjectDefinitionSetting::getObjectDefinitionSettingId);
			attributeGetterFunctions.put(
				"companyId", ObjectDefinitionSetting::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectDefinitionSetting::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectDefinitionSetting::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectDefinitionSetting::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectDefinitionSetting::getModifiedDate);
			attributeGetterFunctions.put(
				"objectDefinitionId",
				ObjectDefinitionSetting::getObjectDefinitionId);
			attributeGetterFunctions.put(
				"name", ObjectDefinitionSetting::getName);
			attributeGetterFunctions.put(
				"value", ObjectDefinitionSetting::getValue);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<ObjectDefinitionSetting, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectDefinitionSetting, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectDefinitionSetting, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectDefinitionSetting, Long>)
					ObjectDefinitionSetting::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectDefinitionSetting, String>)
					ObjectDefinitionSetting::setUuid);
			attributeSetterBiConsumers.put(
				"objectDefinitionSettingId",
				(BiConsumer<ObjectDefinitionSetting, Long>)
					ObjectDefinitionSetting::setObjectDefinitionSettingId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectDefinitionSetting, Long>)
					ObjectDefinitionSetting::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectDefinitionSetting, Long>)
					ObjectDefinitionSetting::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectDefinitionSetting, String>)
					ObjectDefinitionSetting::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectDefinitionSetting, Date>)
					ObjectDefinitionSetting::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectDefinitionSetting, Date>)
					ObjectDefinitionSetting::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectDefinitionId",
				(BiConsumer<ObjectDefinitionSetting, Long>)
					ObjectDefinitionSetting::setObjectDefinitionId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectDefinitionSetting, String>)
					ObjectDefinitionSetting::setName);
			attributeSetterBiConsumers.put(
				"value",
				(BiConsumer<ObjectDefinitionSetting, String>)
					ObjectDefinitionSetting::setValue);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectDefinitionSettingId() {
		return _objectDefinitionSettingId;
	}

	@Override
	public void setObjectDefinitionSettingId(long objectDefinitionSettingId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionSettingId = objectDefinitionSettingId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectDefinitionSetting.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectDefinitionSetting.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectDefinitionSetting toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectDefinitionSetting>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectDefinitionSettingImpl objectDefinitionSettingImpl =
			new ObjectDefinitionSettingImpl();

		objectDefinitionSettingImpl.setMvccVersion(getMvccVersion());
		objectDefinitionSettingImpl.setUuid(getUuid());
		objectDefinitionSettingImpl.setObjectDefinitionSettingId(
			getObjectDefinitionSettingId());
		objectDefinitionSettingImpl.setCompanyId(getCompanyId());
		objectDefinitionSettingImpl.setUserId(getUserId());
		objectDefinitionSettingImpl.setUserName(getUserName());
		objectDefinitionSettingImpl.setCreateDate(getCreateDate());
		objectDefinitionSettingImpl.setModifiedDate(getModifiedDate());
		objectDefinitionSettingImpl.setObjectDefinitionId(
			getObjectDefinitionId());
		objectDefinitionSettingImpl.setName(getName());
		objectDefinitionSettingImpl.setValue(getValue());

		objectDefinitionSettingImpl.resetOriginalValues();

		return objectDefinitionSettingImpl;
	}

	@Override
	public ObjectDefinitionSetting cloneWithOriginalValues() {
		ObjectDefinitionSettingImpl objectDefinitionSettingImpl =
			new ObjectDefinitionSettingImpl();

		objectDefinitionSettingImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectDefinitionSettingImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectDefinitionSettingImpl.setObjectDefinitionSettingId(
			this.<Long>getColumnOriginalValue("objectDefinitionSettingId"));
		objectDefinitionSettingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectDefinitionSettingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectDefinitionSettingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectDefinitionSettingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectDefinitionSettingImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectDefinitionSettingImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectDefinitionSettingImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectDefinitionSettingImpl.setValue(
			this.<String>getColumnOriginalValue("value"));

		return objectDefinitionSettingImpl;
	}

	@Override
	public int compareTo(ObjectDefinitionSetting objectDefinitionSetting) {
		long primaryKey = objectDefinitionSetting.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectDefinitionSetting)) {
			return false;
		}

		ObjectDefinitionSetting objectDefinitionSetting =
			(ObjectDefinitionSetting)object;

		long primaryKey = objectDefinitionSetting.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectDefinitionSetting> toCacheModel() {
		ObjectDefinitionSettingCacheModel objectDefinitionSettingCacheModel =
			new ObjectDefinitionSettingCacheModel();

		objectDefinitionSettingCacheModel.mvccVersion = getMvccVersion();

		objectDefinitionSettingCacheModel.uuid = getUuid();

		String uuid = objectDefinitionSettingCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectDefinitionSettingCacheModel.uuid = null;
		}

		objectDefinitionSettingCacheModel.objectDefinitionSettingId =
			getObjectDefinitionSettingId();

		objectDefinitionSettingCacheModel.companyId = getCompanyId();

		objectDefinitionSettingCacheModel.userId = getUserId();

		objectDefinitionSettingCacheModel.userName = getUserName();

		String userName = objectDefinitionSettingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectDefinitionSettingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectDefinitionSettingCacheModel.createDate = createDate.getTime();
		}
		else {
			objectDefinitionSettingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectDefinitionSettingCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			objectDefinitionSettingCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectDefinitionSettingCacheModel.objectDefinitionId =
			getObjectDefinitionId();

		objectDefinitionSettingCacheModel.name = getName();

		String name = objectDefinitionSettingCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectDefinitionSettingCacheModel.name = null;
		}

		objectDefinitionSettingCacheModel.value = getValue();

		String value = objectDefinitionSettingCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			objectDefinitionSettingCacheModel.value = null;
		}

		return objectDefinitionSettingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectDefinitionSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectDefinitionSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectDefinitionSetting, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectDefinitionSetting)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, ObjectDefinitionSetting>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						ObjectDefinitionSetting.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectDefinitionSettingId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId;
	private String _name;
	private String _value;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectDefinitionSetting, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectDefinitionSetting)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectDefinitionSettingId", _objectDefinitionSettingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("value", _value);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectDefinitionSettingId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectDefinitionId", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("value", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectDefinitionSetting _escapedModel;

}