/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.base.ObjectEntryVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntryVersion"}, service={AopService.class})
public class ObjectEntryVersionServiceImpl
extends ObjectEntryVersionServiceBaseImpl {
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryService _objectEntryService;

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        this._checkModelResourcePermission(objectEntryId);
        return this.objectEntryVersionLocalService.getObjectEntryVersion(objectEntryId, version);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end) throws PortalException {
        this._checkModelResourcePermission(objectEntryId);
        return this.objectEntryVersionLocalService.getObjectEntryVersions(objectEntryId, start, end);
    }

    public int getObjectEntryVersionsCount(long objectEntryId) throws PortalException {
        this._checkModelResourcePermission(objectEntryId);
        return this.objectEntryVersionLocalService.getObjectEntryVersionsCount(objectEntryId);
    }

    private void _checkModelResourcePermission(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntryId);
        this._objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntryId, "UPDATE");
    }
}

