/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.model.impl;

import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalServiceUtil;
import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.impl.ObjectEntryBaseImpl;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectEntryFolderLocalServiceUtil;
import com.liferay.object.service.ObjectEntryLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryImpl
extends ObjectEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryImpl.class);
    private Map<String, Serializable> _transientValues;
    private Map<String, Serializable> _values;

    public String buildTreePath() throws PortalException {
        if (this.getObjectEntryFolderId() == 0L) {
            return "/";
        }
        ObjectEntryFolder objectEntryFolder = ObjectEntryFolderLocalServiceUtil.getObjectEntryFolder((long)this.getObjectEntryFolderId());
        return objectEntryFolder.buildTreePath();
    }

    @Override
    public ObjectEntry cloneWithOriginalValues() {
        ObjectEntry objectEntry = super.cloneWithOriginalValues();
        objectEntry.setValues(this._transientValues);
        return objectEntry;
    }

    @Override
    public String getModelClassName() {
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)this.getObjectDefinitionId());
        if (objectDefinition == null) {
            return "";
        }
        return objectDefinition.getClassName();
    }

    public long getNonzeroGroupId() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId == 0L) {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            groupId = company.getGroupId();
        }
        return groupId;
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(PortalUtil.getClassNameId((String)this.getModelClassName()));
    }

    public Map<Locale, String> getTitleMap() throws PortalException {
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.getObjectDefinition((long)this.getObjectDefinitionId());
        if (objectDefinition == null || objectDefinition.getTitleObjectFieldId() == 0L) {
            return Collections.emptyMap();
        }
        ObjectField objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)objectDefinition.getTitleObjectFieldId());
        if (objectField == null || !objectField.isLocalized()) {
            return Collections.emptyMap();
        }
        Map<String, Serializable> values = this.getValues();
        Map localizedValues = (Map)((Object)values.get(objectField.getI18nObjectFieldName()));
        if (MapUtil.isEmpty((Map)localizedValues)) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        for (Map.Entry entry : localizedValues.entrySet()) {
            titleMap.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), String.valueOf(ObjectEntryValuesUtil.getValue((String)((String)entry.getKey()), (ObjectField)objectField, new HashMap<String, Serializable>(values))));
        }
        return titleMap;
    }

    public String getTitleValue() throws PortalException {
        return this.getTitleValue(null);
    }

    public String getTitleValue(String languageId) throws PortalException {
        return this.getTitleValue(languageId, false);
    }

    public String getTitleValue(String languageId, boolean useDefault) throws PortalException {
        ObjectField objectField;
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.getObjectDefinition((long)this.getObjectDefinitionId());
        if (objectDefinition != null && objectDefinition.getTitleObjectFieldId() > 0L && (objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)objectDefinition.getTitleObjectFieldId())) != null) {
            String title = String.valueOf(ObjectEntryValuesUtil.getValue((String)languageId, (ObjectField)objectField, new HashMap<String, Serializable>(this.getValues())));
            if (Validator.isNull((String)title) && useDefault) {
                title = String.valueOf(ObjectEntryValuesUtil.getValue((String)this.getDefaultLanguageId(), (ObjectField)objectField, new HashMap<String, Serializable>(this.getValues())));
            }
            if (Validator.isNotNull((String)title)) {
                return title;
            }
            if (Objects.equals(objectField.getName(), "id")) {
                return String.valueOf(this.getObjectEntryId());
            }
            return ObjectEntryValuesUtil.getValueString((ObjectField)objectField, (Map)ObjectEntryLocalServiceUtil.getSystemValues((ObjectEntry)this));
        }
        return String.valueOf(this.getObjectEntryId());
    }

    public String getURLTitle(Locale locale) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-21926")) {
            return null;
        }
        FriendlyURLEntry friendlyURLEntry = FriendlyURLEntryLocalServiceUtil.fetchMainFriendlyURLEntry((long)ClassNameLocalServiceUtil.getClassNameId((String)this.getModelClassName()), (long)this.getObjectEntryId());
        if (friendlyURLEntry == null) {
            return null;
        }
        return friendlyURLEntry.getUrlTitle(LocaleUtil.toLanguageId((Locale)locale));
    }

    public Map<String, String> getURLTitleMap() {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-21926")) {
            return null;
        }
        FriendlyURLEntry friendlyURLEntry = FriendlyURLEntryLocalServiceUtil.fetchMainFriendlyURLEntry((long)ClassNameLocalServiceUtil.getClassNameId((String)this.getModelClassName()), (long)this.getObjectEntryId());
        if (friendlyURLEntry == null) {
            return null;
        }
        return friendlyURLEntry.getLanguageIdToUrlTitleMap();
    }

    public Map<String, Serializable> getValues() {
        if (this._values == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Get values for object entry " + this.getObjectEntryId()));
            }
            try {
                this._values = ObjectEntryLocalServiceUtil.getValues((ObjectEntry)this);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return new HashMap<String, Serializable>();
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Use cached values for object entry " + this.getObjectEntryId()));
        }
        return this._values;
    }

    public void setTransientValues(Map<String, Serializable> values) {
        this._transientValues = values;
    }

    public void setValues(Map<String, Serializable> values) {
        this._values = values;
    }
}

