/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.base.ObjectEntryVersionLocalServiceBaseImpl;
import com.liferay.object.util.comparator.ObjectEntryVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntryVersion"}, service={AopService.class})
public class ObjectEntryVersionLocalServiceImpl
extends ObjectEntryVersionLocalServiceBaseImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectEntryVersion addObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        return this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.create(this.counterLocalService.increment()), objectEntry.getVersion() + 1);
    }

    public void deleteObjectEntryVersions(long objectEntryId) {
        this.objectEntryVersionPersistence.removeByObjectEntryId(objectEntryId);
    }

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        return this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId, start, end);
    }

    public int getObjectEntryVersionsCount(long objectEntryId) {
        return this.objectEntryVersionPersistence.countByObjectEntryId(objectEntryId);
    }

    public ObjectEntryVersion updateLatestObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        return this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.fetchByObjectEntryId_First(objectEntry.getObjectEntryId(), (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false)), objectEntry.getVersion());
    }

    private ObjectEntryVersion _updateObjectEntryVersion(ObjectEntry objectEntry, ObjectEntryVersion objectEntryVersion, int version) throws PortalException {
        User user = this._userLocalService.getUser(objectEntry.getUserId());
        objectEntryVersion.setUserId(user.getUserId());
        objectEntryVersion.setUserName(user.getFullName());
        objectEntryVersion.setCreateDate(objectEntry.getCreateDate());
        objectEntryVersion.setModifiedDate(objectEntry.getModifiedDate());
        objectEntryVersion.setObjectEntryId(objectEntry.getObjectEntryId());
        try {
            objectEntryVersion.setContent(ObjectEntryDTOConverterUtil.toDTO((DTOConverterRegistry)this._dtoConverterRegistry, (JSONFactory)this._jsonFactory, (ObjectEntry)objectEntry, (User)user));
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        objectEntryVersion.setVersion(version);
        objectEntryVersion.setStatus(objectEntry.getStatus());
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }
}

