/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.model.ObjectStateTransition;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.object.service.ObjectStateTransitionLocalService;
import com.liferay.object.service.base.ObjectStateFlowLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectStateFlow"}, service={AopService.class})
public class ObjectStateFlowLocalServiceImpl
extends ObjectStateFlowLocalServiceBaseImpl {
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectStateLocalService _objectStateLocalService;
    @Reference
    private ObjectStateTransitionLocalService _objectStateTransitionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectStateFlow addDefaultObjectStateFlow(ObjectField objectField) throws PortalException {
        if (!objectField.isState()) {
            return null;
        }
        ObjectStateFlow objectStateFlow = this._addObjectStateFlow(objectField.getUserId(), objectField.getObjectFieldId());
        List objectStates = TransformUtil.transform((Collection)this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId()), listTypeEntry -> this._objectStateLocalService.addObjectState(objectField.getUserId(), listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId()));
        for (ObjectState sourceObjectState : objectStates) {
            for (ObjectState targetObjectState : objectStates) {
                if (sourceObjectState.equals(targetObjectState)) continue;
                this._objectStateTransitionLocalService.addObjectStateTransition(objectField.getUserId(), objectStateFlow.getObjectStateFlowId(), sourceObjectState.getObjectStateId(), targetObjectState.getObjectStateId());
            }
        }
        this._addOrUpdateObjectFieldSetting(objectField.getUserId(), objectField.getObjectFieldId(), objectStateFlow.getObjectStateFlowId());
        return objectStateFlow;
    }

    public ObjectStateFlow addObjectStateFlow(long userId, long objectFieldId, List<ObjectState> objectStates) throws PortalException {
        ObjectStateFlow objectStateFlow = this._addObjectStateFlow(userId, objectFieldId);
        this._addObjectStatesAndObjectStateTransitions(userId, objectStateFlow.getObjectStateFlowId(), objectStates);
        this._addOrUpdateObjectFieldSetting(userId, objectFieldId, objectStateFlow.getObjectStateFlowId());
        return objectStateFlow;
    }

    public void deleteObjectFieldObjectStateFlow(long objectFieldId) throws PortalException {
        ObjectStateFlow objectStateFlow = this.objectStateFlowPersistence.fetchByObjectFieldId(objectFieldId);
        this.objectStateFlowPersistence.remove(objectStateFlow.getObjectStateFlowId());
        this._objectStateLocalService.deleteObjectStateFlowObjectStates(objectStateFlow.getObjectStateFlowId());
        this._objectStateTransitionLocalService.deleteObjectStateFlowObjectStateTransitions(objectStateFlow.getObjectStateFlowId());
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "stateFlow");
        if (objectFieldSetting != null) {
            this._objectFieldSettingLocalService.deleteObjectFieldSetting(objectFieldSetting.getObjectFieldSettingId());
        }
    }

    public ObjectStateFlow fetchObjectFieldObjectStateFlow(long objectFieldId) {
        return this.objectStateFlowPersistence.fetchByObjectFieldId(objectFieldId);
    }

    public ObjectStateFlow updateDefaultObjectStateFlow(ObjectField newObjectField, ObjectField oldObjectField) throws PortalException {
        if (!oldObjectField.isState() && !newObjectField.isState()) {
            return null;
        }
        if (oldObjectField.isState() && !newObjectField.isState()) {
            this.deleteObjectFieldObjectStateFlow(oldObjectField.getObjectFieldId());
            return null;
        }
        if (!oldObjectField.isState() && newObjectField.isState()) {
            return this.addDefaultObjectStateFlow(newObjectField);
        }
        if (oldObjectField.getListTypeDefinitionId() == newObjectField.getListTypeDefinitionId()) {
            return null;
        }
        this.deleteObjectFieldObjectStateFlow(oldObjectField.getObjectFieldId());
        return this.addDefaultObjectStateFlow(newObjectField);
    }

    public void updateObjectStateFlow(long userId, long objectStateFlowId, List<ObjectState> objectStates) throws PortalException {
        this._objectStateTransitionLocalService.deleteObjectStateFlowObjectStateTransitions(objectStateFlowId);
        this._objectStateLocalService.deleteObjectStateFlowObjectStates(objectStateFlowId);
        this._addObjectStatesAndObjectStateTransitions(userId, objectStateFlowId, objectStates);
    }

    private ObjectStateFlow _addObjectStateFlow(long userId, long objectFieldId) throws PortalException {
        ObjectStateFlow objectStateFlow = this.objectStateFlowPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectStateFlow.setCompanyId(user.getCompanyId());
        objectStateFlow.setUserId(user.getUserId());
        objectStateFlow.setUserName(user.getFullName());
        objectStateFlow.setObjectFieldId(objectFieldId);
        return (ObjectStateFlow)this.objectStateFlowPersistence.update((BaseModel)objectStateFlow);
    }

    private void _addObjectStatesAndObjectStateTransitions(long userId, long objectStateFlowId, List<ObjectState> objectStates) throws PortalException {
        HashMap objectStateIds = new HashMap();
        List sourceObjectStates = TransformUtil.transform(objectStates, objectState -> {
            ObjectState sourceObjectState = this._objectStateLocalService.addObjectState(userId, objectState.getListTypeEntryId(), objectStateFlowId);
            sourceObjectState.setObjectStateTransitions(objectState.getObjectStateTransitions());
            objectStateIds.put(sourceObjectState.getListTypeEntryId(), sourceObjectState.getObjectStateId());
            return sourceObjectState;
        });
        for (ObjectState sourceObjectState : sourceObjectStates) {
            for (ObjectStateTransition objectStateTransition : sourceObjectState.getObjectStateTransitions()) {
                this._objectStateTransitionLocalService.addObjectStateTransition(userId, objectStateFlowId, sourceObjectState.getObjectStateId(), ((Long)objectStateIds.get(objectStateTransition.getTargetObjectStateListTypeEntryId())).longValue());
            }
        }
    }

    private void _addOrUpdateObjectFieldSetting(long userId, long objectFieldId, long objectStateFlowId) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "stateFlow");
        if (objectFieldSetting == null) {
            this._objectFieldSettingLocalService.addObjectFieldSetting(userId, objectFieldId, "stateFlow", String.valueOf(objectStateFlowId));
        } else {
            this._objectFieldSettingLocalService.updateObjectFieldSetting(objectFieldSetting.getObjectFieldSettingId(), String.valueOf(objectStateFlowId));
        }
    }
}

