/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.entry.util;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalServiceUtil;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.extension.EntityExtensionThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ObjectEntryUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryUtil.class);

    public static JSONObject getPayloadJSONObject(BaseModel<?> baseModel, DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, String objectActionTriggerKey, ObjectDefinition objectDefinition, BaseModel<?> originalBaseModel, SystemObjectDefinitionManager systemObjectDefinitionManager, long userId) throws PortalException {
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
        Class modelClass = systemObjectDefinitionManager.getModelClass();
        DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(jaxRsApplicationDescriptor.getApplicationName(), modelClass.getName(), jaxRsApplicationDescriptor.getVersion());
        String dtoConverterType = null;
        dtoConverterType = dtoConverter == null ? modelClass.getSimpleName() : dtoConverter.getContentType();
        Map originalExtendedProperties = ObjectEntryLocalServiceUtil.getExtensionDynamicObjectDefinitionTableValues((ObjectDefinition)objectDefinition, (long)GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()));
        HashMap extendedProperties = HashMapBuilder.putAll((Map)originalExtendedProperties).putAll(EntityExtensionThreadLocal.getExtendedProperties()).build();
        return JSONUtil.put((String)"classPK", (Object)baseModel.getPrimaryKeyObj()).put("extendedProperties", (Object)extendedProperties).put("model" + modelClass.getSimpleName(), (Object)baseModel.getModelAttributes()).put("modelDTO" + dtoConverterType, ObjectEntryUtil._toDTO(baseModel, dtoConverter, dtoConverterRegistry, extendedProperties, jsonFactory, modelClass, userId)).put("objectActionTriggerKey", objectActionTriggerKey).put("original" + modelClass.getSimpleName(), () -> {
            if (originalBaseModel == null) {
                return null;
            }
            return originalBaseModel.getModelAttributes();
        }).put("originalDTO" + dtoConverterType, () -> {
            if (originalBaseModel == null) {
                return null;
            }
            return ObjectEntryUtil._toDTO(originalBaseModel, dtoConverter, dtoConverterRegistry, Collections.emptyMap(), jsonFactory, modelClass, userId);
        }).put("originalExtendedProperties", (Object)originalExtendedProperties);
    }

    public static JSONObject getPayloadJSONObject(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, ObjectDefinition objectDefinition, long primaryKey, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry, long userId) throws PortalException {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            return ObjectEntryUtil.getPayloadJSONObject(systemObjectDefinitionManager.fetchBaseModelByExternalReferenceCode(systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey), objectDefinition.getCompanyId()), dtoConverterRegistry, jsonFactory, null, objectDefinition, null, systemObjectDefinitionManager, userId);
        }
        return ObjectEntryUtil.getPayloadJSONObject(dtoConverterRegistry, jsonFactory, null, objectDefinition, ObjectEntryLocalServiceUtil.fetchObjectEntry((long)primaryKey), null, null, UserLocalServiceUtil.fetchUser((long)userId));
    }

    public static JSONObject getPayloadJSONObject(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, String objectActionTriggerKey, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectEntry originalObjectEntry, String preferredLanguageId, User user) {
        return JSONUtil.put((String)"classPK", (Object)objectEntry.getObjectEntryId()).put("objectActionTriggerKey", objectActionTriggerKey).put("objectEntry", (Object)HashMapBuilder.putAll((Map)objectEntry.getModelAttributes()).put((Object)"creator", (Object)user.getFullName()).put((Object)"id", (Object)objectEntry.getObjectEntryId()).put((Object)"values", (Object)objectEntry.getValues()).build()).put("objectEntryDTO" + objectDefinition.getShortName(), ObjectEntryUtil._toDTO(dtoConverterRegistry, jsonFactory, objectEntry, user)).put("originalObjectEntry", () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return HashMapBuilder.putAll((Map)originalObjectEntry.getModelAttributes()).put((Object)"values", (Object)originalObjectEntry.getValues()).build();
        }).put("originalObjectEntryDTO" + objectDefinition.getShortName(), () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return ObjectEntryUtil._toDTO(dtoConverterRegistry, jsonFactory, originalObjectEntry, user);
        }).put("preferredLanguageId", preferredLanguageId).put("userId", user.getUserId());
    }

    private static Map<String, Object> _toDTO(BaseModel<?> baseModel, DTOConverter<BaseModel<?>, ?> dtoConverter, DTOConverterRegistry dtoConverterRegistry, Map<String, Object> extendedProperties, JSONFactory jsonFactory, Class<?> modelClass, long userId) {
        Map modelAttributes = baseModel.getModelAttributes();
        ExpandoBridge expandoBridge = baseModel.getExpandoBridge();
        modelAttributes.putAll(expandoBridge.getAttributes());
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + modelClass.getName()));
            }
            return modelAttributes;
        }
        User user = UserLocalServiceUtil.fetchUser((long)userId);
        if (user == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user found with user ID " + userId));
            }
            return modelAttributes;
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), dtoConverterRegistry, (Object)baseModel.getPrimaryKeyObj(), user.getLocale(), null, user);
        try {
            Object object = dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, baseModel);
            if (object == null) {
                return modelAttributes;
            }
            JSONObject jsonObject = jsonFactory.createJSONObject(jsonFactory.looseSerializeDeep(object));
            jsonObject.put("createDate", modelAttributes.get("createDate")).put("modifiedDate", modelAttributes.get("modifiedDate")).put("status", modelAttributes.get("status")).put("userName", user.getFullName()).put("uuid", modelAttributes.get("uuid"));
            for (Map.Entry<String, Object> entry : extendedProperties.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            return jsonObject.toMap();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return baseModel.getModelAttributes();
        }
    }

    private static Map<String, Object> _toDTO(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, ObjectEntry objectEntry, User user) {
        DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(ObjectEntry.class.getName());
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + ObjectEntry.class.getName()));
            }
            return objectEntry.getModelAttributes();
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), dtoConverterRegistry, null, user.getLocale(), null, user);
        try {
            JSONObject jsonObject = jsonFactory.createJSONObject(jsonFactory.looseSerializeDeep(dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, (Object)objectEntry)));
            return jsonObject.toMap();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return objectEntry.getModelAttributes();
        }
    }
}

