/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v5_3_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.SetUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;
import java.util.Set;

public class ObjectFieldUpgradeProcess
extends UpgradeProcess {
    private final Set<String> _readOnlyObjectFieldNames = SetUtil.fromArray((Object[])new String[]{"createDate", "creator", "id", "modifiedDate", "status"});

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select objectFieldId, businessType, name from ObjectField");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ObjectField set readOnly = ? where objectFieldId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String readOnly = "false";
                if (Objects.equals(resultSet.getString("businessType"), "Aggregation") || Objects.equals(resultSet.getString("businessType"), "Formula") || this._readOnlyObjectFieldNames.contains(resultSet.getString("name"))) {
                    readOnly = "true";
                }
                preparedStatement2.setString(1, readOnly);
                preparedStatement2.setLong(2, resultSet.getLong("objectFieldId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"ObjectField", (String[])new String[]{"readOnly VARCHAR(75)"}), UpgradeProcessFactory.addColumns((String)"ObjectField", (String[])new String[]{"readOnlyConditionExpression TEXT"})};
    }
}

