/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.Field;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DocumentContributor.class})
public class ObjectEntryDocumentContributor
implements DocumentContributor<ObjectEntry> {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    public void contribute(Document document, BaseModel<ObjectEntry> baseModel) {
        if (!(baseModel instanceof ObjectEntry)) {
            return;
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(((Long)baseModel.getPrimaryKeyObj()).longValue());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
        Field field = document.getField("entryClassName");
        field.setValue(objectDefinition.getClassName());
        document.add(field);
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-42474")) {
            document.addKeyword("folderId", objectEntry.getObjectEntryFolderId());
        }
    }
}

