/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Boolean"}, service={ObjectFieldBusinessType.class})
public class BooleanObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType"});
    }

    public String getDBType() {
        return "Boolean";
    }

    public String getDDMFormFieldTypeName() {
        return "checkbox";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "select-between-true-or-false");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "boolean");
    }

    public String getName() {
        return "Boolean";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.BOOLEAN;
    }

    public boolean isLocalizable() {
        return true;
    }

    public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        if (objectFieldSettingsValuesMap.isEmpty()) {
            return;
        }
        super.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
        if (Objects.equals(objectFieldSettingsValuesMap.get("defaultValueType"), "expressionBuilder")) {
            return;
        }
        String defaultValue = objectFieldSettingsValuesMap.get("defaultValue");
        if (Objects.equals(defaultValue, "false") || Objects.equals(defaultValue, "true")) {
            return;
        }
        throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValue", defaultValue);
    }
}

