/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.rest.context.path;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class RESTContextPathResolverImpl
implements RESTContextPathResolver {
    private String _contextPath;
    private ObjectDefinition _objectDefinition;
    private final ObjectScopeProvider _objectScopeProvider;
    private final boolean _system;

    public RESTContextPathResolverImpl(ObjectDefinition objectDefinition, ObjectScopeProvider objectScopeProvider, boolean system) {
        this._objectDefinition = objectDefinition;
        this._objectScopeProvider = objectScopeProvider;
        this._system = system;
    }

    public RESTContextPathResolverImpl(String contextPath, ObjectScopeProvider objectScopeProvider, boolean system) {
        this._objectScopeProvider = objectScopeProvider;
        this._system = system;
        this._initContextPath(contextPath);
    }

    public String getRESTContextPath(long groupId) {
        if (Validator.isNull((String)this._contextPath)) {
            this._initContextPath("/o" + this._objectDefinition.getRESTContextPath());
        }
        if (!this._objectScopeProvider.isGroupAware() || !this._objectScopeProvider.isValidGroupId(groupId)) {
            return this._contextPath;
        }
        return StringUtil.replace((String)this._contextPath, (String[])new String[]{"{groupId}", "{scopeKey}"}, (String[])new String[]{String.valueOf(groupId), String.valueOf(groupId)});
    }

    private void _initContextPath(String contextPath) {
        this._contextPath = contextPath;
        if (this._objectScopeProvider.isGroupAware() && !this._system) {
            this._contextPath = this._contextPath + "/scopes/{scopeKey}";
        }
    }
}

