/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v9_2_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

public class SchemaUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        long companyId = CompanyThreadLocal.getCompanyId();
        long defaultCompanyId = PortalInstancePool.getDefaultCompanyId();
        if (!DBPartition.isPartitionEnabled() || companyId == defaultCompanyId) {
            return;
        }
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        try (ResultSet resultSet = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"VIEW"});){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String tableNameLowerCase = StringUtil.toLowerCase((String)tableName);
                if (!tableName.contains(String.valueOf(defaultCompanyId)) || !tableNameLowerCase.contains("_x_") && !tableNameLowerCase.startsWith("o_")) continue;
                this.runSQL(StringBundler.concat((String[])new String[]{"drop view if exists ", DBPartitionUtil.getPartitionName((long)companyId), ".", tableName}));
            }
        }
    }
}

