/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class GroupModelListener
extends BaseModelListener<Group> {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    public void onBeforeRemove(Group group) throws ModelListenerException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectDefinitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)group.getCompanyId())).add(RestrictionsFactoryUtil.eq((String)"active", (Object)true)).add(RestrictionsFactoryUtil.eq((String)"system", (Object)false)).add(RestrictionsFactoryUtil.eq((String)"status", (Object)0)));
        actionableDynamicQuery.setPerformActionMethod(objectDefinition -> this._deleteObjectEntries(group.getGroupId(), objectDefinition.getObjectDefinitionId()));
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteObjectEntries(long groupId, long objectDefinitionId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.and((Criterion)RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId), (Criterion)RestrictionsFactoryUtil.eq((String)"objectDefinitionId", (Object)objectDefinitionId))));
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> this._objectEntryLocalService.deleteObjectEntry(objectEntry));
        boolean disassociateRelatedModels = ObjectEntryThreadLocal.isDisassociateRelatedModels();
        try {
            ObjectEntryThreadLocal.setDisassociateRelatedModels((boolean)true);
            actionableDynamicQuery.performActions();
        }
        finally {
            ObjectEntryThreadLocal.setDisassociateRelatedModels((boolean)disassociateRelatedModels);
        }
    }
}

