/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.base.ObjectDefinitionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionServiceImpl
extends ObjectDefinitionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectFolder)")
    private ModelResourcePermission<ObjectFolder> _objectFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public ObjectDefinition addCustomObjectDefinition(long objectFolderId, String className, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, boolean portlet, String scope, String storageType, List<ObjectField> objectFields) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_OBJECT_DEFINITION");
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "ADD_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.addCustomObjectDefinition(this.getUserId(), objectFolderId, className, enableComments, enableIndexSearch, enableLocalization, enableObjectEntryDraft, labelMap, name, panelAppOrder, panelCategoryKey, pluralLabelMap, portlet, scope, storageType, objectFields);
    }

    public ObjectDefinition addObjectDefinition(String externalReferenceCode, long objectFolderId, boolean modifiable, boolean system) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_OBJECT_DEFINITION");
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "ADD_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.addObjectDefinition(externalReferenceCode, this.getUserId(), objectFolderId, modifiable, system);
    }

    public ObjectDefinition addSystemObjectDefinition(String externalReferenceCode, long userId, long objectFolderId, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, boolean portlet, String scope, List<ObjectField> objectFields) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_OBJECT_DEFINITION");
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "ADD_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.addSystemObjectDefinition(externalReferenceCode, userId, objectFolderId, null, null, enableComments, enableIndexSearch, enableLocalization, labelMap, true, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, portlet, scope, null, 1, 2, objectFields);
    }

    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "DELETE");
        return this.objectDefinitionLocalService.deleteObjectDefinition(objectDefinitionId);
    }

    public ObjectDefinition fetchObjectDefinitionByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode(externalReferenceCode, companyId);
        if (objectDefinition != null) {
            this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectDefinition, "VIEW");
        }
        return objectDefinition;
    }

    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "VIEW");
        return this.objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
    }

    public ObjectDefinition getObjectDefinitionByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode(externalReferenceCode, companyId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectDefinition, "VIEW");
        return objectDefinition;
    }

    public List<ObjectDefinition> getObjectDefinitions(int start, int end) {
        return this.objectDefinitionLocalService.getObjectDefinitions(start, end);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, int start, int end) {
        return this.objectDefinitionPersistence.findByCompanyId(companyId, start, end);
    }

    public int getObjectDefinitionsCount() throws PortalException {
        return this.objectDefinitionLocalService.getObjectDefinitionsCount();
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this.objectDefinitionLocalService.getObjectDefinitionsCount(companyId);
    }

    public ObjectDefinition publishCustomObjectDefinition(long objectDefinitionId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "PUBLISH_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.publishCustomObjectDefinition(this.getUserId(), objectDefinitionId);
    }

    public ObjectDefinition publishSystemObjectDefinition(long objectDefinitionId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "PUBLISH_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.publishSystemObjectDefinition(this.getUserId(), objectDefinitionId);
    }

    public ObjectDefinition updateCustomObjectDefinition(String externalReferenceCode, long objectDefinitionId, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long objectFolderId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, String className, boolean enableCategorization, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, boolean enableObjectEntryHistory, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, Map<Locale, String> pluralLabelMap, String scope, int status) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "ADD_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.updateCustomObjectDefinition(externalReferenceCode, objectDefinitionId, accountEntryRestrictedObjectFieldId, descriptionObjectFieldId, objectFolderId, titleObjectFieldId, accountEntryRestricted, active, className, enableCategorization, enableComments, enableIndexSearch, enableLocalization, enableObjectEntryDraft, enableObjectEntryHistory, labelMap, name, panelAppOrder, panelCategoryKey, portlet, pluralLabelMap, scope, status);
    }

    public ObjectDefinition updateExternalReferenceCode(long objectDefinitionId, String externalReferenceCode) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        return this.objectDefinitionLocalService.updateExternalReferenceCode(objectDefinitionId, externalReferenceCode);
    }

    public ObjectDefinition updateRootObjectDefinitionId(long objectDefinitionId, long rootObjectDefinitionId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        return this.objectDefinitionLocalService.updateRootObjectDefinitionId(objectDefinitionId, rootObjectDefinitionId);
    }

    public ObjectDefinition updateSystemObjectDefinition(String externalReferenceCode, long objectDefinitionId, long objectFolderId, long titleObjectFieldId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        this._objectFolderModelResourcePermission.check(this.getPermissionChecker(), objectFolderId, "ADD_OBJECT_DEFINITION");
        return this.objectDefinitionLocalService.updateSystemObjectDefinition(externalReferenceCode, objectDefinitionId, objectFolderId, titleObjectFieldId);
    }

    public ObjectDefinition updateTitleObjectFieldId(long objectDefinitionId, long titleObjectFieldId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        return this.objectDefinitionLocalService.updateTitleObjectFieldId(objectDefinitionId, titleObjectFieldId);
    }
}

