/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.fragment.cache.FragmentEntryLinkCache;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.object.definition.util.ObjectDefinitionThreadLocal;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.deployer.InactiveObjectDefinitionDeployer;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedObjectFieldIdException;
import com.liferay.object.exception.ObjectDefinitionActiveException;
import com.liferay.object.exception.ObjectDefinitionClassNameException;
import com.liferay.object.exception.ObjectDefinitionEnableCategorizationException;
import com.liferay.object.exception.ObjectDefinitionEnableCommentsException;
import com.liferay.object.exception.ObjectDefinitionEnableLocalizationException;
import com.liferay.object.exception.ObjectDefinitionEnableObjectEntryHistoryException;
import com.liferay.object.exception.ObjectDefinitionExternalReferenceCodeException;
import com.liferay.object.exception.ObjectDefinitionLabelException;
import com.liferay.object.exception.ObjectDefinitionModifiableException;
import com.liferay.object.exception.ObjectDefinitionNameException;
import com.liferay.object.exception.ObjectDefinitionPanelCategoryKeyException;
import com.liferay.object.exception.ObjectDefinitionPluralLabelException;
import com.liferay.object.exception.ObjectDefinitionPortletException;
import com.liferay.object.exception.ObjectDefinitionRootObjectDefinitionIdException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectDefinitionSystemException;
import com.liferay.object.exception.ObjectDefinitionVersionException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.ObjectRelationshipEdgeException;
import com.liferay.object.exception.RequiredObjectDefinitionException;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.internal.dao.db.ObjectDBManagerUtil;
import com.liferay.object.internal.deployer.InactiveObjectDefinitionDeployerImpl;
import com.liferay.object.internal.deployer.ObjectDefinitionDeployerImpl;
import com.liferay.object.internal.security.permission.resource.util.ObjectDefinitionResourcePermissionUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldModel;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.impl.ObjectDefinitionImpl;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTableFactory;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableFactory;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistrarHelper;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFolderItemLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.ObjectLayoutTabLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectDefinitionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectFolderPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.object.tree.Tree;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"model.class.name=com.liferay.object.model.ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionLocalServiceImpl
extends ObjectDefinitionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionLocalServiceImpl.class);
    private static final MethodKey _deployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "deployObjectDefinition", new Class[]{ObjectDefinition.class});
    private static final MethodKey _undeployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "undeployObjectDefinition", new Class[]{ObjectDefinition.class});
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference
    private FragmentEntryLinkCache _fragmentEntryLinkCache;
    @Reference
    private GroupLocalService _groupLocalService;
    private final Map<InactiveObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> _inactiveObjectDefinitionsServiceRegistrationsMaps = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private Language _language;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    private ServiceTracker<ObjectDefinitionDeployer, ObjectDefinitionDeployer> _objectDefinitionDeployerServiceTracker;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFolderItemLocalService _objectFolderItemLocalService;
    @Reference
    private ObjectFolderLocalService _objectFolderLocalService;
    @Reference
    private ObjectFolderPersistence _objectFolderPersistence;
    @Reference
    private ObjectLayoutLocalService _objectLayoutLocalService;
    @Reference
    private ObjectLayoutTabLocalService _objectLayoutTabLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistrarHelper _objectRelatedModelsProviderRegistrarHelper;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private ResourcePermissionPersistence _resourcePermissionPersistence;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;
    private final Map<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> _serviceRegistrationsMaps = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    private ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addCustomObjectDefinition(long userId, long objectFolderId, String className, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, boolean portlet, String scope, String storageType, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(null, userId, objectFolderId, className, null, enableComments, enableIndexSearch, enableLocalization, enableObjectEntryDraft, labelMap, true, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, portlet, scope, storageType, false, null, 0, 2, objectFields);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addObjectDefinition(String externalReferenceCode, long userId, long objectFolderId, boolean modifiable, boolean system) throws PortalException {
        this._validateExternalReferenceCode(externalReferenceCode, system);
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setObjectFolderId(this._getObjectFolderId(user.getCompanyId(), objectFolderId));
        objectDefinition.setActive(false);
        objectDefinition.setLabel(externalReferenceCode);
        objectDefinition.setModifiable(modifiable);
        objectDefinition.setName(externalReferenceCode);
        objectDefinition.setPluralLabel(externalReferenceCode);
        objectDefinition.setScope("company");
        objectDefinition.setStorageType("default");
        objectDefinition.setSystem(system);
        objectDefinition.setStatus(2);
        if (objectDefinition.isUnmodifiableSystemObject() || !modifiable) {
            throw new ObjectDefinitionModifiableException.MustBeModifiable();
        }
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._addOrUpdateObjectDefinitionPLOEntries(objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        this._objectFolderItemLocalService.addObjectFolderItem(userId, objectDefinition.getObjectDefinitionId(), objectDefinition.getObjectFolderId(), 0, 0);
        this._addSystemObjectFields(ObjectEntryTable.INSTANCE.getTableName(), objectDefinition, ObjectEntryTable.INSTANCE.objectEntryId.getName(), userId);
        return this._updateTitleObjectFieldId(objectDefinition, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addOrUpdateSystemObjectDefinition(long companyId, long objectFolderId, SystemObjectDefinitionManager systemObjectDefinitionManager) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, systemObjectDefinitionManager.getName());
        long userId = this._userLocalService.getGuestUserId(companyId);
        if (objectDefinition == null) {
            Table table = systemObjectDefinitionManager.getTable();
            Column primaryKeyColumn = systemObjectDefinitionManager.getPrimaryKeyColumn();
            objectDefinition = this.addSystemObjectDefinition(systemObjectDefinitionManager.getExternalReferenceCode(), userId, objectFolderId, systemObjectDefinitionManager.getModelClassName(), table.getTableName(), false, true, false, systemObjectDefinitionManager.getLabelMap(), false, systemObjectDefinitionManager.getName(), null, null, primaryKeyColumn.getName(), primaryKeyColumn.getName(), systemObjectDefinitionManager.getPluralLabelMap(), false, systemObjectDefinitionManager.getScope(), systemObjectDefinitionManager.getTitleObjectFieldName(), systemObjectDefinitionManager.getVersion(), 0, systemObjectDefinitionManager.getObjectFields());
            this._addOrUpdateObjectActions(userId, objectDefinition.getObjectDefinitionId(), systemObjectDefinitionManager.getObjectActions());
            return objectDefinition;
        }
        objectDefinition.setObjectFolderId(objectFolderId);
        objectDefinition.setLabelMap(systemObjectDefinitionManager.getLabelMap());
        objectDefinition.setPluralLabelMap(systemObjectDefinitionManager.getPluralLabelMap());
        objectDefinition.setVersion(systemObjectDefinitionManager.getVersion());
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        List newObjectFields = systemObjectDefinitionManager.getObjectFields();
        List oldObjectFields = this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), objectDefinition.getDBTableName());
        for (ObjectField oldObjectField : oldObjectFields) {
            if (!oldObjectField.isSystem() || ObjectFieldUtil.isMetadata((String)oldObjectField.getName()) || this._hasObjectField(newObjectFields, oldObjectField)) continue;
            this._objectFieldPersistence.remove((BaseModel)oldObjectField);
        }
        for (ObjectField newObjectField : newObjectFields) {
            ObjectField oldObjectField = this._objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), newObjectField.getName());
            if (oldObjectField == null) {
                this._objectFieldLocalService.addSystemObjectField(newObjectField.getExternalReferenceCode(), userId, newObjectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), newObjectField.getBusinessType(), newObjectField.getDBColumnName(), objectDefinition.getDBTableName(), newObjectField.getDBType(), false, false, "", newObjectField.getLabelMap(), newObjectField.isLocalized(), newObjectField.getName(), newObjectField.getReadOnly(), newObjectField.getReadOnlyConditionExpression(), newObjectField.isRequired(), newObjectField.isState(), newObjectField.getObjectFieldSettings());
                continue;
            }
            if (Objects.equals(oldObjectField.getDBType(), newObjectField.getDBType()) && Objects.equals(oldObjectField.isRequired(), newObjectField.isRequired())) continue;
            oldObjectField.setBusinessType(newObjectField.getBusinessType());
            oldObjectField.setDBType(newObjectField.getDBType());
            oldObjectField.setRequired(newObjectField.isRequired());
            this._objectFieldPersistence.update((BaseModel)oldObjectField);
        }
        this._addOrUpdateObjectActions(userId, objectDefinition.getObjectDefinitionId(), systemObjectDefinitionManager.getObjectActions());
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addSystemObjectDefinition(String externalReferenceCode, long userId, long objectFolderId, String className, String dbTableName, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, Map<Locale, String> labelMap, boolean modifiable, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, boolean portlet, String scope, String titleObjectFieldName, int version, int status, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(externalReferenceCode, userId, objectFolderId, className, dbTableName, enableComments, enableIndexSearch, enableLocalization, false, labelMap, modifiable, name, panelAppOrder, panelCategoryKey, pkObjectFieldDBColumnName, pkObjectFieldName, pluralLabelMap, portlet, scope, "default", true, titleObjectFieldName, version, status, objectFields);
    }

    public void deleteCompanyObjectDefinitions(long companyId) throws PortalException {
        List objectDefinitions = this.objectDefinitionPersistence.findByCompanyId(companyId);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this.objectDefinitionLocalService.deleteObjectDefinition(objectDefinition);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.deleteObjectDefinition(objectDefinition);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectDefinition deleteObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        if (!PortalInstances.isCurrentCompanyInDeletionProcess() && !PortalRunMode.isTestMode() && objectDefinition.isUnmodifiableSystemObject()) {
            throw new RequiredObjectDefinitionException();
        }
        if (objectDefinition.getRootObjectDefinitionId() != 0L) {
            throw new ObjectDefinitionRootObjectDefinitionIdException("To delete this object, you must first disable inheritance and delete its relationships", "to-delete-this-object-you-must-first-disable-inheritance-and-delete-its-relationships");
        }
        if (objectDefinition.isSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            throw new ObjectDefinitionSystemException("Only allowed bundles can delete system object definitions");
        }
        this._objectActionLocalService.deleteObjectActions(objectDefinition.getObjectDefinitionId());
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            this._deleteObjectDefinitionPLOEntries(objectDefinition);
            DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery(){

                protected void intervalCompleted(long startPrimaryKey, long endPrimaryKey) throws PortalException {
                    Session portletSession = ObjectDefinitionLocalServiceImpl.this._objectEntryPersistence.openSession();
                    portletSession.flush();
                    portletSession.clear();
                    Session portalSession = ObjectDefinitionLocalServiceImpl.this._resourcePermissionPersistence.openSession();
                    portalSession.flush();
                    portalSession.clear();
                }
            };
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property nameProperty = PropertyFactoryUtil.forName((String)"objectDefinitionId");
                dynamicQuery.add(nameProperty.eq((Object)objectDefinition.getObjectDefinitionId()));
            });
            actionableDynamicQuery.setBaseLocalService((BaseLocalService)this._objectEntryLocalService);
            actionableDynamicQuery.setClassLoader(this.getClassLoader());
            actionableDynamicQuery.setModelClass(ObjectEntry.class);
            AtomicBoolean deletedMarker = new AtomicBoolean();
            actionableDynamicQuery.setPerformActionMethod(objectEntry -> {
                deletedMarker.set(true);
                this._objectEntryLocalService.deleteObjectEntry(objectEntry);
            });
            actionableDynamicQuery.setPrimaryKeyPropertyName("objectEntryId");
            try (SafeCloseable safeCloseable2 = ObjectDefinitionThreadLocal.setDeleteObjectDefinitionIdWithSafeCloseable((long)objectDefinition.getObjectDefinitionId());){
                actionableDynamicQuery.performActions();
                if (deletedMarker.get()) {
                    this._resourcePermissionLocalService.deleteResourcePermissions(objectDefinition.getCompanyId(), objectDefinition.getClassName(), 4);
                    this._assetEntryLocalService.deleteEntries(objectDefinition.getCompanyId(), objectDefinition.getClassName());
                    this._deleteFromTable(objectDefinition.getDBTableName());
                    this._deleteFromTable(objectDefinition.getExtensionDBTableName());
                    if (objectDefinition.isEnableLocalization()) {
                        this._deleteFromTable(objectDefinition.getLocalizationDBTableName());
                    }
                }
            }
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByODI1_R(objectDefinition.getObjectDefinitionId(), false)) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByODI2_R(objectDefinition.getObjectDefinitionId(), false)) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        this._objectFieldLocalService.deleteObjectFieldByObjectDefinitionId(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectFolderItemLocalService.deleteObjectFolderItemByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        this._objectLayoutLocalService.deleteObjectLayouts(objectDefinition.getObjectDefinitionId());
        this._objectValidationRuleLocalService.deleteObjectValidationRules(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectViewLocalService.deleteObjectViews(objectDefinition.getObjectDefinitionId());
        this._resourceLocalService.deleteResource(objectDefinition.getCompanyId(), ObjectDefinition.class.getName(), 4, objectDefinition.getObjectDefinitionId());
        if (objectDefinition.isUnmodifiableSystemObject()) {
            this._dropTable(objectDefinition.getExtensionDBTableName());
        } else if (objectDefinition.isApproved()) {
            try {
                SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)objectDefinition.getCompanyId());
                Object object = null;
                try {
                    ObjectDefinitionResourcePermissionUtil.removeResourceActions(this._objectActionLocalService, objectDefinition, this.objectDefinitionPersistence, new ObjectDefinitionTreeFactory(this.objectDefinitionLocalService, this._objectRelationshipLocalService), this._resourceActions);
                }
                catch (Throwable safeCloseable2) {
                    object = safeCloseable2;
                    throw safeCloseable2;
                }
                finally {
                    if (safeCloseable != null) {
                        if (object != null) {
                            try {
                                safeCloseable.close();
                            }
                            catch (Throwable safeCloseable2) {
                                ((Throwable)object).addSuppressed(safeCloseable2);
                            }
                        } else {
                            safeCloseable.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new PortalException((Throwable)exception);
            }
            this._dropTable(objectDefinition.getDBTableName());
            this._dropTable(objectDefinition.getExtensionDBTableName());
            if (objectDefinition.isEnableLocalization()) {
                this._dropTable(objectDefinition.getLocalizationDBTableName());
            }
            this.undeployObjectDefinition(objectDefinition);
            this._registerTransactionCallbackForCluster(_undeployObjectDefinitionMethodKey, objectDefinition);
        }
        this.objectDefinitionPersistence.remove((BaseModel)objectDefinition);
        Set names = (Set)MassDeleteCacheThreadLocal.getMassDeleteCache((String)ResourcePermissionLocalService.class.getName(), HashSet::new);
        if (names != null) {
            for (String name : names) {
                this._resourcePermissionLocalService.deleteResourcePermissions(name);
            }
        }
        return objectDefinition;
    }

    public void deployInactiveObjectDefinition(ObjectDefinition objectDefinition) {
        this.undeployObjectDefinition(objectDefinition);
        for (Map.Entry<InactiveObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._inactiveObjectDefinitionsServiceRegistrationsMaps.entrySet()) {
            InactiveObjectDefinitionDeployer inactiveObjectDefinitionDeployer = entry.getKey();
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)objectDefinition.getCompanyId());
            Throwable throwable = null;
            try {
                serviceRegistrationsMap.computeIfAbsent(objectDefinition.getObjectDefinitionId(), objectDefinitionId -> inactiveObjectDefinitionDeployer.deploy(objectDefinition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
    }

    public void deployObjectDefinition(ObjectDefinition objectDefinition) {
        this.undeployObjectDefinition(objectDefinition);
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)objectDefinition.getCompanyId());
            Throwable throwable = null;
            try {
                serviceRegistrationsMap.computeIfAbsent(objectDefinition.getObjectDefinitionId(), objectDefinitionId -> objectDefinitionDeployer.deploy(objectDefinition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
    }

    public ObjectDefinition enableAccountEntryRestricted(ObjectRelationship objectRelationship) throws PortalException {
        ObjectDefinition objectDefinition1 = this.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (!Objects.equals(objectDefinition1.getShortName(), "AccountEntry")) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Custom object definitions can only be restricted by account entry");
        }
        ObjectDefinition objectDefinition2 = this.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (objectDefinition2.isAccountEntryRestricted()) {
            return objectDefinition2;
        }
        objectDefinition2.setAccountEntryRestrictedObjectFieldId(objectRelationship.getObjectFieldId2());
        objectDefinition2.setAccountEntryRestricted(true);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition2);
    }

    public ObjectDefinition enableAccountEntryRestrictedForNondefaultStorageType(ObjectField objectField) throws PortalException {
        if (!(objectField.compareBusinessType("Integer") || objectField.compareBusinessType("LongInteger") || objectField.compareBusinessType("Text"))) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Custom object definitions can only be restricted by an integer, long integer, or text field");
        }
        ObjectDefinition objectDefinition = this.getObjectDefinition(objectField.getObjectDefinitionId());
        if (objectDefinition.isDefaultStorageType()) {
            throw new UnsupportedOperationException();
        }
        objectDefinition.setAccountEntryRestrictedObjectFieldId(objectField.getObjectFieldId());
        objectDefinition.setAccountEntryRestricted(true);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    public ObjectDefinition fetchObjectDefinition(long companyId, String name) {
        return this.objectDefinitionPersistence.fetchByC_N(companyId, name);
    }

    public ObjectDefinition fetchObjectDefinitionByClassName(long companyId, String className) {
        return this.objectDefinitionPersistence.fetchByC_C(companyId, className);
    }

    public ObjectDefinition fetchSystemObjectDefinition(String name) {
        for (ObjectDefinition systemObjectDefinition : this.getSystemObjectDefinitions()) {
            if (!Objects.equals(systemObjectDefinition.getName(), name)) continue;
            return systemObjectDefinition;
        }
        return null;
    }

    public List<ObjectDefinition> getBoundObjectDefinitions(long companyId, long rootObjectDefinitionId) {
        return this.objectDefinitionPersistence.findByC_RODI(companyId, rootObjectDefinitionId);
    }

    public List<ObjectDefinition> getCustomObjectDefinitions(int status) {
        return this.objectDefinitionPersistence.findByS_S(false, status);
    }

    @Override
    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
    }

    public ObjectDefinition getObjectDefinition(long companyId, String name) throws PortalException {
        return this.objectDefinitionPersistence.findByC_N(companyId, name);
    }

    public List<ObjectDefinition> getObjectDefinitions(boolean accountEntryRestricted) {
        return this.objectDefinitionPersistence.findByAccountEntryRestricted(accountEntryRestricted);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, boolean system, int status) {
        return this.objectDefinitionPersistence.findByC_A_S_S(companyId, active, system, status);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, int status) {
        return this.objectDefinitionPersistence.findByC_A_S(companyId, active, status);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, int status) {
        return this.objectDefinitionPersistence.findByC_S(companyId, status);
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this.objectDefinitionPersistence.countByCompanyId(companyId);
    }

    public List<ObjectDefinition> getObjectFolderObjectDefinitions(long objectFolderId) {
        return this.objectDefinitionPersistence.findByObjectFolderId(objectFolderId);
    }

    public int getObjectFolderObjectDefinitionsCount(long objectFolderId) throws PortalException {
        return this.objectDefinitionPersistence.countByObjectFolderId(objectFolderId);
    }

    public List<ObjectDefinition> getSystemObjectDefinitions() {
        return this.objectDefinitionPersistence.findBySystem(true);
    }

    public List<ObjectDefinition> getUnmodifiableSystemObjectDefinitions(long companyId) {
        return this.objectDefinitionPersistence.findByC_M_S(companyId, false, true);
    }

    public boolean hasObjectRelationship(long objectDefinitionId) {
        int countByObjectDefinitionId1 = this._objectRelationshipPersistence.countByObjectDefinitionId1(objectDefinitionId);
        int countByObjectDefinitionId2 = this._objectRelationshipPersistence.countByObjectDefinitionId2(objectDefinitionId);
        return countByObjectDefinitionId1 > 0 || countByObjectDefinitionId2 > 0;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition publishCustomObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            throw new ObjectDefinitionStatusException("Unmodifiable system object definition cannot be published");
        }
        return this._publishObjectDefinition(userId, objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition publishSystemObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this._publishObjectDefinition(userId, objectDefinition);
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        ConcurrentHashMap activeServiceRegistrationsMap = new ConcurrentHashMap();
        InactiveObjectDefinitionDeployerImpl inactiveObjectDefinitionDeployer = new InactiveObjectDefinitionDeployerImpl(this._bundleContext, this._objectEntryService, this._objectFieldLocalService, this._objectRelatedModelsProviderRegistrarHelper, this._objectRelationshipLocalService);
        ConcurrentHashMap inactiveServiceRegistrationsMap = new ConcurrentHashMap();
        ObjectDefinitionDeployerImpl objectDefinitionDeployer = new ObjectDefinitionDeployerImpl(this._accountEntryLocalService, this._accountEntryOrganizationRelLocalService, this._assetEntryLocalService, this._bundleContext, this._dynamicQueryBatchIndexingActionableFactory, this._groupLocalService, this._listTypeLocalService, this._objectActionLocalService, this.objectDefinitionLocalService, this._objectEntryLocalService, this._objectEntryService, this._objectFieldLocalService, this._objectLayoutLocalService, this._objectLayoutTabLocalService, this._objectRelatedModelsProviderRegistrarHelper, this._objectRelationshipLocalService, this._objectScopeProviderRegistry, this._objectViewLocalService, this._organizationLocalService, this._ploEntryLocalService, this._portal, this._portletLocalService, this._resourceActions, this._userLocalService, this._resourcePermissionLocalService, this._searchLocalizationHelper, this._workflowStatusModelPreFilterContributor, this._userGroupRoleLocalService);
        this._companyLocalService.forEachCompanyId(companyId -> {
            for (ObjectDefinition objectDefinition : this.objectDefinitionLocalService.getObjectDefinitions(companyId.longValue(), 0)) {
                if (objectDefinition.isActive()) {
                    activeServiceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), objectDefinitionDeployer.deploy(objectDefinition));
                    continue;
                }
                inactiveServiceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), inactiveObjectDefinitionDeployer.deploy(objectDefinition));
            }
        });
        this._inactiveObjectDefinitionsServiceRegistrationsMaps.put(inactiveObjectDefinitionDeployer, inactiveServiceRegistrationsMap);
        this._serviceRegistrationsMaps.put(objectDefinitionDeployer, activeServiceRegistrationsMap);
        this._objectDefinitionDeployerServiceTracker = new ServiceTracker(this._bundleContext, ObjectDefinitionDeployer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ObjectDefinitionDeployer, ObjectDefinitionDeployer>(){

            public ObjectDefinitionDeployer addingService(ServiceReference<ObjectDefinitionDeployer> serviceReference) {
                return ObjectDefinitionLocalServiceImpl.this._addingObjectDefinitionDeployer((ObjectDefinitionDeployer)ObjectDefinitionLocalServiceImpl.this._bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
            }

            public void removedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
                ObjectDefinitionLocalServiceImpl.this._companyLocalService.forEachCompanyId(companyId -> {
                    for (ObjectDefinition objectDefinition : ObjectDefinitionLocalServiceImpl.this.objectDefinitionLocalService.getObjectDefinitions(companyId.longValue(), 0)) {
                        if (!objectDefinition.isActive()) continue;
                        objectDefinitionDeployer.undeploy(objectDefinition);
                    }
                });
                Map serviceRegistrationsMap = (Map)ObjectDefinitionLocalServiceImpl.this._serviceRegistrationsMaps.remove(objectDefinitionDeployer);
                for (List serviceRegistrations : serviceRegistrationsMap.values()) {
                    for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                        serviceRegistration.unregister();
                    }
                }
                ObjectDefinitionLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            }
        });
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            this._objectDefinitionDeployerServiceTracker.open();
            return null;
        });
    }

    public void undeployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            return;
        }
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            objectDefinitionDeployer.undeploy(objectDefinition);
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            List<ServiceRegistration<?>> serviceRegistrations = serviceRegistrationsMap.remove(objectDefinition.getObjectDefinitionId());
            if (serviceRegistrations == null) continue;
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
        this._invalidatePortalCache(objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateCustomObjectDefinition(String externalReferenceCode, long objectDefinitionId, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long objectFolderId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, String className, boolean enableCategorization, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, boolean enableObjectEntryHistory, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, Map<Locale, String> pluralLabelMap, String scope, int status) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            throw new ObjectDefinitionStatusException("Object definition " + objectDefinition);
        }
        if (objectDefinition.isRootDescendantNode()) {
            String errorMessage = "cannot be changed when the object definition is a root descendant node";
            if (!Objects.equals(objectDefinition.getAccountEntryRestrictedObjectFieldId(), accountEntryRestrictedObjectFieldId)) {
                throw new ObjectDefinitionAccountEntryRestrictedObjectFieldIdException("Account entry restriction object field ID " + errorMessage);
            }
            if (!Objects.equals(objectDefinition.isAccountEntryRestricted(), accountEntryRestricted)) {
                throw new ObjectDefinitionAccountEntryRestrictedException("Account entry restriction " + errorMessage);
            }
            if (!Objects.equals(objectDefinition.getPanelCategoryKey(), GetterUtil.getString((String)panelCategoryKey))) {
                throw new ObjectDefinitionPanelCategoryKeyException("Panel category key " + errorMessage);
            }
            if (!Objects.equals(objectDefinition.isPortlet(), portlet)) {
                throw new ObjectDefinitionPortletException("Portlet " + errorMessage);
            }
            if (!Objects.equals(objectDefinition.getScope(), scope)) {
                throw new ObjectDefinitionScopeException("Scope " + errorMessage);
            }
        }
        return this._updateObjectDefinition(externalReferenceCode, objectDefinition, accountEntryRestrictedObjectFieldId, descriptionObjectFieldId, objectFolderId, titleObjectFieldId, accountEntryRestricted, active, className, null, enableCategorization, enableComments, enableIndexSearch, enableLocalization, enableObjectEntryDraft, enableObjectEntryHistory, labelMap, name, panelAppOrder, panelCategoryKey, portlet, null, null, pluralLabelMap, scope, status);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateExternalReferenceCode(long objectDefinitionId, String externalReferenceCode) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateExternalReferenceCode(externalReferenceCode, objectDefinition.isSystem());
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateObjectFolderId(long objectDefinitionId, long objectFolderId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        long oldObjectFolderId = objectDefinition.getObjectFolderId();
        objectDefinition.setObjectFolderId(this._getObjectFolderId(objectDefinition.getCompanyId(), objectFolderId));
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._objectFolderItemLocalService.updateObjectFolderObjectFolderItem(objectDefinitionId, objectDefinition.getObjectFolderId(), oldObjectFolderId);
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updatePortlet(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isPortlet() && objectDefinition.isRootDescendantNode()) {
            objectDefinition.setPortlet(false);
            return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateRootObjectDefinitionId(long objectDefinitionId, long rootObjectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (rootObjectDefinitionId == 0L) {
            objectDefinition.setRootObjectDefinitionId(0L);
            return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        ObjectDefinition rootObjectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(rootObjectDefinitionId);
        if (!rootObjectDefinition.isRootNode() && objectDefinitionId != rootObjectDefinitionId) {
            throw new ObjectDefinitionRootObjectDefinitionIdException("Object definition " + rootObjectDefinitionId + " is not a root object definition");
        }
        objectDefinition.setRootObjectDefinitionId(rootObjectDefinitionId);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateSystemObjectDefinition(String externalReferenceCode, long objectDefinitionId, long objectFolderId, long titleObjectFieldId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        this._validateExternalReferenceCode(externalReferenceCode, objectDefinition.isSystem());
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        long oldObjectFolderId = objectDefinition.getObjectFolderId();
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        objectDefinition.setObjectFolderId(this._getObjectFolderId(objectDefinition.getCompanyId(), objectFolderId));
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._objectFolderItemLocalService.updateObjectFolderObjectFolderItem(objectDefinitionId, objectDefinition.getObjectFolderId(), oldObjectFolderId);
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateTitleObjectFieldId(long objectDefinitionId, long titleObjectFieldId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    public void updateUserId(long companyId, long oldUserId, long newUserId) throws PortalException {
        for (ObjectDefinition objectDefinition : this.objectDefinitionPersistence.findByC_U(companyId, oldUserId)) {
            objectDefinition.setUserId(newUserId);
            this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        if (this._objectDefinitionDeployerServiceTracker != null) {
            this._objectDefinitionDeployerServiceTracker.close();
        }
    }

    @Override
    protected void runSQL(String sql) {
        ObjectDBManagerUtil.runSQL(this.objectDefinitionPersistence.getDataSource(), _log, sql);
    }

    private ObjectDefinitionDeployer _addingObjectDefinitionDeployer(ObjectDefinitionDeployer objectDefinitionDeployer) {
        ConcurrentHashMap serviceRegistrationsMap = new ConcurrentHashMap();
        this._companyLocalService.forEachCompanyId(companyId -> {
            for (ObjectDefinition objectDefinition : this.objectDefinitionLocalService.getObjectDefinitions(companyId.longValue(), 0)) {
                if (!objectDefinition.isActive()) continue;
                serviceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), objectDefinitionDeployer.deploy(objectDefinition));
            }
        });
        this._serviceRegistrationsMaps.put(objectDefinitionDeployer, serviceRegistrationsMap);
        return objectDefinitionDeployer;
    }

    private ObjectDefinition _addObjectDefinition(String externalReferenceCode, long userId, long objectFolderId, String className, String dbTableName, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, Map<Locale, String> labelMap, boolean modifiable, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, boolean portlet, String scope, String storageType, boolean system, String titleObjectFieldName, int version, int status, List<ObjectField> objectFields) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        name = this._getName(name, system);
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, modifiable, name, system, user.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, modifiable, system, shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, modifiable, system);
        storageType = Validator.isNotNull((String)storageType) ? storageType : "default";
        this._validateExternalReferenceCode(externalReferenceCode, system);
        this._validateClassName(0L, user.getCompanyId(), className, modifiable, system);
        this._validateEnableComments(enableComments, modifiable, storageType, system);
        this._validateLabel(labelMap);
        this._validateName(0L, user.getCompanyId(), modifiable, name, system);
        this._validatePluralLabel(pluralLabelMap);
        this._validateScope(scope, storageType);
        this._validateVersion(system, version);
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setObjectFolderId(this._getObjectFolderId(user.getCompanyId(), objectFolderId));
        objectDefinition.setActive(this._isUnmodifiableSystemObject(modifiable, system));
        objectDefinition.setClassName(this._getClassName(user.getCompanyId(), className, modifiable, system));
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setEnableCategorization(!objectDefinition.isUnmodifiableSystemObject() && StringUtil.equals((String)storageType, (String)"default"));
        objectDefinition.setEnableComments(enableComments);
        objectDefinition.setEnableIndexSearch(enableIndexSearch);
        objectDefinition.setEnableLocalization(enableLocalization);
        objectDefinition.setEnableObjectEntryDraft(enableObjectEntryDraft);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setModifiable(modifiable);
        objectDefinition.setName(name);
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        objectDefinition.setPortlet(portlet);
        objectDefinition.setScope(scope);
        objectDefinition.setStorageType(Validator.isNotNull((String)storageType) ? storageType : "default");
        objectDefinition.setSystem(system);
        objectDefinition.setVersion(version);
        objectDefinition.setStatus(status);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        if (objectDefinition.isModifiable() || !objectDefinition.isUnmodifiableSystemObject()) {
            this._addOrUpdateObjectDefinitionPLOEntries(objectDefinition);
            dbTableName = "ObjectEntry";
        }
        this._addSystemObjectFields(dbTableName, objectDefinition, pkObjectFieldName, userId);
        if (objectFields != null) {
            for (ObjectField objectField : objectFields) {
                if (objectDefinition.isUnmodifiableSystemObject() || objectField.isSystem()) {
                    this._objectFieldLocalService.addOrUpdateSystemObjectField(objectField.getExternalReferenceCode(), userId, objectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBColumnName(), objectDefinition.getDBTableName(), objectField.getDBType(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.isLocalized(), objectField.getName(), objectField.getReadOnly(), objectField.getReadOnlyConditionExpression(), objectField.isRequired(), objectField.isState(), objectField.getObjectFieldSettings());
                    continue;
                }
                this._objectFieldLocalService.addCustomObjectField(objectField.getExternalReferenceCode(), userId, objectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBType(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.isLocalized(), objectField.getName(), objectField.getReadOnly(), objectField.getReadOnlyConditionExpression(), objectField.isRequired(), objectField.isState(), objectField.getObjectFieldSettings());
            }
        }
        this._objectFolderItemLocalService.addObjectFolderItem(userId, objectDefinition.getObjectDefinitionId(), objectDefinition.getObjectFolderId(), 0, 0);
        objectDefinition = this._updateTitleObjectFieldId(objectDefinition, titleObjectFieldName);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            this._createTable(DynamicObjectDefinitionTableFactory.createExtension((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService));
        }
        return objectDefinition;
    }

    private void _addOrUpdateObjectActions(long userId, long objectDefinitionId, List<ObjectAction> objectActions) throws PortalException {
        for (ObjectAction objectAction : objectActions) {
            this._objectActionLocalService.addOrUpdateObjectAction(objectAction.getExternalReferenceCode(), 0L, userId, objectDefinitionId, objectAction.isActive(), objectAction.getConditionExpression(), objectAction.getDescription(), objectAction.getErrorMessageMap(), objectAction.getLabelMap(), objectAction.getName(), objectAction.getObjectActionExecutorKey(), objectAction.getObjectActionTriggerKey(), objectAction.getParametersUnicodeProperties(), objectAction.isSystem());
        }
    }

    private void _addOrUpdateObjectDefinitionPLOEntries(ObjectDefinition objectDefinition) throws PortalException {
        for (Locale locale : this._language.getAvailableLocales()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            this._ploEntryLocalService.addOrUpdatePLOEntry(objectDefinition.getCompanyId(), objectDefinition.getUserId(), "model.resource." + objectDefinition.getClassName(), languageId, objectDefinition.getLabel(locale));
            this._ploEntryLocalService.addOrUpdatePLOEntry(objectDefinition.getCompanyId(), objectDefinition.getUserId(), "model.resource." + objectDefinition.getResourceName(), languageId, objectDefinition.getPluralLabel(locale));
        }
    }

    private void _addSystemObjectFields(String dbTableName, ObjectDefinition objectDefinition, String pkObjectFieldName, long userId) throws PortalException {
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.userName.getName(), dbTableName, "String", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "author")), false, "creator", "false", null, false, false, null);
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.createDate.getName(), dbTableName, "Date", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "create-date")), false, "createDate", "false", null, false, false, null);
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.externalReferenceCode.getName(), dbTableName, "String", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "external-reference-code")), false, "externalReferenceCode", "false", null, false, false, null);
        String dbColumnName = ObjectEntryTable.INSTANCE.objectEntryId.getName();
        if (objectDefinition.isUnmodifiableSystemObject()) {
            dbColumnName = pkObjectFieldName;
        }
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "LongInteger", dbColumnName, dbTableName, "Long", true, true, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "id")), false, "id", "false", null, false, false, null);
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.modifiedDate.getName(), dbTableName, "Date", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "modified-date")), false, "modifiedDate", "false", null, false, false, null);
        this._objectFieldLocalService.addSystemObjectField(null, userId, 0L, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.status.getName(), dbTableName, "Integer", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "status")), false, "status", "false", null, false, false, null);
    }

    private void _createLocalizationTable(DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizedTable) {
        if (dynamicObjectDefinitionLocalizedTable == null) {
            return;
        }
        this.runSQL(dynamicObjectDefinitionLocalizedTable.getCreateTableSQL());
    }

    private void _createTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        this.runSQL(dynamicObjectDefinitionTable.getCreateTableSQL());
        for (ObjectField objectField : dynamicObjectDefinitionTable.getObjectFields()) {
            if (!StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) continue;
            ObjectDBManagerUtil.createIndexMetadata(this._currentConnection.getConnection(this.objectDefinitionPersistence.getDataSource()), dynamicObjectDefinitionTable.getTableName(), false, objectField.getDBColumnName());
        }
    }

    private void _deleteFromTable(String dbTableName) throws PortalException {
        Session session = this.objectDefinitionPersistence.openSession();
        try {
            session.apply(connection -> {
                try (PreparedStatement preparedStatement = connection.prepareStatement("delete from " + dbTableName);){
                    preparedStatement.executeUpdate();
                }
            });
        }
        finally {
            this.objectDefinitionPersistence.closeSession(session);
        }
        FinderCacheUtil.clearDSLQueryCache((String)dbTableName);
    }

    private void _deleteObjectDefinitionPLOEntries(ObjectDefinition objectDefinition) {
        this._ploEntryLocalService.deletePLOEntries(objectDefinition.getCompanyId(), "model.resource." + objectDefinition.getResourceName());
        this._ploEntryLocalService.deletePLOEntries(objectDefinition.getCompanyId(), "model.resource." + objectDefinition.getClassName());
    }

    private void _dropTable(String dbTableName) {
        this.runSQL("DROP_TABLE_IF_EXISTS(" + dbTableName + ")");
    }

    private String _getClassName(long companyId, String className, boolean modifiable, boolean system) {
        StringBuilder sb;
        ObjectDefinition existingObjectDefinition;
        if (Validator.isNotNull((String)className) || this._isUnmodifiableSystemObject(modifiable, system)) {
            return className;
        }
        do {
            sb = new StringBuilder();
            sb.append("com.liferay.object.model.ObjectDefinition#");
            sb.append(StringUtil.toUpperCase((String)StringUtil.randomId((int)1)));
            sb.append(RandomUtil.nextInt((int)10));
            sb.append(StringUtil.toUpperCase((String)StringUtil.randomId((int)1)));
            sb.append(RandomUtil.nextInt((int)10));
        } while ((existingObjectDefinition = this.objectDefinitionPersistence.fetchByC_C(companyId, sb.toString())) != null);
        className = sb.toString();
        return className;
    }

    private String _getDBTableName(String dbTableName, boolean modifiable, String name, boolean system, Long companyId, String shortName) {
        if (Validator.isNotNull((String)dbTableName)) {
            return dbTableName;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return name;
        }
        String prefix = "O_";
        if (modifiable && system) {
            prefix = "L_";
        }
        return StringBundler.concat((Object[])new Object[]{prefix, companyId, "_", shortName});
    }

    private String _getName(String name, boolean system) {
        name = StringUtil.trim((String)name);
        if (!system) {
            name = "C_" + name;
        }
        return name;
    }

    private long _getObjectFolderId(long companyId, long objectFolderId) throws PortalException {
        if (objectFolderId == 0L) {
            ObjectFolder objectFolder = this._objectFolderLocalService.getDefaultObjectFolder(companyId);
            return objectFolder.getObjectFolderId();
        }
        this._objectFolderPersistence.findByPrimaryKey(objectFolderId);
        return objectFolderId;
    }

    private String _getPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName, String pkObjectFieldName, boolean modifiable, boolean system) {
        if (Validator.isNotNull((String)pkObjectFieldDBColumnName)) {
            return pkObjectFieldDBColumnName;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return pkObjectFieldName;
        }
        return pkObjectFieldName + "_";
    }

    private String _getPKObjectFieldName(String pkObjectFieldName, boolean modifiable, boolean system, String shortName) {
        if (Validator.isNotNull((String)pkObjectFieldName)) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = TextFormatter.format((String)(shortName + "Id"), (int)8);
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return pkObjectFieldName;
        }
        if (modifiable && system) {
            String prefix = "L_";
            return StringUtil.toLowerCase((String)prefix) + pkObjectFieldName;
        }
        return "c_" + pkObjectFieldName;
    }

    private boolean _hasObjectField(List<ObjectField> newObjectFields, ObjectField oldObjectField) {
        for (ObjectField newObjectField : newObjectFields) {
            if (!Objects.equals(newObjectField.getName(), oldObjectField.getName())) continue;
            return true;
        }
        return false;
    }

    private void _invalidatePortalCache(ObjectDefinition objectDefinition) {
        List layoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsages(objectDefinition.getCompanyId(), this._classNameLocalService.getClassNameId(objectDefinition.getClassName()), this._portal.getClassNameId(FragmentEntryLink.class));
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            this._fragmentEntryLinkCache.removeFragmentEntryLinkCache(GetterUtil.getLong((String)layoutClassedModelUsage.getContainerKey()));
        }
    }

    private boolean _isUnmodifiableSystemObject(boolean modifiable, boolean system) {
        return !modifiable && system;
    }

    private ObjectDefinition _publishObjectDefinition(long userId, ObjectDefinition objectDefinition) throws PortalException {
        if (objectDefinition.isApproved()) {
            throw new ObjectDefinitionStatusException("The object definition is already published", "the-object-definition-is-already-published");
        }
        List objectFields = this._objectFieldPersistence.findByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        if (!objectDefinition.isEnableLocalization() && ListUtil.exists((List)objectFields, ObjectFieldModel::isLocalized)) {
            throw new ObjectDefinitionEnableLocalizationException("You cannot disable entry translation for the object definition because translation is enabled for custom fields", "you-cannot-disable-entry-translation-for-the-object-definition-because-translation-is-enabled-for-custom-fields");
        }
        if (!ListUtil.exists((List)objectFields, objectField -> !objectField.isMetadata())) {
            throw new ObjectDefinitionStatusException("At least one object field must be added when publishing the object definition", "at-least-one-object-field-must-be-added");
        }
        if (objectDefinition.getStatus() == 2 && objectDefinition.isRootNode()) {
            for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId())) {
                int objectEntriesCount = this._objectEntryLocalService.getObjectEntriesCount(objectRelationship.getObjectDefinitionId2());
                if (objectEntriesCount <= 0) continue;
                throw new ObjectRelationshipEdgeException(StringBundler.concat((String[])new String[]{"There must be no unrelated object entries when ", "both object definitions are published so that ", "the object relationship can be an edge to a root ", "context"}), StringBundler.concat((String[])new String[]{"there-must-be-no-unrelated-object-entries-when-", "both-object-definitions-are-published-so-that-", "the-object-relationship-can-be-an-edge-to-a-root", "context"}));
            }
        }
        objectDefinition.setActive(true);
        if (objectDefinition.isRootDescendantNode()) {
            objectDefinition.setPanelCategoryKey("");
        }
        objectDefinition.setStatus(0);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        objectDefinition = this._updateNodeObjectDefinition(objectDefinition);
        this._updateDescendantNodeObjectDefinitions(objectDefinition);
        this._createLocalizationTable(DynamicObjectDefinitionLocalizationTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService));
        this._createTable(DynamicObjectDefinitionTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService));
        this._createTable(DynamicObjectDefinitionTableFactory.createExtension((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)this._objectFieldLocalService));
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId(), "manyToMany")) {
            this._objectRelationshipLocalService.createManyToManyObjectRelationshipTable(userId, objectRelationship);
        }
        this.deployObjectDefinition(objectDefinition);
        this._registerTransactionCallbackForCluster(_deployObjectDefinitionMethodKey, objectDefinition);
        return objectDefinition;
    }

    private void _registerTransactionCallbackForCluster(MethodKey methodKey, ObjectDefinition objectDefinition) {
        if (ClusterExecutorUtil.isEnabled()) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(methodKey, new Object[]{objectDefinition}), (boolean)true);
                clusterRequest.setFireAndForget(true);
                ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                return null;
            });
        }
    }

    private void _updateDescendantNodeObjectDefinitions(ObjectDefinition objectDefinition1) throws PortalException {
        ObjectDefinition nodeObjectDefinition;
        List objectRelationships = this._objectRelationshipPersistence.findByODI1_E(objectDefinition1.getObjectDefinitionId(), true);
        if (objectRelationships.isEmpty()) {
            return;
        }
        this.deployObjectDefinition(objectDefinition1);
        boolean containsDraftDescendantNodeObjectDefinitions = false;
        ObjectDefinitionTreeFactory objectDefinitionTreeFactory = new ObjectDefinitionTreeFactory(this.objectDefinitionLocalService, this._objectRelationshipLocalService);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectDefinition objectDefinition2 = this.objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            if (!objectDefinition2.isApproved()) {
                containsDraftDescendantNodeObjectDefinitions = true;
                continue;
            }
            Tree tree = objectDefinitionTreeFactory.create(objectRelationship.getObjectDefinitionId2());
            for (Node node : tree) {
                nodeObjectDefinition = this.objectDefinitionLocalService.getObjectDefinition(node.getPrimaryKey());
                String previousRESTContextPath = nodeObjectDefinition.getRESTContextPath();
                nodeObjectDefinition.setRootObjectDefinitionId(objectDefinition1.getRootObjectDefinitionId());
                nodeObjectDefinition.setPortlet(false);
                nodeObjectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)nodeObjectDefinition);
                nodeObjectDefinition.setPreviousRESTContextPath(previousRESTContextPath);
                this.deployObjectDefinition(nodeObjectDefinition);
            }
        }
        if (containsDraftDescendantNodeObjectDefinitions) {
            Tree tree = objectDefinitionTreeFactory.create(false, objectDefinition1.getObjectDefinitionId());
            Node rootNode = tree.getRootNode();
            for (Node childNode : rootNode.getChildNodes()) {
                Iterator iterator = tree.iterator(childNode.getPrimaryKey());
                while (iterator.hasNext()) {
                    Node node;
                    node = (Node)iterator.next();
                    nodeObjectDefinition = this.objectDefinitionLocalService.getObjectDefinition(node.getPrimaryKey());
                    nodeObjectDefinition.setRootObjectDefinitionId(childNode.getPrimaryKey());
                    this.objectDefinitionPersistence.update((BaseModel)nodeObjectDefinition);
                }
            }
        }
    }

    private ObjectDefinition _updateNodeObjectDefinition(ObjectDefinition objectDefinition2) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByODI2_E(objectDefinition2.getObjectDefinitionId(), true);
        if (objectRelationship == null) {
            return objectDefinition2;
        }
        ObjectDefinition objectDefinition1 = this.objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        String previousRESTContextPath = objectDefinition2.getRESTContextPath();
        if (objectDefinition1.isApproved()) {
            objectDefinition2.setRootObjectDefinitionId(objectDefinition1.getRootObjectDefinitionId());
        } else {
            objectDefinition2.setRootObjectDefinitionId(objectDefinition2.getObjectDefinitionId());
        }
        objectDefinition2 = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition2);
        objectDefinition2.setPreviousRESTContextPath(previousRESTContextPath);
        return objectDefinition2;
    }

    private ObjectDefinition _updateObjectDefinition(String externalReferenceCode, ObjectDefinition objectDefinition, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long objectFolderId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, String className, String dbTableName, boolean enableCategorization, boolean enableComments, boolean enableIndexSearch, boolean enableLocalization, boolean enableObjectEntryDraft, boolean enableObjectEntryHistory, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, int status) throws PortalException {
        long oldObjectFolderId = objectDefinition.getObjectFolderId();
        boolean oldActive = objectDefinition.isActive();
        String oldClassName = objectDefinition.getClassName();
        this._validateExternalReferenceCode(externalReferenceCode, objectDefinition.isSystem());
        this._validateAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId, accountEntryRestricted, objectDefinition);
        this._validateObjectFieldId(objectDefinition, descriptionObjectFieldId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        this._validateActive(active, status);
        if (Validator.isNull((String)oldClassName)) {
            this._validateClassName(objectDefinition.getObjectDefinitionId(), objectDefinition.getCompanyId(), className, objectDefinition.isModifiable(), objectDefinition.isSystem());
        }
        this._validateEnableCategorization(enableCategorization, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateEnableComments(enableComments, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateEnableObjectEntryHistory(objectDefinition.isEnableObjectEntryHistory() != enableObjectEntryHistory, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateLabel(labelMap);
        this._validatePluralLabel(pluralLabelMap);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() != 0L) {
            this._objectFieldLocalService.updateRequired(objectDefinition.getAccountEntryRestrictedObjectFieldId(), false);
        }
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId > 0L) {
            this._objectFieldLocalService.updateRequired(accountEntryRestrictedObjectFieldId, true);
        }
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        objectDefinition.setAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId);
        objectDefinition.setDescriptionObjectFieldId(descriptionObjectFieldId);
        objectDefinition.setObjectFolderId(this._getObjectFolderId(objectDefinition.getCompanyId(), objectFolderId));
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        objectDefinition.setAccountEntryRestricted(accountEntryRestricted);
        objectDefinition.setActive(active);
        if (Validator.isNull((String)oldClassName)) {
            objectDefinition.setClassName(this._getClassName(objectDefinition.getCompanyId(), className, objectDefinition.isModifiable(), objectDefinition.isSystem()));
        }
        objectDefinition.setEnableCategorization(enableCategorization);
        objectDefinition.setEnableComments(enableComments);
        objectDefinition.setEnableObjectEntryDraft(enableObjectEntryDraft);
        objectDefinition.setEnableObjectEntryHistory(enableObjectEntryHistory);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        objectDefinition.setPortlet(portlet);
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            this._addOrUpdateObjectDefinitionPLOEntries(objectDefinition);
        }
        if (objectDefinition.isApproved()) {
            if (!active && oldActive) {
                this.objectDefinitionLocalService.deployInactiveObjectDefinition(objectDefinition);
            } else if (active) {
                this.objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
            }
            if (active != oldActive) {
                this._updateWorkflowInstances(objectDefinition);
            }
            objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
            this._objectFolderItemLocalService.updateObjectFolderObjectFolderItem(objectDefinition.getObjectDefinitionId(), objectDefinition.getObjectFolderId(), oldObjectFolderId);
            return objectDefinition;
        }
        name = this._getName(name, objectDefinition.isSystem());
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, objectDefinition.isModifiable(), name, objectDefinition.isSystem(), objectDefinition.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, objectDefinition.isModifiable(), objectDefinition.isSystem(), shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, objectDefinition.isModifiable(), objectDefinition.isSystem());
        this._validateName(objectDefinition.getObjectDefinitionId(), objectDefinition.getCompanyId(), objectDefinition.isModifiable(), name, objectDefinition.isSystem());
        this._validateScope(scope, objectDefinition.getStorageType());
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setEnableIndexSearch(enableIndexSearch);
        objectDefinition.setEnableLocalization(enableLocalization);
        objectDefinition.setName(name);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setScope(scope);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), "")) {
            objectField.setDBTableName(objectDefinition.getDBTableName());
            this._objectFieldLocalService.updateObjectField(objectField);
        }
        this._objectFolderItemLocalService.updateObjectFolderObjectFolderItem(objectDefinition.getObjectDefinitionId(), objectDefinition.getObjectFolderId(), oldObjectFolderId);
        return objectDefinition;
    }

    private ObjectDefinition _updateTitleObjectFieldId(ObjectDefinition objectDefinition, String titleObjectFieldName) throws PortalException {
        if (Validator.isNull((String)titleObjectFieldName)) {
            titleObjectFieldName = "id";
        }
        ObjectField objectField = this._objectFieldPersistence.findByODI_N(objectDefinition.getObjectDefinitionId(), titleObjectFieldName);
        this._validateObjectFieldId(objectDefinition, objectField.getObjectFieldId());
        objectDefinition.setTitleObjectFieldId(objectField.getObjectFieldId());
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    private void _updateWorkflowInstances(ObjectDefinition objectDefinition) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property objectDefinitionIdProperty = PropertyFactoryUtil.forName((String)"objectDefinitionId");
            dynamicQuery.add(objectDefinitionIdProperty.eq((Object)objectDefinition.getObjectDefinitionId()));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.ne((Object)0));
        });
        actionableDynamicQuery.setParallel(true);
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> {
            WorkflowInstanceLink workflowInstanceLink = this._workflowInstanceLinkLocalService.fetchWorkflowInstanceLink(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
            if (workflowInstanceLink != null) {
                this._workflowInstanceManager.updateActive(objectDefinition.getUserId(), objectDefinition.getCompanyId(), workflowInstanceLink.getWorkflowInstanceId(), objectDefinition.isActive());
            }
        });
        actionableDynamicQuery.performActions();
    }

    private void _validateAccountEntryRestrictedObjectFieldId(long accountEntryRestrictedObjectFieldId, boolean accountEntryRestricted, ObjectDefinition objectDefinition) throws ObjectDefinitionAccountEntryRestrictedException, ObjectDefinitionAccountEntryRestrictedObjectFieldIdException {
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId == 0L) {
            throw new ObjectDefinitionAccountEntryRestrictedObjectFieldIdException();
        }
        if (objectDefinition.isApproved() && objectDefinition.isAccountEntryRestricted() && !accountEntryRestricted) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Account entry restriction cannot be disabled when the object definition is published");
        }
    }

    private void _validateActive(boolean active, int status) throws PortalException {
        if (active && !Objects.equals(0, status)) {
            throw new ObjectDefinitionActiveException("Object definitions must be published before being activated");
        }
    }

    private void _validateClassName(long objectDefinitionId, long companyId, String className, boolean modifiable, boolean system) throws PortalException {
        if (Validator.isNull((String)className) || this._isUnmodifiableSystemObject(modifiable, system)) {
            return;
        }
        ObjectDefinition existingObjectDefinition = this.objectDefinitionPersistence.fetchByC_C(companyId, className);
        if (existingObjectDefinition != null && existingObjectDefinition.getObjectDefinitionId() != objectDefinitionId) {
            throw new ObjectDefinitionClassNameException.MustNotBeDuplicate(className);
        }
        if (!StringUtil.startsWith((String)className, (String)"com.liferay.object.model.ObjectDefinition#")) {
            throw new ObjectDefinitionClassNameException.MustStartWithPrefix();
        }
    }

    private void _validateEnableCategorization(boolean enableCategorization, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (enableCategorization && this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableCategorizationException("Enable categorization is not allowed for system object definitions");
        }
        if (enableCategorization && !StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableCategorizationException("Enable categorization is only allowed for object definitions with the default storage type");
        }
    }

    private void _validateEnableComments(boolean enableComments, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (enableComments && this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableCommentsException("Enable comments is not allowed for system object definitions");
        }
        if (enableComments && !StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableCategorizationException("Enable comments is only allowed for object definitions with the default storage type");
        }
    }

    private void _validateEnableObjectEntryHistory(boolean enableObjectEntryHistoryChanged, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (!enableObjectEntryHistoryChanged) {
            return;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableObjectEntryHistoryException("Enable object entry history is not allowed for system object definitions");
        }
        if (!StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableObjectEntryHistoryException("Enable object entry history is only allowed for object definitions with the default storage type");
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, boolean system) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        char[] externalReferenceCodeCharArray = externalReferenceCode.toCharArray();
        if (externalReferenceCodeCharArray.length > 75) {
            throw new ObjectDefinitionExternalReferenceCodeException.MustBeLessThan75Characters();
        }
        if (!system && externalReferenceCode.startsWith("L_")) {
            throw new ObjectDefinitionExternalReferenceCodeException.MustNotStartWithPrefix();
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectDefinitionLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectDefinitionId, long companyId, boolean modifiable, String name, boolean system) throws PortalException {
        if (modifiable && system && !ObjectDefinitionUtil.isAllowedModifiableSystemObjectDefinitionName((String)name)) {
            throw new ObjectDefinitionNameException.ForbiddenModifiableSystemObjectDefinitionName(name);
        }
        if (Validator.isNull((String)name) || !system && name.equals("C_")) {
            throw new ObjectDefinitionNameException.MustNotBeNull();
        }
        if (this._isUnmodifiableSystemObject(modifiable, system) && (name.startsWith("C_") || name.startsWith("c_"))) {
            throw new ObjectDefinitionNameException.MustNotStartWithCAndUnderscoreForSystemObject();
        }
        if (!system && !name.startsWith("C_")) {
            throw new ObjectDefinitionNameException.MustStartWithCAndUnderscoreForCustomObject();
        }
        char[] nameCharArray = name.toCharArray();
        for (int i = 0; i < nameCharArray.length; ++i) {
            char c;
            if ((modifiable || !system) && (i == 0 || i == 1) || Validator.isChar((char)(c = nameCharArray[i])) || Validator.isDigit((char)c)) continue;
            throw new ObjectDefinitionNameException.MustOnlyContainLettersAndDigits();
        }
        if (system && !Character.isUpperCase(nameCharArray[0]) || !system && !Character.isUpperCase(nameCharArray[2])) {
            throw new ObjectDefinitionNameException.MustBeginWithUpperCaseLetter();
        }
        if (system && nameCharArray.length > 41 || !system && nameCharArray.length > 43) {
            throw new ObjectDefinitionNameException.MustBeLessThan41Characters();
        }
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, name);
        if (objectDefinition != null && objectDefinition.getObjectDefinitionId() != objectDefinitionId) {
            throw new ObjectDefinitionNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectFieldId(ObjectDefinition objectDefinition, long objectFieldId) throws PortalException {
        if (objectFieldId <= 0L) {
            return;
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldId);
        if (objectField == null || objectField.getObjectDefinitionId() != objectDefinition.getObjectDefinitionId()) {
            throw new NoSuchObjectFieldException();
        }
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Description and title object fields cannot have a relationship type");
        }
    }

    private void _validatePluralLabel(Map<Locale, String> pluralLabelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (pluralLabelMap == null || Validator.isNull((String)pluralLabelMap.get(locale))) {
            throw new ObjectDefinitionPluralLabelException("Plural label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateScope(String scope, String storageType) throws PortalException {
        if (Validator.isNull((String)scope)) {
            throw new ObjectDefinitionScopeException("Scope is null");
        }
        try {
            this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectDefinitionScopeException(illegalArgumentException.getMessage());
        }
        if (StringUtil.equals((String)scope, (String)"site") && StringUtil.equals((String)storageType, (String)"salesforce")) {
            throw new ObjectDefinitionScopeException(StringBundler.concat((String[])new String[]{"Scope \"", "site", "\" cannot be associated with storage type \"", "salesforce"}));
        }
    }

    private void _validateVersion(boolean system, int version) throws PortalException {
        if (system) {
            if (version <= 0) {
                throw new ObjectDefinitionVersionException("System object definition versions must greater than 0");
            }
        } else if (version != 0) {
            throw new ObjectDefinitionVersionException("Custom object definition versions must be 0");
        }
    }
}

