/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryModelDocumentContributor
implements ModelDocumentContributor<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelDocumentContributor.class);
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final String _className;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;

    public ObjectEntryModelDocumentContributor(AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, String className, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService) {
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._className = className;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
    }

    public void contribute(Document document, ObjectEntry objectEntry) {
        block2: {
            try {
                this._contribute(document, objectEntry);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index object entry " + objectEntry.getObjectEntryId()), (Throwable)exception);
            }
        }
    }

    private void _addField(FieldArray fieldArray, String fieldName, String valueFieldName, String value) {
        Field field = new Field("");
        field.addField(new Field("fieldName", fieldName));
        field.addField(new Field("valueFieldName", valueFieldName));
        field.addField(new Field(valueFieldName, value));
        fieldArray.addField(field);
    }

    private void _appendToContent(StringBundler sb, String objectFieldName, String valueString) {
        sb.append(objectFieldName);
        sb.append(": ");
        sb.append(valueString);
        sb.append(", ");
    }

    private void _contribute(Document document, FieldArray fieldArray, String fieldName, Object fieldValue, String locale, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectField objectField, StringBundler sb, Map<String, Serializable> values) {
        if (!objectField.isIndexed()) {
            return;
        }
        if (fieldValue == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", objectField.getName(), "\" with a null value"}));
            }
            return;
        }
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment") || StringUtil.equals((String)objectField.getBusinessType(), (String)"RichText")) {
            fieldValue = ObjectEntryValuesUtil.getValueString((ObjectField)objectField, values);
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"PrecisionDecimal")) {
            fieldValue = BigDecimalUtil.stripTrailingZeros((BigDecimal)((BigDecimal)fieldValue));
        } else if (Objects.equals(objectDefinition.getAccountEntryRestrictedObjectFieldId(), objectField.getObjectFieldId())) {
            Long accountEntryId = (Long)fieldValue;
            document.addKeyword("accountEntryRestrictedObjectFieldValue", accountEntryId);
            document.addKeyword("accountEntryRestrictedOrganizationIds", (Long[])TransformUtil.transformToArray((Collection)this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId.longValue()), AccountEntryOrganizationRelModel::getOrganizationId, Long.class));
        }
        String valueString = String.valueOf(fieldValue);
        if (objectField.isIndexedAsKeyword()) {
            this._addField(fieldArray, fieldName, "value_keyword", StringUtil.lowerCase((String)valueString));
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof BigDecimal) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof Boolean) {
            this._addField(fieldArray, fieldName, "value_boolean", valueString);
            this._addField(fieldArray, fieldName, "value_keyword", this._translate((Boolean)fieldValue));
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof Date) {
            this._addField(fieldArray, fieldName, "value_date", this._getDateString(fieldValue));
            this._appendToContent(sb, fieldName, this._getDateString(fieldValue));
        } else if (fieldValue instanceof Double) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof Integer) {
            this._addField(fieldArray, fieldName, "value_integer", valueString);
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof Long) {
            this._addField(fieldArray, fieldName, "value_long", valueString);
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof String) {
            if (Validator.isBlank((String)objectField.getIndexedLanguageId())) {
                this._addField(fieldArray, fieldName, "value_text", valueString);
            } else if (objectField.isLocalized()) {
                this._addField(fieldArray, fieldName, "value_" + locale, valueString);
            } else {
                this._addField(fieldArray, fieldName, "value_" + objectField.getIndexedLanguageId(), valueString);
            }
            this._addField(fieldArray, fieldName, "value_keyword_lowercase", this._getSortableValue(valueString));
            this._appendToContent(sb, fieldName, valueString);
        } else if (fieldValue instanceof byte[]) {
            this._addField(fieldArray, fieldName, "value_binary", Base64.encode((byte[])((byte[])fieldValue)));
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", fieldName, "\" with unsupported value ", fieldValue}));
        }
    }

    private void _contribute(Document document, ObjectEntry objectEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + document));
            _log.debug((Object)("Object entry " + objectEntry));
        }
        document.add(new Field(Field.getSortableFieldName((String)"entryClassPK"), document.get("entryClassPK")));
        FieldArray fieldArray = (FieldArray)document.getField("nestedFieldArray");
        if (fieldArray == null) {
            fieldArray = new FieldArray("nestedFieldArray");
            document.add((Field)fieldArray);
        }
        document.addKeyword("objectDefinitionId", objectEntry.getObjectDefinitionId());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
        document.addKeyword("objectDefinitionName", objectDefinition.getShortName());
        Map values = objectEntry.getValues();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectEntry.getObjectDefinitionId(), false);
        StringBundler sb = new StringBundler(objectFields.size() * 4);
        for (ObjectField objectField : objectFields) {
            if (objectField.isLocalized()) {
                Map localizedValues = (Map)values.get(objectField.getI18nObjectFieldName());
                if (MapUtil.isEmpty((Map)localizedValues)) continue;
                for (Map.Entry localeMap : localizedValues.entrySet()) {
                    this._contribute(document, fieldArray, objectField.getName(), localizedValues.get(localeMap.getKey()), LocaleUtil.fromLanguageId((String)((String)localeMap.getKey()), (boolean)true, (boolean)false).toString(), objectDefinition, objectEntry, objectField, sb, values);
                }
                continue;
            }
            this._contribute(document, fieldArray, objectField.getName(), values.get(objectField.getName()), null, objectDefinition, objectEntry, objectField, sb, values);
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        document.add(new Field("objectEntryContent", sb.toString()));
        document.add(new Field("objectEntryTitle", objectEntry.getTitleValue()));
    }

    private String _getDateString(Object value) {
        return _format.format(value);
    }

    private String _getSortableValue(String value) {
        if (value.length() > 256) {
            return value.substring(0, 256);
        }
        return value;
    }

    private String _translate(Boolean value) {
        if (value.booleanValue()) {
            return "yes";
        }
        return "no";
    }
}

