/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.entry.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Locale;

public class ObjectEntrySearchUtil {
    public static Predicate getLeftJoinLocalizationTablePredicate(DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable, DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        if (dynamicObjectDefinitionLocalizationTable == null) {
            return null;
        }
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        if (locale == null) {
            User user = GuestOrUserUtil.getGuestOrUser((long)CompanyThreadLocal.getCompanyId());
            locale = user.getLocale();
        }
        return dynamicObjectDefinitionLocalizationTable.getForeignKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn()).and((Expression)dynamicObjectDefinitionLocalizationTable.getLanguageIdColumn().eq((Object)LocaleUtil.toLanguageId((Locale)locale)));
    }

    public static Predicate getObjectFieldPredicate(Column<?, ?> column, String dbType, String search) {
        if (column == null) {
            return null;
        }
        Column<?, ?> objectColumn = column;
        if (dbType.equals("BigDecimal") || dbType.equals("Double")) {
            BigDecimal searchBigDecimal = BigDecimal.valueOf(GetterUtil.getDouble((String)search));
            if (searchBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                return objectColumn.eq((Object)searchBigDecimal);
            }
        } else {
            long searchLong;
            if (dbType.equals("Clob") || dbType.equals("String")) {
                return DSLFunctionFactoryUtil.lower(column).like(StringUtil.quote((String)StringUtil.toLowerCase((String)search), (String)"%"));
            }
            if ((dbType.equals("Integer") || dbType.equals("Long")) && (searchLong = GetterUtil.getLong((String)search)) != 0L) {
                return objectColumn.eq((Object)searchLong);
            }
        }
        return null;
    }

    public static Column<?, Long> getPrimaryKeyColumn(String pkObjectFieldDBColumnName, Table<?> table) {
        Column primaryKeyColumn = table.getColumn(pkObjectFieldDBColumnName);
        if (primaryKeyColumn == null) {
            primaryKeyColumn = ObjectEntryTable.INSTANCE.objectEntryId;
        }
        return primaryKeyColumn;
    }

    public static Predicate getRelatedModelsPredicate(ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, String search, Table<?> table) {
        if (objectDefinition == null || Validator.isNull((String)search) || table == null) {
            return null;
        }
        ObjectField titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (titleObjectField == null) {
            titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), "id");
        }
        Predicate objectFieldPredicate = ObjectEntrySearchUtil.getObjectFieldPredicate(objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), titleObjectField.getName()), titleObjectField.getDBType(), search);
        long searchLong = GetterUtil.getLong((String)search);
        if (searchLong == 0L) {
            return objectFieldPredicate;
        }
        Column<?, Long> primaryKeyColumn = ObjectEntrySearchUtil.getPrimaryKeyColumn(objectDefinition.getPKObjectFieldDBColumnName(), table);
        Predicate primaryKeyPredicate = primaryKeyColumn.eq((Object)searchLong);
        if (objectFieldPredicate == null) {
            return primaryKeyPredicate;
        }
        return objectFieldPredicate.or((Expression)primaryKeyPredicate).withParentheses();
    }

    public static Predicate getUniqueCompositeKeyObjectFieldPredicate(Column<?, Object> column, String dbType, Object value) {
        if (dbType.equals("Integer") || dbType.equals("Long")) {
            return column.eq((Object)GetterUtil.getLong((Object)value));
        }
        if (dbType.equals("String")) {
            if (value == null) {
                return column.isNull();
            }
            return column.eq((Object)String.valueOf(value));
        }
        return null;
    }
}

