/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectLayout;
import com.liferay.object.service.ObjectLayoutLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectLayout service. Represents a row in the &quot;ObjectLayout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectLayoutImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayoutImpl
 * @see ObjectLayout
 * @generated
 */
public abstract class ObjectLayoutBaseImpl
	extends ObjectLayoutModelImpl implements ObjectLayout {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object layout model instance should use the <code>ObjectLayout</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectLayoutLocalServiceUtil.addObjectLayout(this);
		}
		else {
			ObjectLayoutLocalServiceUtil.updateObjectLayout(this);
		}
	}

}