/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.entry.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;

public class ObjectEntrySearchUtil {
    public static Predicate getObjectFieldPredicate(Column<?, Object> column, String dbType, String search) {
        if (dbType.equals("BigDecimal") || dbType.equals("Double")) {
            BigDecimal searchBigDecimal = BigDecimal.valueOf(GetterUtil.getDouble((String)search));
            if (searchBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                return column.eq((Object)searchBigDecimal);
            }
        } else {
            long searchLong;
            if (dbType.equals("Clob") || dbType.equals("String")) {
                return column.like("%" + search + "%");
            }
            if ((dbType.equals("Integer") || dbType.equals("Long")) && (searchLong = GetterUtil.getLong((String)search)) != 0L) {
                return column.eq((Object)searchLong);
            }
        }
        return null;
    }

    public static Column<?, Long> getPrimaryKeyColumn(String pkObjectFieldDBColumnName, Table<?> table) {
        Column primaryKeyColumn = table.getColumn(pkObjectFieldDBColumnName);
        if (primaryKeyColumn == null) {
            primaryKeyColumn = ObjectEntryTable.INSTANCE.objectEntryId;
        }
        return primaryKeyColumn;
    }

    public static Predicate getRelatedModelsPredicate(ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, String search, Table<?> table) {
        if (objectDefinition == null || Validator.isNull((String)search) || table == null) {
            return null;
        }
        ObjectField titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (titleObjectField == null) {
            titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), "id");
        }
        Predicate objectFieldPredicate = ObjectEntrySearchUtil.getObjectFieldPredicate(objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), titleObjectField.getName()), titleObjectField.getDBType(), search);
        long searchLong = GetterUtil.getLong((String)search);
        if (searchLong == 0L) {
            return objectFieldPredicate;
        }
        Column<?, Long> primaryKeyColumn = ObjectEntrySearchUtil.getPrimaryKeyColumn(objectDefinition.getPKObjectFieldDBColumnName(), table);
        Predicate primaryKeyPredicate = primaryKeyColumn.eq((Object)searchLong);
        if (objectFieldPredicate == null) {
            return primaryKeyPredicate;
        }
        return objectFieldPredicate.or((Expression)primaryKeyPredicate).withParentheses();
    }

    public static Predicate getUniqueCompositeKeyObjectFieldPredicate(Column<?, Object> column, String dbType, Object value) {
        if (dbType.equals("Integer") || dbType.equals("Long")) {
            return column.eq((Object)GetterUtil.getLong((Object)value));
        }
        if (dbType.equals("String")) {
            if (value == null) {
                return column.isNull();
            }
            return column.eq((Object)String.valueOf(value));
        }
        return null;
    }
}

