/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.uad.display;

import com.liferay.object.internal.uad.constants.ObjectUADConstants;
import com.liferay.object.internal.uad.util.ObjectEntryUADUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class ObjectEntryUADDisplay
extends BaseModelUADDisplay<ObjectEntry> {
    private final GroupLocalService _groupLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private final Portal _portal;

    public ObjectEntryUADDisplay(GroupLocalService groupLocalService, ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry, Portal portal) {
        this._groupLocalService = groupLocalService;
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
        this._portal = portal;
    }

    public ObjectEntry get(Serializable primaryKey) throws Exception {
        return this._objectEntryLocalService.getObjectEntry(Long.valueOf(primaryKey.toString()).longValue());
    }

    public String[] getDisplayFieldNames() {
        return new String[]{"externalReferenceCode", "objectEntryId"};
    }

    public String getEditURL(ObjectEntry objectEntry, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this._groupLocalService.fetchGroup(objectEntry.getGroupId()), this._objectDefinition.getPortletId(), 0L, 0L, "RENDER_PHASE")).setMVCRenderCommandName("/object_entries/edit_object_entry").setBackURL(this._portal.getCurrentURL((PortletRequest)liferayPortletRequest)).setParameter("externalReferenceCode", objectEntry.getExternalReferenceCode()).buildString();
    }

    public Class<ObjectEntry> getTypeClass() {
        return ObjectEntry.class;
    }

    public String getTypeKey() {
        return this._objectDefinition.getClassName();
    }

    public String getTypeName(Locale locale) {
        return this._objectDefinition.getShortName();
    }

    public boolean isSiteScoped() {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        return objectScopeProvider.isGroupAware();
    }

    protected long doCount(DynamicQuery dynamicQuery) {
        return this._objectEntryLocalService.dynamicQueryCount(dynamicQuery);
    }

    protected DynamicQuery doGetDynamicQuery() {
        return ObjectEntryUADUtil.addDynamicQueryCriteria(this._objectEntryLocalService.dynamicQuery(), this._objectDefinition.getObjectDefinitionId());
    }

    protected List<ObjectEntry> doGetRange(DynamicQuery dynamicQuery, int start, int end) {
        return this._objectEntryLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    protected String[] doGetUserIdFieldNames() {
        return ObjectUADConstants.USER_ID_FIELD_NAMES_OBJECT_ENTRY;
    }

    protected DynamicQuery getSearchDynamicQuery(long userId, long[] groupIds, String keywords, String orderByField, String orderByType) {
        DynamicQuery dynamicQuery = this.getDynamicQuery(userId);
        if (ArrayUtil.isNotEmpty((long[])groupIds)) {
            dynamicQuery.add(RestrictionsFactoryUtil.in((String)"groupId", (Object[])ArrayUtil.toLongArray((long[])groupIds)));
        } else {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)0L));
        }
        if (Validator.isNotNull((String)keywords)) {
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)RestrictionsFactoryUtil.ilike((String)"externalReferenceCode", (Object)StringUtil.quote((String)keywords, (char)'%')), (Criterion)RestrictionsFactoryUtil.eq((String)"objectEntryId", (Object)GetterUtil.getLong((String)keywords))));
        }
        if (orderByField != null) {
            if (Objects.equals(orderByType, "desc")) {
                dynamicQuery.addOrder(OrderFactoryUtil.desc((String)orderByField));
            } else {
                dynamicQuery.addOrder(OrderFactoryUtil.asc((String)orderByField));
            }
        }
        return dynamicQuery;
    }
}

