/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.entry.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collections;
import java.util.Map;

public class ObjectEntryUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryUtil.class);

    public static JSONObject getPayloadJSONObject(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, String objectActionTriggerKey, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectEntry originalObjectEntry, String preferredLanguageId, User user) {
        return JSONUtil.put((String)"classPK", (Object)objectEntry.getObjectEntryId()).put("objectActionTriggerKey", objectActionTriggerKey).put("objectEntry", (Object)HashMapBuilder.putAll((Map)objectEntry.getModelAttributes()).put((Object)"creator", (Object)user.getFullName()).put((Object)"id", (Object)objectEntry.getObjectEntryId()).put((Object)"values", (Object)objectEntry.getValues()).build()).put("objectEntryDTO" + objectDefinition.getShortName(), ObjectEntryUtil._toDTO(dtoConverterRegistry, jsonFactory, objectEntry, user)).put("originalObjectEntry", () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return HashMapBuilder.putAll((Map)originalObjectEntry.getModelAttributes()).put((Object)"values", (Object)originalObjectEntry.getValues()).build();
        }).put("originalObjectEntryDTO" + objectDefinition.getShortName(), () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return ObjectEntryUtil._toDTO(dtoConverterRegistry, jsonFactory, originalObjectEntry, user);
        }).put("preferredLanguageId", preferredLanguageId);
    }

    private static Map<String, Object> _toDTO(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, ObjectEntry objectEntry, User user) {
        DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(ObjectEntry.class.getName());
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + ObjectEntry.class.getName()));
            }
            return objectEntry.getModelAttributes();
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), dtoConverterRegistry, null, user.getLocale(), null, user);
        try {
            JSONObject jsonObject = jsonFactory.createJSONObject(jsonFactory.looseSerializeDeep(dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, (Object)objectEntry)));
            return jsonObject.toMap();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return objectEntry.getModelAttributes();
        }
    }
}

