/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.workflow;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryWorkflowHandler
extends BaseWorkflowHandler<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryWorkflowHandler.class);
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;

    public ObjectEntryWorkflowHandler(ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService) {
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
    }

    public String getClassName() {
        return this._objectDefinition.getClassName();
    }

    public String getTitle(long classPK, Locale locale) {
        try {
            ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(classPK);
            return objectEntry.getTitleValue();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return "";
        }
    }

    public String getType(Locale locale) {
        return this._objectDefinition.getLabel(locale);
    }

    public boolean isVisible(Group group) {
        return !group.isSite() || Objects.equals("site", this._objectDefinition.getScope());
    }

    public ObjectEntry updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._objectEntryLocalService.updateStatus(userId, classPK, status, serviceContext);
    }
}

