/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.sort;

import com.liferay.object.internal.sort.BaseSortDSLQueryVisitor;
import com.liferay.object.internal.sort.Sort;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.OrderByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.expression.AggregateExpression;
import com.liferay.petra.sql.dsl.spi.query.OrderBy;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Objects;
import java.util.Stack;

public class ObjectEntryFieldSortDSLQueryVisitor
extends BaseSortDSLQueryVisitor {
    public ObjectEntryFieldSortDSLQueryVisitor(ObjectFieldLocalService objectFieldLocalService) {
        super(objectFieldLocalService, null);
    }

    @Override
    public DSLQuery visit(DSLQuery dslQuery, Sort sort) throws PortalException {
        ObjectDefinition objectDefinition = sort.getObjectDefinition();
        ObjectField objectField = this.objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), sort.getFieldName());
        Column columnExpression = null;
        Table fieldTable = null;
        String prefix = "";
        if (objectField == null) {
            Column column = this.objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), sort.getFieldName());
            fieldTable = this.getAliasedTable(this._getSuffix(sort), column.getTable());
            columnExpression = fieldTable.getColumn(sort.getFieldName());
        } else {
            fieldTable = this.getAliasedTable(this._getSuffix(sort), this.objectFieldLocalService.getTable(objectDefinition.getObjectDefinitionId(), objectField.getName()));
            columnExpression = this._getColumnExpression(objectField, fieldTable);
            if (Objects.equals(objectField.getDBType(), "Boolean")) {
                prefix = "AGGREGATION_BOOLEAN_";
            }
        }
        if (!this.contains(dslQuery, fieldTable)) {
            dslQuery = this.addLeftJoin(this.getPrimaryKeyColumn(fieldTable), null, dslQuery, fieldTable);
        }
        OrderByExpression orderByExpression = this._getOrderByExpression(this._isParentComplexField(sort), (Expression<?>)columnExpression, prefix, sort.isReverse());
        Stack<BaseASTNode> allBaseASTNodes = this.getAllBaseASTNodes(OrderByStep.class, dslQuery);
        OrderByStep orderByStep = (OrderByStep)allBaseASTNodes.pop();
        if (allBaseASTNodes.peek() instanceof OrderBy) {
            OrderBy orderBy = (OrderBy)allBaseASTNodes.pop();
            OrderBy baseASTNode = new OrderBy((OrderByStep)orderBy.getChild(), (OrderByExpression[])ArrayUtil.append((Object[])orderBy.getOrderByExpressions(), (Object)orderByExpression));
            return this.updateParents((BaseASTNode)baseASTNode, allBaseASTNodes);
        }
        OrderBy baseASTNode = new OrderBy(orderByStep, new OrderByExpression[]{orderByExpression});
        return this.updateParents((BaseASTNode)baseASTNode, allBaseASTNodes);
    }

    private Expression<?> _getColumnExpression(ObjectField objectField, Table table) {
        if (objectField.compareBusinessType("AutoIncrement")) {
            return table.getColumn(objectField.getSortableDBColumnName());
        }
        Column column = table.getColumn(objectField.getDBColumnName());
        if (column.getSQLType() == 2005) {
            return DSLFunctionFactoryUtil.castClobText((Expression)column);
        }
        return column;
    }

    private OrderByExpression _getOrderByExpression(boolean aggregate, Expression<?> expression, String prefix, boolean reverse) {
        if (reverse) {
            if (aggregate) {
                expression = new AggregateExpression(false, expression, prefix + "max");
            }
            return expression.descending();
        }
        if (aggregate) {
            expression = new AggregateExpression(false, expression, prefix + "min");
        }
        return expression.ascending();
    }

    private String _getSuffix(Sort sort) {
        if (this._isParentComplexField(sort)) {
            return StringUtil.replace((String)StringUtil.removeLast((String)sort.getFieldPath(), (String)('/' + sort.getFieldName())), (char)'/', (char)'_');
        }
        return null;
    }

    private boolean _isParentComplexField(Sort sort) {
        return !StringUtil.equals((String)sort.getFieldName(), (String)sort.getFieldPath());
    }
}

