/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=LongText"}, service={ObjectFieldBusinessType.class})
public class LongTextObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"maxLength", "showCounter"});
    }

    public String getDBType() {
        return "Clob";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDDMFormFieldTypeName(boolean localized) {
        if (localized) {
            return "localizable_text";
        }
        return this.getDDMFormFieldTypeName();
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-text-that-up-to-65,000-characters");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "long-text");
    }

    public String getName() {
        return "LongText";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        return HashMapBuilder.put((Object)"displayStyle", (Object)"multiline").putAll(super.getProperties(objectField, objectFieldRenderingContext)).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectField, objectFieldSettings);
        this.validateRelatedObjectFieldSettings(objectField, "showCounter", "maxLength", this.getObjectFieldSettingsValues(objectFieldSettings));
    }
}

