/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectViewFilterColumnException;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContext;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributor;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributorRegistry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.service.base.ObjectViewFilterColumnLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectViewPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectViewFilterColumn"}, service={AopService.class})
public class ObjectViewFilterColumnLocalServiceImpl
extends ObjectViewFilterColumnLocalServiceBaseImpl {
    private static final Set<String> _filterableObjectFieldBusinessTypes = Collections.unmodifiableSet(SetUtil.fromArray((Object[])new String[]{"MultiselectPicklist", "Picklist", "Relationship"}));
    private static final Set<String> _filterableObjectFieldNames = Collections.unmodifiableSet(SetUtil.fromArray((Object[])new String[]{"status", "createDate", "modifiedDate"}));
    @Reference
    private ObjectFieldFilterContributorRegistry _objectFieldFilterContributorRegistry;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectViewPersistence _objectViewPersistence;

    public List<ObjectViewFilterColumn> addObjectViewFilterColumns(User user, ObjectView objectView, List<ObjectViewFilterColumn> objectViewFilterColumns) throws PortalException {
        this._validate(objectView.getObjectDefinitionId(), objectViewFilterColumns);
        return TransformUtil.transform(objectViewFilterColumns, objectViewFilterColumn -> {
            ObjectViewFilterColumn newObjectViewFilterColumn = this.objectViewFilterColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewFilterColumn.setCompanyId(user.getCompanyId());
            newObjectViewFilterColumn.setUserId(user.getUserId());
            newObjectViewFilterColumn.setUserName(user.getFullName());
            newObjectViewFilterColumn.setObjectViewId(objectView.getObjectViewId());
            newObjectViewFilterColumn.setFilterType(objectViewFilterColumn.getFilterType());
            newObjectViewFilterColumn.setJSON(objectViewFilterColumn.getJSON());
            newObjectViewFilterColumn.setObjectFieldName(objectViewFilterColumn.getObjectFieldName());
            return (ObjectViewFilterColumn)this.objectViewFilterColumnPersistence.update((BaseModel)newObjectViewFilterColumn);
        });
    }

    public ObjectViewFilterColumn updateObjectViewFilterColumn(long objectViewFilterColumnId, long objectViewId, String filterType, String json, String objectFieldName) throws PortalException {
        ObjectView objectView = this._objectViewPersistence.findByPrimaryKey(objectViewId);
        ObjectViewFilterColumn objectViewFilterColumn = this.objectViewFilterColumnPersistence.findByPrimaryKey(objectViewFilterColumnId);
        objectViewFilterColumn.setFilterType(filterType);
        objectViewFilterColumn.setJSON(json);
        objectViewFilterColumn.setObjectFieldName(objectFieldName);
        this._validate(objectView.getObjectDefinitionId(), Collections.singletonList(objectViewFilterColumn));
        return (ObjectViewFilterColumn)this.objectViewFilterColumnPersistence.update((BaseModel)objectViewFilterColumn);
    }

    private void _validate(long objectDefinitionId, List<ObjectViewFilterColumn> objectViewFilterColumns) throws PortalException {
        for (ObjectViewFilterColumn objectViewFilterColumn : objectViewFilterColumns) {
            if (Validator.isNull((String)objectViewFilterColumn.getObjectFieldName())) {
                throw new ObjectViewFilterColumnException("Object field name is null");
            }
            ObjectField objectField = this._objectFieldPersistence.findByODI_N(objectDefinitionId, objectViewFilterColumn.getObjectFieldName());
            if (!_filterableObjectFieldBusinessTypes.contains(objectField.getBusinessType()) && !_filterableObjectFieldNames.contains(objectField.getName())) {
                throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"Object field name \"", objectViewFilterColumn.getObjectFieldName(), "\" is not filterable"}));
            }
            if (Validator.isNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNull((String)objectViewFilterColumn.getJSON())) continue;
            if (Validator.isNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNotNull((String)objectViewFilterColumn.getJSON()) || Validator.isNotNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNull((String)objectViewFilterColumn.getJSON())) {
                throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"Object field name \"", objectViewFilterColumn.getObjectFieldName(), "\" needs to have the filter type and JSON specified"}));
            }
            ObjectFieldFilterContributor objectFieldFilterContributor = this._objectFieldFilterContributorRegistry.getObjectFieldFilterContributor(new ObjectFieldFilterContext(null, objectField.getObjectDefinitionId(), objectViewFilterColumn));
            objectFieldFilterContributor.validate();
        }
    }
}

