/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.tree;

import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.tree.Edge;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.Tree;
import com.liferay.object.tree.TreeFactory;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TreeFactory.class})
public class TreeFactoryImpl
implements TreeFactory {
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public Tree createObjectDefinitionTree(long objectDefinitionId) throws PortalException {
        return this._create(objectDefinitionId, (UnsafeFunction<Node, List<Node>, PortalException>)((UnsafeFunction)node -> TransformUtil.transform((Collection)this._objectRelationshipLocalService.getObjectRelationships(node.getPrimaryKey(), true), objectRelationship -> new Node(new Edge(objectRelationship.getObjectRelationshipId()), node, objectRelationship.getObjectDefinitionId2()))));
    }

    public Tree createObjectEntryTree(long objectEntryId) throws PortalException {
        UnsafeFunction unsafeFunction = node -> {
            ObjectEntry parentObjectEntry = this._objectEntryLocalService.fetchObjectEntry(node.getPrimaryKey());
            ArrayList childrenNodes = new ArrayList();
            for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(parentObjectEntry.getObjectDefinitionId(), true)) {
                childrenNodes.addAll(TransformUtil.transform((Collection)this._objectEntryLocalService.getOneToManyObjectEntries(parentObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), parentObjectEntry.getPrimaryKey(), true, null, -1, -1), objectEntry -> new Node(new Edge(objectRelationship.getObjectRelationshipId()), node, objectEntry.getObjectEntryId())));
            }
            return childrenNodes;
        };
        return this._create(objectEntryId, (UnsafeFunction<Node, List<Node>, PortalException>)unsafeFunction);
    }

    private Tree _create(long primaryKey, UnsafeFunction<Node, List<Node>, PortalException> unsafeFunction) throws PortalException {
        Node rootNode = new Node(null, null, primaryKey);
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            List nodes = (List)unsafeFunction.apply((Object)node);
            if (!ListUtil.isNotEmpty((List)nodes)) continue;
            node.setChildNodes(nodes);
            queue.addAll(nodes);
        }
        return new Tree(rootNode);
    }
}

