/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.internal.validation.rule.UniqueCompositeKeyObjectValidationRuleEngineImpl;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ObjectValidationRuleEngineRegistry.class})
public class ObjectValidationRuleEngineRegistryImpl
implements ObjectValidationRuleEngineRegistry {
    private ServiceTrackerMap<String, ObjectValidationRuleEngine> _serviceTrackerMap;

    public ObjectValidationRuleEngine getObjectValidationRuleEngine(long companyId, String key) throws PortalException {
        ObjectValidationRuleEngine objectValidationRuleEngine = (ObjectValidationRuleEngine)this._serviceTrackerMap.getService((Object)key);
        if (objectValidationRuleEngine == null) {
            objectValidationRuleEngine = (ObjectValidationRuleEngine)this._serviceTrackerMap.getService((Object)this._getCompanyScopedKey(companyId, key));
        }
        if (objectValidationRuleEngine == null || objectValidationRuleEngine instanceof UniqueCompositeKeyObjectValidationRuleEngineImpl && !FeatureFlagManagerUtil.isEnabled((String)"LPS-187854")) {
            throw new ObjectValidationRuleEngineException.NoSuchEngine(key);
        }
        return objectValidationRuleEngine;
    }

    public List<ObjectValidationRuleEngine> getObjectValidationRuleEngines(long companyId, String objectDefinitionName) {
        Collection objectValidationRuleEnginesCollection = this._serviceTrackerMap.values();
        return ListUtil.filter((List)ListUtil.fromCollection((Collection)objectValidationRuleEnginesCollection), objectValidationRuleEngine -> {
            boolean companyAllowed = true;
            if (objectValidationRuleEngine instanceof CompanyScoped) {
                CompanyScoped objectValidationRuleEngineCompanyScoped = (CompanyScoped)objectValidationRuleEngine;
                companyAllowed = objectValidationRuleEngineCompanyScoped.isAllowedCompany(companyId);
            }
            boolean objectDefinitionAllowed = true;
            if (objectValidationRuleEngine instanceof ObjectDefinitionScoped) {
                ObjectDefinitionScoped objectValidationRuleEngineObjectDefinitionScoped = (ObjectDefinitionScoped)objectValidationRuleEngine;
                objectDefinitionAllowed = objectValidationRuleEngineObjectDefinitionScoped.isAllowedObjectDefinition(objectDefinitionName);
            }
            return companyAllowed && objectDefinitionAllowed;
        });
    }

    public boolean hasObjectValidationRuleEngine(long companyId, String key) {
        return this._serviceTrackerMap.containsKey((Object)key) || this._serviceTrackerMap.containsKey((Object)this._getCompanyScopedKey(companyId, key));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectValidationRuleEngine.class, null, (serviceReference, emitter) -> {
            ObjectValidationRuleEngine objectValidationRuleEngine = (ObjectValidationRuleEngine)bundleContext.getService(serviceReference);
            String key = objectValidationRuleEngine.getKey();
            if (objectValidationRuleEngine instanceof CompanyScoped) {
                CompanyScoped objectValidationRuleEngineCompanyScoped = (CompanyScoped)objectValidationRuleEngine;
                key = this._getCompanyScopedKey(objectValidationRuleEngineCompanyScoped.getAllowedCompanyId(), key);
            }
            emitter.emit((Object)key);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getCompanyScopedKey(long company, String key) {
        return StringBundler.concat((Object[])new Object[]{key, "#", company});
    }
}

