/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.object.internal.configuration.FunctionObjectValidationRuleEngineImplConfiguration;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.catapult.PortalCatapult;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.internal.configuration.FunctionObjectValidationRuleEngineImplConfiguration"}, factory="com.liferay.object.internal.validation.rule.FunctionObjectValidationRuleEngineImpl", service={ObjectValidationRuleEngine.class})
public class FunctionObjectValidationRuleEngineImpl
implements CompanyScoped,
ObjectDefinitionScoped,
ObjectValidationRuleEngine {
    private static final Log _log = LogFactoryUtil.getLog(FunctionObjectValidationRuleEngineImpl.class);
    private List<String> _allowedObjectDefinitionNames;
    private long _companyId;
    @Reference
    private CompanyLocalService _companyLocalService;
    private FunctionObjectValidationRuleEngineImplConfiguration _functionObjectValidationRuleEngineImplConfiguration;
    @Reference
    private JSONFactory _jsonFactory;
    private String _key;
    private String _name;
    @Reference
    private PortalCatapult _portalCatapult;

    public Map<String, Object> execute(Map<String, Object> inputObjects, String script) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            JSONObject payloadJSONObject = this._getPayloadJSONObject(inputObjects);
            JSONObject creatorJSONObject = payloadJSONObject.getJSONObject("creator");
            JSONObject jsonObject = this._jsonFactory.createJSONObject(new String((byte[])this._portalCatapult.launch(this._companyId, Http.Method.POST, this._functionObjectValidationRuleEngineImplConfiguration.oAuth2ApplicationExternalReferenceCode(), payloadJSONObject, this._functionObjectValidationRuleEngineImplConfiguration.resourcePath(), creatorJSONObject.getLong("id")).get()));
            results.put("validationCriteriaMet", jsonObject.get("validationCriteriaMet"));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            results.put("validationCriteriaMet", false);
        }
        return results;
    }

    public long getAllowedCompanyId() {
        return this._companyId;
    }

    public List<String> getAllowedObjectDefinitionNames() {
        return this._allowedObjectDefinitionNames;
    }

    public String getKey() {
        return this._key;
    }

    public String getLabel(Locale locale) {
        return this._name;
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._allowedObjectDefinitionNames = StringUtil.asList((Object)properties.get("allowedObjectDefinitionNames"));
        this._companyId = ConfigurationFactoryUtil.getCompanyId((CompanyLocalService)this._companyLocalService, properties);
        this._functionObjectValidationRuleEngineImplConfiguration = (FunctionObjectValidationRuleEngineImplConfiguration)ConfigurableUtil.createConfigurable(FunctionObjectValidationRuleEngineImplConfiguration.class, properties);
        this._key = GetterUtil.getString((Object)properties.get("object.validation.rule"));
        this._name = GetterUtil.getString((Object)properties.get("name"));
    }

    private JSONObject _getPayloadJSONObject(Map<String, Object> objectEntry) {
        JSONObject originalJSONObject = this._jsonFactory.createJSONObject(objectEntry);
        JSONObject payloadJSONObject = JSONUtil.put((String)"creator", (Object)originalJSONObject.getJSONObject("creator")).put("dateCreated", originalJSONObject.get("dateCreated")).put("dateModified", originalJSONObject.get("dateModified")).put("externalReferenceCode", originalJSONObject.get("externalReferenceCode")).put("status", originalJSONObject.get("status"));
        JSONObject propertiesJSONObject = originalJSONObject.getJSONObject("properties");
        for (String key : propertiesJSONObject.keySet()) {
            payloadJSONObject.put(key, propertiesJSONObject.get(key));
        }
        return payloadJSONObject;
    }
}

